Ext.define('Academia.view.course.readingmaterial.readingmaterialinformation.InvtItemMasterReadingStockDetailGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.invtitemmasterreadingstockdetailgrid',
	store : 'course.readingmaterial.InvtItemMasterReadingStockDetailStore',
	title: getCommonTranslation('LIST_OF_COURSE_READING_MATERIAL'),
	border: true,
	autoScroll: true,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	dockedItems : [ {
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
		      xtype: 'custompagingtoolbar',
	            plugins:['pagesize'],
			store : 'course.readingmaterial.InvtItemMasterReadingStockDetailStore',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		} ]
	}],
	initComponent: function() {
        var grid=this;                   
        grid.addExportToolBarItems(grid);
        this.callParent(arguments);     
 },
	tbar: [{
        xtype: 'button',
        itemId: 'btnAdd',
        tooltip: getCommonTranslation('ADD'),
        glyph: ICONGLYPH.ADDGLYPH
    }],
	columns : [{
		header :getCommonTranslation('ACADEMYLOCATION'),
		dataIndex : 'id',
		flex:1,
		hidden:true
	},{
		header :getCommonTranslation('ACADEMYLOCATION'),
		dataIndex : 'academyLocation',
		flex:1
	},{
		header : getCommonTranslation('PURCHASE_DATE'),
		dataIndex : 'purchaseDate',
		flex:1,
		renderer:function(value) {
			return dateRender(value);
		}
	},{
		header : getCommonTranslation('READING_MATERIAL_CONDITION'),
		dataIndex : 'readingMaterialCondition',
		flex:1
	},{
		header : getCommonTranslation('VENDOR_NAME'),
		dataIndex : 'vendorName',
		flex:1
	},{
		header : getCommonTranslation('STOCK_INWARD'),
		dataIndex : 'stockInward',
		flex:1
	},{
		header : getCommonTranslation('CURRENT_STOCK'),
		dataIndex : 'currentStock',
		flex:1
	},{
		header : getCommonTranslation('NO_OF_DOCUMENT'),
		dataIndex : 'noOfDocument',
		flex:1,
		renderer:function(value){
			if(value>0){
				return  '<a href="#">'+value+'</a>';
			}else{
				return '0';
			}
		}
	}]
});
