/**
 * By Utsav 
 */
Ext.define('Academia.view.course.topic.TopicForm', {
	extend: 'Ext.window.Window',
	//extend: 'Academia.view.common.IdGeneratorCustomForm',
	alias: 'widget.topicform',
	modal: true,
	resizable:true,
	title: getCommonTranslation('TOPIC'),
	items: [{
		xtype: 'dynamicfieldformwin',
		customFieldEntity:CONSTANTS.COURSE_TOPIC_CD,
		columns: 2,
		method: 'POST',
		plugins : "formlabelrequired",
		defaults: {
			labelAlign: 'top',
			width:226
		},
		standardSubmit: false,
		items: [{
			xtype:'hidden',
			name:'id'
		},{
			xtype:'hidden',
			name:'version'
		},{
			xtype:'hidden',
			name:'topicCount',
			itemId:'topicCount'	
		},{
			xtype : 'fieldcontainer',
			width : '100%',
			layout : {
				type : 'hbox'
			},
			defaults : {
				width : 226,
				labelAlign : 'top'
			},
			items : [{
				xtype: 'numberfield',
				minValue:0,
				hideTrigger:true,
				itemId:'topicSequence',
				name: 'topicSequence',
				allowDecimals:false,
				maxValue:999,
				maxLength:3,
				allowBlank:false,
				fieldLabel: getCommonTranslation('TOPIC_SEQUENCE')
			},{
				xtype: 'textfield',
				name: 'topicCode',
				itemId:'topicCode',
				maxLength:45,
				allowDecimals:true,
				decimalPrecision: 2,
				minValue: 0,
				maskRe: /[a-zA-Z0-9.-\s]/,
                regex: /^-?[a-zA-Z0-9\s]*(\.[a-zA-Z0-9]{1,2})?$/,
				allowBlank:false,
				enforceMaxLength : true,
				fieldLabel: getCommonTranslation('TOPIC_CODE')
			}]},{
				xtype:'displayfield',
				name:'topicNameMssg',
				hidden:true	
			},{
				xtype:'displayfield',
				name:'topicSequenceMssg',
				hidden:true	
			},
			{
				xtype:'displayfield',
				name:'topicCodeMssg',
				hidden:true	
			},
			{
				xtype: 'fieldcontainer',
				width:'100%',
				layout: {
					type: 'hbox'
				},
				defaults :{
					width: 226,
					labelAlign:'top'
				},
				items:[{	
					xtype: 'textfield',
					name: 'topicName',
					itemId:'topicName',
					maxLength:100,
					allowBlank:false,
					fieldLabel: getCommonTranslation('TOPIC_NAME')
				}]},
				{
			  	xtype: 'fieldcontainer',
			    width: 'auto',
			    layout: {
			         type: 'hbox'
			     },
			     defaults: {
			         labelAlign: 'top',
			         width:226
			     },
			    items: [{
			        xtype: 'textarea',
		            name: 'topicDescription',
		            itemId:'topicDescription',
		            fieldLabel: getCommonTranslation('TOPIC_DESCRIPTION'),
		            width:460,
		            maxLength:1000
			    }]
			     },{
				xtype : 'fieldcontainer',
				width : '100%',
				layout : {
					type : 'hbox'
				},
				defaults : {
					width : 226,
					labelAlign : 'top'
				},
				items : [{
					xtype: 'numberfield',
					minValue:0,
					maxValue:999,
					maxLength:3,
					hideTrigger:true,
					name: 'noOfSessions',
					itemId:'noOfSessionsId',
					fieldLabel: getCommonTranslation('NO_OF_SESSIONS')
				},{
					xtype: 'numberfield',
					allowDecimals:false,
					minValue:0,
					maxValue:999,
					maxLength:3,
					hideTrigger:true,
					name: 'topicMinutes',
					itemId: 'topicMinutes',
					fieldLabel: getCommonTranslation('TOPIC_MINUTES')
				}]},{
					xtype : 'fieldcontainer',
					width : '100%',
					layout : {
						type : 'hbox'
					},
					defaults : {
						width : 226,
						labelAlign : 'top'
					},
					items : [{
						xtype: 'customcombobox',
						name: 'topicDepth',
						fieldLabel: getCommonTranslation('TOPIC_IN_DEPTH'),
						store:'course.coursetopic.TopicDepthStore',
						valueField:'id',
						displayField:'value',
						itemId: 'topicDepth',
						editable:false,
					},{
						xtype      : 'fieldcontainer',
						items:[{
							xtype: 'radiogroup',
							style:{marginLeft:'-2px !important'},
							itemId:'whetherCompulsoryId',
							name:'whetherCompulsoryId',
							labelAlign: 'top',
							fieldLabel : getCommonTranslation('TOPIC_IS_COMPULSORY'),
							columns: 2,
							vertical: true,
							items: [
								{
									boxLabel  : getCommonTranslation('YES'),
									name      : 'whetherCompulsory',
									inputValue: true,
									checked : true
								}, {
									boxLabel  : getCommonTranslation('NO'),
									name      : 'whetherCompulsory',
									inputValue: false		                     
								}]
						}]
					}
					]},{
						xtype:'displayfield',
						name:'sessionMssg',
						hidden:true	
					},

					{
						xtype:'fieldcontainer',
						layout: {
							type: 'hbox'
						},
						items: [{
							xtype: 'button',
							text: getCommonTranslation('SAVE'),
							itemId: 'topicSaveBtnId',
							ui: 'CustomBtnSubmit',
							scale: CONSTANTS.BUTTONSIZE,
							formBind: true
						}, {
							xtype: 'button',
							text: getCommonTranslation('CANCEL'),
							itemId: 'topicCancelBtnId',
							ui: 'CustomBtnCancel',
							scale: CONSTANTS.BUTTONSIZE		             
						}]
					}]
	}]
});