/**
 * @author Utsav Chandvaniya
 * 
 */
Ext.define('Academia.view.coursetransaction.coursereading.CourseReadingSearch', {   
	extend : 'Ext.form.FormPanel',
	alias : 'widget.coursereadingsearch',  
	plugins : "formlabelrequired",
    autoScroll: false,
    frame: false,
	cls:'customSearchPanel',
    layout: 'vbox',
    method: 'POST',
    standardSubmit: false,
    items: [
            {

            	xtype : 'fieldcontainer',
            	width: 'auto',
            	layout : {
            		type : 'hbox'
            	},
            	defaults : {
            		width : 450,
            		labelAlign : 'top'
            	},
            	items : [{

            		xtype: 'multiselectcombofield',
            		width: 460,
            		//height: 'auto',
            		name: 'multiselectAcademyLocation',
            		cls: 'multiselectAcademyLocation',
            		itemId: 'multiselectAcademyLocationId',
            		allowBlank : false,
            		fieldLabel : getProgramandcourseTranslation('ACADEMY_LOCATION'),
//            		translationKey: 'ACADEMY_LOCATION',
            		store:'common.AcademyLocationNameSeparated',
            		displayField:'value',
            		valueField:'id',
            		matchFieldWidth:true,
            		queryMode:'local',
            		listConfig: {
            			listeners: {
            				beforeshow: function(picker) {
            					picker.width = picker.up('combobox').getSize().width;
            				}
            			},
            			loadingText: getCommonTranslation('SEARCHING'),
            			emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
            			getInnerTpl: function() {
            				return '<div class="search-item">' +
            				'{code}' +
            				'</div>';
            			}
            		}
            	
            	}]
            	
            },
            {
       /* xtype: 'form',
        width: '100%',
        items: [{*/
            xtype: 'fieldcontainer',
            layout: 'hbox',
            defaults: {
                width: 226,
                labelAlign: 'top'
            },
            items :[{
            	xtype: 'customcombobox',
            	fieldLabel: getCourseTxCommonTranslation('PROGRAM'),
            	name:'PROGRAM',
            	itemId: 'programId',
            	store:'common.AssignedProgramStoreOfMultiAcademy',
            	displayField:'value',
            	valueField: 'id',
            	typeAhead:false,
            	forceSelection:true,
            	queryParam:'name',
            	minChars:3,
            	triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
            	enableKeyEvents  : 'true',
            	hideTrigger:false,
            	forceSelection:true,
            	emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            	listConfig: {
            		listeners: {
            			beforeshow: function(picker) {
            				picker.minWidth = picker.up('combobox').getSize().width;
            			}
            		},
            		loadingText: getCommonTranslation('SEARCHING'),
            		emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
            		getInnerTpl: function() {
            			return '<div class="search-item">' +
            			'{code} / {value}' +
            			'</div>';
            		}
            	}
            },{
                    	 xtype: 'customcombobox',
                         name: 'programId',
                         itemId: 'attendanceProgram',
                         fieldLabel: getPersonModuleTranslation('ATTENDANCE_PROGRAM'),
                         store:'servicerequest.programcoursesectiontransfer.ProgramForSectionTransfer',
                         hidden:true,
                         valueField: 'programId',
                         displayField: 'programName',
                         queryMode: 'local',
                         typeAhead:true,
                     	 forceSelection:true
                    },{
                    	xtype: 'customcombobox',
                    	fieldLabel: getCourseTxCommonTranslation('BATCH'),
                    	name:'BATCH',
                    	itemId: 'batchId',
                    	store:'enquiry.AcademicBatchStore',
                    	displayField: 'value',
                    	valueField: 'id',
                    	typeAhead:true,
                    	forceSelection:true
                    },{
                    	xtype: 'customcombobox',
                        name: 'batch',
                        itemId: 'batchCombo',
                        displayField: 'batchName',
                        store:'servicerequest.programcoursesectiontransfer.ProgramForSectionTransfer',
                        valueField: 'batchId',
                        queryMode: 'local',
                        hidden:true,
                        editable: false,
                        fieldLabel: getCommonTranslation('BATCH')
                    },{
                    	xtype: 'customcombobox',
                    	fieldLabel: getCourseTxCommonTranslation('PERIOD'),
                    	name:'PERIOD',
                    	itemId: 'periodId',
                    	store:'program.programDetails.programBatches.courseParameter.ProgramCoursePeriod',
                    	displayField: 'value',
                    	valueField: 'id',
                    	typeAhead:true,
                    	forceSelection:true
                    }
                    ]
				},{
				    xtype: 'fieldcontainer',
		            width: 'auto',
		            layout: 'hbox',
		            defaults: {
		                width: 226,
		                labelAlign: 'top'
		            },
		            items : [{
		            	xtype: 'customcombobox',
		            	fieldLabel: getCommonTranslation('COURSE_CODE_NAME'),
		            	itemId: 'courseId',
		            	name: 'COURSE', 
		            	store:'attendance.AssignedCoursesFacultyStore',
		            	valueField:'courseId',
		            	displayField:'courseCodeName',
		            	typeAhead:false,
		            	forceSelection:true,
		            	queryParam:'name',
		            	minChars:3,
		            	triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
		            	enableKeyEvents  : 'true',
		            	hideTrigger:false,
		            	forceSelection:true,
		            	emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
		            	listConfig: {
		            		listeners: {
		            			beforeshow: function(picker) {
		            				picker.minWidth = picker.up('combobox').getSize().width;
		            			}
		            		},
		            		loadingText: getCommonTranslation('SEARCHING'),
		            		emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
		            		getInnerTpl: function() {
		            			return '<div class="search-item">' +
		            			'{code} / {value}'  +
		            			'</div>';
		            		}
		            	}
		            },{
		            	xtype: 'customcombobox',
		            	fieldLabel: getCourseTxCommonTranslation('COURSE'),
		            	name:'studentCourse',
		            	itemId: 'studentCourseId',
		            	store:'coursetransaction.coursereading.CourseByPeriod',
		            	displayField: 'value',
		            	hidden:true,
		            	valueField: 'id',
		            	typeAhead:true,
		            	forceSelection:true
		            },{
		            	xtype: 'customcombobox',
		            	fieldLabel: getCourseTxCommonTranslation('COURSE'),
		            	itemId: 'course_period_Id',
		            	name: 'COURSE_PERIOD_ID', 
		            	//store:'coursetransaction.coursereading.CourseByPeriod',
		            	store:'course.AssignedPeriodCoursesFacultyStore',
		            	displayField:'courseCodeName',
		            	valueField:'courseId',
		            	typeAhead:true,
		            	hidden:true,
		            	forceSelection:true
		            },{
		    			xtype: 'customcombobox',
		    			name:'componentId',
		    			itemId: 'componentItemId',
		    			store:'course.coursetopic.CourseComponentStore',
		    			displayField: 'value',
		    			valueField: 'id',
		    			fieldLabel:getCourseTxCommonTranslation('COMPONENT'),
		    			typeAhead:true,
		    			forceSelection:true,
		    			hidden:true
		    		},{
		            	/*xtype: 'customcombobox',
		            	fieldLabel: getCourseTxCommonTranslation('TOPIC_TYPE,
		            	itemId:'topicTypeId',
		            	name: 'TOPIC_TYPE',
		            	store: 'coursetransaction.coursereading.TopicType',
		            	valueField: 'id',
		            	displayField: 'value',
		            	allowBlank:true,
		            	typeAhead:true,
		            	forceSelection:true	*/
		    			xtype: 'customcombobox',
			        	 fieldLabel: getCourseTxCommonTranslation('TOPICS'),
			        	 itemId:'materialTopic_Id',
			        	 name: 'MATERIAL_TYPE',
			        	 store: 'coursetransaction.coursereading.MaterialType',
			        	 valueField: 'id',
			        	 displayField: 'value',
			        	 disabled :true,
			        	 typeAhead:true,
			        	 forceSelection:true
		            }, {
		            	xtype: 'customcombobox',
		            	fieldLabel: getCourseTxCommonTranslation('READING_TYPE'),
		            	itemId: 'topicId',
		            	name: 'TOPIC_READING_ID',
//		            	store:'coursetransaction.coursereading.TopicReading',
		            	store:'course.readingmaterial.ReadingTypeStore',
		            	valueField:'id',
		            	displayField:'value',
		            	allowBlank:true
		            }
		            ]
				},{
					xtype: 'fieldcontainer',
					width: 'auto',
					layout: 'hbox',
					defaults: {
						width: 226,
						labelAlign: 'top'
					},
					items : [
					         { 
					        	 xtype: 'customcombobox',
					        	 name: 'readingName',
					        	 itemId:'readingNameId',
					        	 store:'course.readingmaterial.ReadingNameStore',
					        	 fieldLabel: getCourseTxCommonTranslation('READING_NAME'),
					        	 valueField: 'id',
					        	 displayField: 'code',
					        	 queryParam:'inventoryItemName',
					        	 minChars:3,
					        	 typeAhead:false,
					        	 disabled:true,
					        	 triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
					        	 enableKeyEvents  : 'true',
					        	 hideTrigger:false,
					        	 forceSelection:true,
					        	 emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
					        	 listConfig: {
					        		 listeners: {
					 					beforeshow: function(picker) {
					 						picker.minWidth = picker.up('combobox').getSize().width;
					 					}
					 				},
					        		 loadingText: getCommonTranslation('SEARCHING'),
					        		 emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					        		 getInnerTpl: function() {
					        			 return '<div class="search-item">' +
					        			 '{code}' +
					        			 '</div>';
					        		 }
					        	 }},{
					        	 xtype: 'customcombobox',
					        	 fieldLabel: getCourseTxCommonTranslation('TOPIC_TYPE'),
					        	 itemId:'topicTypeId',
					        	 name: 'TOPIC_TYPE',
					        	 store: 'coursetransaction.coursereading.TopicType',
					        	 valueField: 'id',
					        	 displayField: 'value',
					        	 allowBlank:true,
					        	 typeAhead:true,
					        	 forceSelection:true						 
					        	 /*
					        	 xtype: 'customcombobox',
					        	 fieldLabel: getCourseTxCommonTranslation('TOPICS'),
					        	 itemId:'materialTopic_Id',
					        	 name: 'MATERIAL_TYPE',
					        	 store: 'coursetransaction.coursereading.MaterialType',
					        	 valueField: 'id',
					        	 displayField: 'value',
					        	 disabled :true,
					        	 typeAhead:true,
					        	 forceSelection:true
					        	  */},
					         {
					        	 xtype: 'customcombobox',
					        	 fieldLabel: getCourseTxCommonTranslation('READING_COMPULSORY_OPTIONAL'),
					        	 name:'COMPULSORY_OPTIONAL',
					        	 itemId: 'compulsoryOptionalId',
					        	 store:'common.YesNoStatus',
					        	 displayField: 'value',
					        	 valueField: 'name',
					        	 typeAhead:true,
					        	 forceSelection:true,
					        	 allowBlank:true						 
					         }	         
					              
					        	  ]},{
					        		  xtype: 'fieldcontainer',
					        		  width: 'auto',
					        		  layout: 'hbox',
					        		  defaults: {
					        			  width: 226,
					        			  labelAlign: 'top'
					        		  },
					        		  items : [{
					        			  xtype: 'customcombobox',
					        			  fieldLabel: getCourseTxCommonTranslation('DISTRIBUTION_MODE'),
					        			  name:'DISTRIBUTION_MODE',
					        			  itemId: 'distributionModeId',
					        			  store:'coursetransaction.coursereading.DistributionMode',
					        			  displayField: 'value',
					        			  valueField: 'id',
					        			  typeAhead:true,
					        			  forceSelection:true,
					        			  allowBlank:true			
					        		  }
					        		  ]},{
		            xtype: 'fieldcontainer',
		            width: 'auto',
		            
		            items: [{
		                xtype: 'button',
		                text: getCommonTranslation('SEARCH'),
		                itemId: 'courseReadingSearchBtn',
		                formBind:true,
		                buttonAlign: 'left',
		                ui: 'CustomBtnSubmit',
		                scale: CONSTANTS.BUTTONSIZE
		            },{
		                xtype: 'button',
		                text: getCourseTxCommonTranslation('RESET'),
		                itemId: 'courseReadingResetBtn',
		                buttonAlign: 'left',
		                ui: 'CustomBtnCancel',
		                scale: CONSTANTS.BUTTONSIZE
		            }]
		        }]
    	//}]
});