/**
 * @author Rajkumar.Patidar
 */
Ext.define('Academia.view.coursetransaction.facultyTopicAssignment.ProdramBatchSearchForFTA', {
    extend: 'Ext.form.FormPanel',
    alias: 'widget.prodrambatchsearchforfta',
    frame: false,
	cls:'customSearchPanel',
  //  layout: 'vbox',
    method: 'POST',
    standardSubmit: false,
    defaults: {
        labelAlign: 'top',
        width: 226
    },
    items: [{
        xtype: 'fieldset',
        title: getCourseTxCommonTranslation('PROGRAM_BATCH_SECTION'),
//        translationKey:'PROGRAM_BATCH_SECTION',
//        collapsible: true,
        width:'100%',
        defaults: {
            width: 226,
            labelAlign: 'top'
        },
        items: [{
        	 xtype: 'customcombobox',
             itemId: 'programId',
             name: 'PROGRAM_ID',
             width: 460,
             fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
//             translationKey:'PROGRAM',
             store:'common.ProgramStore',
             displayField: 'valueCode',
             valueField: 'id',
//             allowBlank: false,
             typeAhead: true,
             forceSelection: true,
             triggerAction: 'all',
             queryParam:'programName',
             minChars:3,
             emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
	 			listConfig: {
	 				listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
	 				loadingText: getCommonTranslation('SEARCHING'),
	 				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	 				getInnerTpl: function() {
	 					return '<div class="search-item">' +
	 					'{value}' +
	 					'</div>';
	 				}
	 			}
        },{
            xtype: 'fieldcontainer',
            width: '100%',
            layout: 'hbox',
            defaults: {
                labelAlign: 'top',
                width: 226
            },
            items: [{
	                xtype: 'customcombobox',
	                itemId: 'batchId',
	                name: 'PROGRAM_BATCH_ID',
	                fieldLabel: getCourseTxCommonTranslation('BATCH'),
	                store: 'enquiry.AcademicBatchStore',
	                valueField: 'id',
	                displayField: 'value',
//	                allowBlank: false,
	                typeAhead: true,
	                forceSelection: true
	             },{
	            	 xtype: 'customcombobox',
	                 itemId: 'periodId',
	                 name: 'PROGRAM_BATCH_PERIOD_CONFIG_ID',
	                 fieldLabel: getCourseTxCommonTranslation('PERIOD'),
	                 store: 'program.programDetails.programBatches.courseParameter.ProgramCoursePeriod',
	                 valueField: 'id',
	                 displayField: 'value',
//	                 allowBlank: false,
	                 typeAhead: true,
	                 forceSelection: true
                  }]
	        },{
        	    xtype: 'customcombobox',
                itemId: 'courseId',
                width:460,
                name: 'COURSE_ID',
                fieldLabel: getCommonTranslation('COURSE_CODE_NAME'),
//                translationKey:'COURSE',
                store:'coursetransaction.facultytopicassignment.CourseComboStore',
                displayField: 'courseCodeName',
                valueField: 'id',
//                allowBlank: false,
                typeAhead: true,                
                queryParam:'qry',
            	minChars:3,
            	triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
            	enableKeyEvents  : 'true',
            	hideTrigger:false,
            	forceSelection:true,
            	emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            	listConfig: {
            		listeners: {
            			beforeshow: function(picker) {
            				picker.minWidth = picker.up('combobox').getSize().width;
            			}
            		},
            		loadingText: getCommonTranslation('SEARCHING'),
            		emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
            		getInnerTpl: function() {
            			return '<div class="search-item">' +
            			'{code} / {value}'  +
            			'</div>';
            		}
            	}
		    },{
				xtype: 'fieldcontainer',
				width: 'auto',
				layout: 'hbox',
				defaults: {
					width: 226,
					labelAlign: 'top'
				},
				items: [{
					xtype: 'customcombobox',
					name:'COMPONENT_ID',
					itemId: 'componentSectionItemId',
					store:'course.coursetopic.CourseComponentStore',
					displayField: 'value',
					valueField: 'id',
					fieldLabel:getCourseTxCommonTranslation('COMPONENT'),
//					allowBlank: false,
					typeAhead:true,
					forceSelection:true,
					hidden:true
				},{
					xtype: 'customcombobox',
					name:'SECTION_ID',
					itemId: 'courseSectionId',
					store:'coursetransaction.facultytopicassignment.CourseSectionByPeriodIDCourseIDStore',
					displayField: 'value',
					valueField: 'id',
					fieldLabel:getCourseTxCommonTranslation('SECTION'),
//					allowBlank:false,
					typeAhead:true,
					forceSelection:true
				}] 
           }]	
    },{
        xtype: 'fieldset',
        title: getCourseTxCommonTranslation('MULTPLE_FACULTY'),
//        collapsible: true,
        width: '100%',
        defaults: {
            width: 226,
            labelAlign: 'top'
        },
        items: [{
        	//  xtype: 'multiselectcombofield',
        	xtype: 'customcombobox',
        	itemId: 'facultyId',
        	width:460,
        	name: 'FACULTY_ID',
        	fieldLabel: getCourseTxCommonTranslation('FACULTY'),
        	store:'coursetransaction.facultytopicassignment.FacultyDetails',
        	displayField: 'value',
        	valueField: 'id',
        	queryParam:'codeOrName',
        	minChars:3,
        	allowBlank: false,
        	typeAhead:false,
        	triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
        	enableKeyEvents  : 'true',
        	hideTrigger:false,
        	emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
        	triggerAction: '',
        	forceSelection:true,
        	listConfig: {
        		listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
        		loadingText: getCommonTranslation('SEARCHING'),
        		emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
        		getInnerTpl: function() {
        			return '<div class="search-item">' +
        			'{value}' +
        			'</div>';
        		}
        	}
        }]
    }, {
        xtype: 'fieldset',
        title: getCourseTxCommonTranslation('MULTPLE_TOPICS'),
//        collapsible: true,
        width: '100%',
        defaults: {
            width: 226,
            labelAlign: 'top'
        },
        items: [{
        	  //  xtype: 'multiselectcombofield',
        	    xtype: 'customcombobox',
	            itemId: 'topicId',
	            name: 'TOPIC_ID',
	            width:460,
	            fieldLabel: getCourseTxCommonTranslation('TOPIC'),
	            store:'coursetransaction.coursereading.MaterialType',
	            displayField: 'value',
	            valueField: 'id',
//	            allowBlank: false,
	            disabled:true,
	            typeAhead: true,
	            forceSelection: true
	          }]
        },{
            xtype: 'fieldcontainer',
            width: '100%',
            
            items: [{
                xtype: 'button',
                text: getCourseTxCommonTranslation('SEARCH'),
                itemId: 'searchBtn',
                formBind : true,
                buttonAlign: 'left',
                ui: 'CustomBtnSubmit',
                scale: CONSTANTS.BUTTONSIZE
                },{
            	 xtype: 'button',
                 text: getCourseTxCommonTranslation('RESET'),
                 itemId: 'resetBtn',
                 ui: 'CustomBtnCancel',
                 scale: CONSTANTS.BUTTONSIZE
            }]
         }]
});