/*
 *  @author Rajkumar.patidar
 */
Ext.define('Academia.view.coursetransaction.homework.StudentHomeworkAssignmentSearch' ,{
	extend : 'Ext.form.FormPanel',
	alias : 'widget.studenthomeworkassignmentsearch',
	autoScroll: false,
	frame: false,
	cls:'customSearchPanel',
	method: 'POST',
	standardSubmit: false,
	plugins : "formlabelrequired",
	defaults: {
		labelAlign: 'top'
	},
	items:[{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
			xtype : 'customcombobox',
			name : 'studentAcademyLocation',
			itemId:'studentAcademyLocation',
			fieldLabel : getProgramandcourseTranslation('ACADEMY_LOCATION'),
			store:Ext.create('Academia.store.coursetransaction.studentenrollment.AcademyLocationsByAdmissionStore'),
			valueField : 'id',
			displayField : 'value',
			minChars:3,
			typeAhead : false,
			forceSelection:true,
			hideTrigger:false,
			triggerAction: 'all',
			queryParam:'qry',
            allowBlank: false,
            width: 460,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		}]
    }, {
		xtype: 'fieldcontainer',
		width: 'auto',
		layout: 'hbox',
		defaults: {
			width: 226,
			labelAlign: 'top'
		},
		items: [{
			xtype: 'customcombobox',
			name: 'studentProgram',
			itemId : 'studentProgramId',
			fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
			store : Ext.create('Academia.store.student.studentprofile.StudentProgramStore'),
			displayField : 'valueCode',
			valueField : 'id',
			queryMode : 'local',
			typeAhead : true,
			forceSelection:true,
			hideTrigger:false,
			triggerAction: 'all',
			queryParam:'programName',
			minChars:3,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}'  +
					'</div>';
				}
			}
		},{
			xtype: 'customcombobox',
			name: 'studentBatch',
			itemId : 'studentBatchId',
			fieldLabel: getCommonTranslation('BATCH'),
			store: Ext.create('Academia.store.student.studentprofile.StudentProgramStore'),
			displayField : 'value',
			valueField : 'id',
			disabled : true,
			forceSelection : true,
			editable:false
		},{
			xtype: 'customcombobox',
			name: 'studentPeriod',
			itemId : 'studentPeriodId',
			fieldLabel: getCommonTranslation('PERIOD'),
			store : Ext.create('Academia.store.student.studentprofile.StudentProgramStore'),
			displayField : 'value',
			valueField : 'id',
			disabled : true,
			forceSelection : true,
			editable:false
		}]
	},{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			labelAlign: 'top',
			width: 226
		},
		items: [{
			xtype : 'customcombobox',
			fieldLabel : getCourseTxCommonTranslation('SECTION'),
			width: 226,
			labelAlign: 'top',
			hidden: true,
			name : 'studentSection',
			itemId : 'studentSectionId',
			store:Ext.create('Academia.store.student.studentprofile.StudentProgramStore'),
			displayField : 'value',
			valueField : 'id',
			typeAhead : true,
			disabled:true,
			forceSelection : true,
			editable:false
		},{
			xtype: 'customcombobox',
			name: 'studentCourse',
			width: 226,
			itemId:'studentCourseId',
			fieldLabel:getCommonTranslation('COURSE_CODE_NAME'),
			store:Ext.create('Academia.store.attendance.facultyportal.AttendanceCourses'),
			disabled : true,
			valueField:'courseId',
			displayField:'courseCodeName',
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			hideTrigger:false,
			minChars:3,
			forceSelection : true,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			queryParam:'name',
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{courseCodeName}'  +
					'</div>';
				}
			}
		},{
			xtype: 'customcombobox',
			name: 'studentCourseVarient',
			itemId:'studentCourseVarientId',
			fieldLabel: getCourseTxCommonTranslation('HW_COURSE_VARIANT'),
			store:Ext.create('Academia.store.attendance.facultyportal.AttendanceCourseVariantStore'),
			displayField : 'courseVariantCode',
			valueField : 'id',
			disabled:true,
			forceSelection:true,
			typeAhead:true,
			editable:false,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},

				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}' +
					'</div>';
				}
			}
		}
		]},{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				labelAlign: 'top',
				width: 226
			},
			items:[{
				xtype: 'customcombobox',
				name: 'studentAassignmentType',
				itemId:'studentAassignmentTypeId',
				fieldLabel: getCourseTxCommonTranslation('HW_ASSIGNMENT_TYPE'),
				store:'coursetransaction.homework.HW_AssignmentTypeDropDown',
				displayField:'value',
				valueField:'id',
				forceSelection:true,
				typeAhead:true,
				disabled:true,
				editable:false

			},{
				xtype: 'customcombobox',
				name: 'studentAssignmentName',
				itemId: 'studentAssignmentNameId',
				fieldLabel: getCourseTxCommonTranslation('HW_ASSIGNMENT_NAME'),
				store:'coursetransaction.homework.AssignmentNameDropDown',
				displayField:'value',
				valueField:'id',
				forceSelection:true,
				typeAhead:true,
				queryParam:'searchName',
				minChars:3,
				typeAhead:false,
				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				enableKeyEvents  : 'true',
				hideTrigger:false,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				triggerAction: '',
				forceSelection:true,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{code} / {value}' +
						'</div>';
					}
				}
			}]
		},{ 
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				labelAlign: 'top',
				width: 226
			},
			items:[{
				xtype: 'datefield',
				name: 'studentFromDate',
				itemId:'studentFromDate',
				fieldLabel: getCourseTxCommonTranslation('HW_FROM_DATE'),
				endDateField : 'toDate',
				vtype : 'daterange',
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				}

			},{
				xtype: 'datefield',
				name: 'studentToDate',
				itemId:'studentToDate',
				fieldLabel: getCourseTxCommonTranslation('HW_TO_DATE'),
				startDateField : 'fromDate',
				vtype : 'daterange',
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				}
			}]
		},{
			xtype:'fieldcontainer',
			width: '100%',
			items:[{  
				xtype: 'button',
				itemId: 'searchBtn',
				text: getCommonTranslation('SEARCH'),
				ui:'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE,
				formBind : true
			},{
				xtype: 'button',
				text: getCourseTxCommonTranslation('RESET'),
				itemId: 'resetBtn',
				ui: 'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE
			}]
		}]
});
