
var TimeTableProgramBatchGridStore = Ext.create('Academia.store.program.programDetails.programBatches.courseParameter.TimeTableProgramBatchGridStore');
Ext.define('Academia.view.coursetransaction.sectioncoursecoverageplan.mastertimetable.TimeTableProgamBatchGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.timetableprogambatchgrid',
	store: TimeTableProgramBatchGridStore ,
	title: getCommonTranslation('TIME_TABLE_SESSIONS'),
	border: true,
	frame:false,
	selType:'checkboxmodel',
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},

	selModel: {
		mode:'MULTI',
		showHeaderCheckbox: true,
		allowDeselect: false,
		checkOnly : true
	},
	isGridConfigurable: true,
	enableColumnHide: false,
	dockedItems: [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype : 'custompagingtoolbar',
			plugins:['pagesize'],
			store: TimeTableProgramBatchGridStore ,
			emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
			displayInfo : true
		} ]
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid,false);
		this.callParent(arguments);     
	},
	tbar: [{
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
	},'->',{
		xtype: 'button',
		text:getCommonTranslation('EXPORT_TIMETABLE'),
		itemId:'exportReport',
		tooltip :getCommonTranslation('EXPORT_TIMETABLE'),
		disabled:true
	}],
	columns: [{
		header:getCommonTranslation('SECTION'),
		dataIndex: 'pbsSectionName',
		name:'pbsSectionName',
		flex:.1,
		sortable:true
	},{
		header:getCommonTranslation('COURSE_CODE'),
		dataIndex: 'courseCode',
		flex:.1,
		sortable:true
	},{
		header:getCommonTranslation('COURSE_NAME'),
		dataIndex: 'courseName',
		flex:.1,
		sortable:true
	},{
		header:getCommonTranslation('COURSE_VARIANT'),
		dataIndex: 'courseVariantName',
		flex:.1,
		sortable:true
	},{
		header:getCommonTranslation('SECTION'),
		dataIndex: 'sectionName',
		name:'cbsSectionName',
		flex:.1,
		sortable:true
	},{
		header:getCommonTranslation('FACULTY_CODE_TIMETABLEPROGRAMBATCHGRID'),
		dataIndex: 'facultyCode',
		flex:.1,
		sortable:true
	},
	{
		header:getCommonTranslation('FACULTY'),
		dataIndex: 'facultyName',
		flex:.1,
		sortable:true,
	},
	{
		header:getCommonTranslation('FACULTY_DEPARTMENT'),
		dataIndex: 'departmentName',
		flex:.1,
		sortable:true,
	},
	{
		header:getCommonTranslation('DAY'),
		dataIndex: 'day',
		flex:.1,
		sortable:true,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) {
				return getCommonTranslation(""+value);
			} else {
				return '-'
			}
		}
	},{
		header:getCommonTranslation('TIME_SLOT'),
		dataIndex: 'timeslot',
		flex:.1,
		sortable:true,
		renderer: function(date, record) {
			return timeFormatRender(record.record.data.startTime) + "-" + timeFormatRender(record.record.data.endTime);
		}
	},{
		header:getCommonTranslation('ROOM'),
		dataIndex: 'roomName',
		flex:.1,
		sortable:true
	}, {
		header:  getCommonTranslation('SELECT_RESOURCE_PROGRAM'),
		dataIndex: 'programName',
		flex:.1,
		sortable:true,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) {
				var valueArray = value.split(",");
				if(valueArray.length == 1){
					return value;
				}
				else{
					return '<a  href="#" >'+valueArray.length+'</a>';
				}
			} else {
				return '-';
			}
		}
	},{
		header:getCommonTranslation('BATCH') ,
		dataIndex: 'batchName',
		flex:.1,
		sortable:true,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) {
				var valueArray = value.split(",");
				if(valueArray.length == 1){
					return value;
				}
				else{
					return '<a  href="#" >'+valueArray.length+'</a>';
				}
			} else {
				return '-';
			}
		}
	},{
		header:getCommonTranslation('PERIOD'),
		dataIndex: 'periodName',
		flex:.1,
		sortable:true,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) {
				var valueArray = value.split(",");
				if(valueArray.length == 1){
					return value;
				}
				else{
					return '<a  href="#" >'+valueArray.length+'</a>';
				}
			} else {
				return '-';
			}
		}
	}]
});
