/**
 * @author Abhishek Bais
 */

Ext.define('Academia.view.coursetransaction.sectionmanagement.CBSSectionTransferCourseManageWin',{
	extend: 'Ext.window.Window',
	alias: 'widget.cbssectiontransfercoursemanagewin',
	autoScroll: true,
	title:getCourseTxCommonTranslation('TRANSFER_SECTION_DETAILS'),
	frame: true,
	autoScroll:true,
	modal:true,
	method: 'POST',
	items: [{
		xtype: 'form',
		//bodyPadding: '5 5 5 5',
		plugins : "formlabelrequired",
		layout: {
			type: 'vbox'
		},
		defaults: {
			labelAlign: 'top',
			width:'auto'
		},
		standardSubmit: false,
		items: [{
					xtype: 'hidden',
					name: 'id'
				},{
					xtype: 'hidden',
					name: 'enrolltype',
					itemId:'enrolltypeId'
				},{
					xtype : 'fieldcontainer',
					layout : 'hbox',
					defaults : {
						labelAlign: 'top',
						 width:226
			       	 },
					items:[{
						xtype:'displayfield',
						name : 'course',
						itemId : 'course',
						fieldLabel: getCourseTxCommonTranslation('COURSE'),
						hidden:true
					},{
						xtype:'displayfield',
						name : 'component',
						itemId: 'component',
						fieldLabel: getCourseTxCommonTranslation('COMPONENT'),
						hidden:true
					}]
				},{
					xtype : 'fieldcontainer',
					layout : 'hbox',
					defaults : {
						labelAlign: 'top',
						 width:226
			       	 },
					items:[{
					xtype: 'customcombobox',
					name:'sectionId',
					itemId: 'sectionId',
				    store:Ext.create('Academia.store.coursetransaction.sectionmanagement.CourseSectionCombo'),
				    fieldLabel: getCourseTxCommonTranslation('SECTION'),
					displayField: 'value',
					valueField: 'id',
					typeAhead:false,
					forceSelection:true,
					allowBlank:false
				},{
					xtype : 'datefield',
					anchor : '100%',
					fieldLabel : getCourseTxCommonTranslation('TRANSFER_DATE'),
					name : 'transferDate',
					itemId : 'transferDate',
					//--submitFormat : CONSTANTS.SUBMIT_DATE_FORMAT,
					vtype : 'daterange',
					allowBlank:false,
//					value: new Date(),
					listeners: {
						render: function(obj) {
							obj = dateFormatRender(obj);						
							obj.setValue(new Date());
						}
					}
				}]},{
					xtype: 'textareafield',
					name: 'sectionRule',
					width: 460,
					fieldLabel: getCourseTxCommonTranslation('REMARKS')
				
		},{	
			layout: {
				type: 'hbox'
			},
			style:{
         		 marginLeft:'0px'
         	 },
			items: [{
				xtype: 'button',
				action: 'Submit',
				text: getCourseTxCommonTranslation('SAVE'),
				formBind: true,
				itemId: 'submitBtn',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE
			  },{
				xtype: 'button',
				text: getCourseTxCommonTranslation('CANCEL'),
				ui: 'CustomBtnCancel',
				itemId: 'cancelBtn',
				scale: CONSTANTS.BUTTONSIZE
			}]
	  }]  
		}]	
});