/**
 * @author Rajkumar Patidar
 */
Ext.define('Academia.view.coursetransaction.sectionmanagement.CourseSectionSearch', {   
	extend : 'Ext.form.FormPanel',
	alias : 'widget.coursesectionsearch',
	autoScroll: true,
	frame: false,
	cls:'customSearchPanel',
	method : 'POST',
	layout : {
		type: 'anchor',
		layout: 'hbox'
	},
	standardSubmit : false,
	defaults: {
		labelAlign:'top',
		width:226
	},
	plugins : "formlabelrequired",
	bodyStyle:{ margin:CONSTANTS.LEFT_MARGIN_FOR_SEARCH_PANEL},
	items: [{
		xtype:'hidden',
		name:'id'
	},{	
		xtype:'fieldcontainer',
		width: '100%',
		layout: 'hbox',
			defaults: {
				labelAlign: 'top'
		},
		items:[{  
			xtype: 'multiselectcombofield',
		width: 700,
		height:55,
		name: 'multiselectAcademyLocation',
		itemId: 'multiselectAcademyLocationId',
		allowBlank : true,
		editable:false,
		fieldLabel : getProgramandcourseTranslation('ACADEMY_LOCATION'),
		store:Ext.create('Academia.store.common.AcademyLocationNameSeparated'),
		displayField:'value',
		valueField:'id',
		matchFieldWidth:true,
		maxLength:15000,
		autoloadStore: false,
		queryMode:'local',
		listConfig: {
			listeners: {
				beforeshow: function(picker) {
					picker.width = picker.up('combobox').getSize().width;
				}
			},
			loadingText: getCommonTranslation('SEARCHING'),
			emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
			getInnerTpl: function() {
				return '<div class="search-item">' +
				'{code}' +
				'</div>';
			}
		}
	     }]	
	   },{
		xtype:'fieldcontainer',
		width: '100%',
		layout : 'hbox',
		defaults: {
			labelAlign:'top',
			width:226
		},
		items:[{
			xtype : 'customcombobox',
			name : 'academicTerm',
			itemId : 'academicTerm',
			fieldLabel : getCommonTranslation('ACADEMIC_TERM'),
			store : Ext.create('Academia.store.user.UserAcademyTermsByALStore'),
			valueField : 'id',
			displayField : 'value',
			queryMode:'local',
			typeAhead : false,
			anyMatch : true
		},{
			xtype: 'customcombobox',
			name:'courseSectionId',
			itemId: 'courseSectionId',
			width:460,
			store:Ext.create('Academia.store.coursetransaction.sectionmanagement.BatchCourseSectionStore'),
			displayField: 'valueCode',
			valueField: 'id',
			fieldLabel:getCommonTranslation('COURSE_CODE_NAME'),
			allowBlank:false,
			minChars:3,
			forceSelection:true,
			style:{
				marginLeft:'05px'
			},
			queryParam:'courseName',
			typeAhead:false,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
						picker.width = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		},{
			xtype: 'customcombobox',
			name:'componentSectionId',
			itemId: 'componentSectionId',
			store:'course.coursetopic.CourseSectionComponentStore',
			displayField: 'value',
			valueField: 'id',
			fieldLabel:getCourseTxCommonTranslation('COMPONENT'),
			typeAhead:true,
			forceSelection:true,
			hidden: true
		}]
	},{	
		xtype:'fieldcontainer',
		width: '100%',
		 
		items:[{  
			xtype: 'button',
			itemId: 'searchBtn',
			formBind:true,
			text: getCourseTxCommonTranslation('SEARCH'),
			ui:'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE
	     },{
			xtype: 'button',
			itemId: 'resetBtn',
			text: getCourseTxCommonTranslation('RESET'),
			ui:'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE
		}]	
	}]
});