/**
 * @author Akshay Sharma
 */

Ext.define('Academia.view.coursetransaction.sectionmanagement.EnrollmentDateChangeWindow',{
	extend: 'Ext.window.Window',
	alias: 'widget.enrollmentdatechangewindow',
	autoScroll: true,
	title:getProgramandcourseTranslation('CHANGE_ENROLLMENT_DATE'),
	frame: true,
	autoScroll:true,
	modal:true,
	method: 'POST',
	items: [{
		xtype: 'dynamicfieldformwin',
		bodyPadding: '5 5 5 5',
		margin: 0,
		plugins : "formlabelrequired",
		layout: {
			type: 'vbox'
		},
		defaults: {
			labelAlign: 'top',
			width:'auto'
		},
		standardSubmit: false,
		items: [{
			xtype: 'hidden',
			name: 'id'
		},{
			xtype : 'fieldcontainer',
			flex : 1,
			layout : 'hbox',
			defaults : {
				labelAlign: 'left',
				labelWidth:150
			},
			items:[{
				xtype:'displayfield',
				name : 'StudentCount',
				fieldLabel: getProgramandcourseTranslation('NO_OF_STUDENT_SELECTED'),
				cls:'noOfStudentDisplayFieldCls'
			}]
		},{
			xtype : 'fieldcontainer',
			layout : 'hbox',
			defaults : {
				labelAlign: 'top',
				width:226
			},
			items:[{
				xtype : 'datefield',
				anchor : '100%',
				fieldLabel : getCommonTranslation('PROGRAM_PERIOD_START'),
				name : 'periodStartDate',
				itemId : 'periodStartDate',
				disabled: true,
				listeners: {
					render: function(obj) {
						obj = dateFormatRender(obj);
					}
				}
			},{
				xtype : 'datefield',
				anchor : '100%',
				fieldLabel : getCommonTranslation('PROGRAM_PERIOD_END'),
				name : 'periodEndDate',
				itemId : 'periodEndDate',
				disabled: true,
				listeners: {
					render: function(obj) {
						obj = dateFormatRender(obj);
					}
				}
			}]
		},{
			xtype : 'fieldcontainer',
			layout : 'hbox',
			defaults : {
				labelAlign: 'top',
				width:226
			},
			items:[{
				xtype : 'datefield',
				anchor : '100%',
				fieldLabel : getProgramandcourseTranslation('NEW_DATE_OF_ENROLLMENT'),
				name : 'newEnrollmentDate',
				itemId : 'newEnrollmentDate',
				allowBlank : false,
				maxValue:new Date(),
				//--submitFormat : CONSTANTS.DATE_FORMAT,
				listeners: {
					render: function(obj) {
						obj = dateFormatRender(obj);
						obj.setValue(new Date());
					}
				}
			}]
		},{
			xtype: 'fieldcontainer',
			defaults :{
				width: 460,
				labelAlign:'top'
			},
				items:[{
					xtype: 'radiogroup',
					cls: 'boldFieldLabelCls',
					fieldLabel: '<b class="menu-title">'+getProgramandcourseTranslation('FOR_MISSING_ATTENDANCE_RECORDS_MARK_STUDENT_ATTENANCE_AS')+'</b>',
					width:460,
					name: 'attendanceMarkType',
					itemId:'attendanceMarkType_ID',
					defaults: {
						flex: 1
					},
					items:[{ boxLabel: getProgramandcourseTranslation('MARK_ALL_PRESENT'), name: 'attendanceMarkType', inputValue: 'PRESENT', checked : true },
					       { boxLabel: getProgramandcourseTranslation('MARK_ALL_ABSENT'), name: 'attendanceMarkType', inputValue: 'ABSENT'}]
				}]
		},{	
			xtype : 'fieldcontainer',
			layout : 'hbox',
			defaults : {
				labelAlign: 'top'
			},
			items: [{
				xtype: 'button',
				action: 'Submit',
				text: getCourseTxCommonTranslation('SAVE'),
				formBind: true,
				itemId: 'submitBtn',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE
			},{
				xtype: 'button',
				text: getCourseTxCommonTranslation('CANCEL'),
				ui: 'CustomBtnCancel',
				itemId: 'cancelBtn',
				scale: CONSTANTS.BUTTONSIZE
			}]
		}]	
	}]     
});