

var variantId;

Ext.define('Academia.view.coursetransaction.studentcourseenrollment.studentenrollmentdetail.StudentPortalEnrollmentDetailGrid',{
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	store:'coursetransaction.studentenrollment.studentenrollmentdetail.StudentPortalEnrollmentDetail',
	alias:'widget.studentportalenrollmentdetailgrid',
	title: getProgramandcourseTranslation('STUDENT_COURSE_REGISTRATION'),
	border: true,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	isGridConfigurable : true,
	enableColumnHide: true,
	/*headerFix:{
		headerFix: true,
		portalIdsWithStructure: {
			'studentportalcourseregistrationtab':3
		}
	},*/
	header:{
		titlePosition: 0,
		items:[{
			xtype : 'button',		
			text:getCommonTranslation('INSTRUCTION_FOR_COURSE_REGISTRATION'),
			itemId:'instructionForCourseRegistrationSt',
			hidden:true,
			cls: 'linkBtnGridCls'
		}]    
	},
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid,false);
		this.callParent(arguments);     
	},
	tbar: [{
		xtype : 'button',		
		text:getCommonTranslation('PAY_AND_ENROLL'),
		itemId:'payAndEnrollButton',
		disabled:true
	},{
		xtype : 'button',		
		text:getCommonTranslation('ENROLL'),
		itemId:'newEnrollmentButton',
		hidden: true
	},{
		xtype : 'button',		
		text:getCommonTranslation('BULK_ENROLL'),
		itemId:'saveStudentBulkEnrollmentDetailItemId',
		disabled: true
	},{
		xtype : 'button',		
		text:getCommonTranslation('ENROLL'),
		itemId:'saveStudentEnrollmentDetailItemId',
		disabled: true,
		listeners:{
			afterrender: function(btn){
				var studentportalcourseregistration = btn.up('studentportalcourseregistration');
				if(!isNullOrEmpty(studentportalcourseregistration) && studentportalcourseregistration.title == getCommonTranslation("ALL")){
					btn.on('show',function(ebtn){
						ebtn.setVisible(false);
					});
				}
			}
		}
	},{
		xtype : 'button',		
		text:getCommonTranslation('UNENROLL'),
		itemId:'deEnrollmentDetailItemId',
		tooltip : getCommonTranslation('IT_WILL_KEEP_UNENROLLMENT_RECORDS'),
		disabled: true
	},{
		xtype : 'button',		
		text: getCommonTranslation('DEENROLL'),                   
		itemId:'deleteEnrollmentDetailItemId',
		tooltip : getCommonTranslation('IT_WONT_KEEP_DEENROLLMENT_RECORDS'),
		disabled: true
	},{ 

		xtype:'textfield',
		emptyText: getCommonTranslation('ENTER_CHAR_BY_COURSE'),
		width: 220,
		name:'registrationcoursegridsearch',
		itemId:'registrationcoursegridsearch',
		cls: 'SearchTextFieldWithSmallHeader'
	},{
		xtype:'displayfield',
		name : 'saveEnrollmentMsg',
		itemId : 'saveEnrollmentMsgId',
//		fieldLable:'Serosoft',
		//labelWidth:50,
		hidden:true
	},{
		xtype:'displayfield',
		name : 'startEnrollmentMsg',
		itemId : 'startEnrollmentMsg',
		hidden:true
	},{
		xtype:'displayfield',
		name : 'timerItemId',
		itemId : 'timerItemId',
		cls: 'timerCls'
	},{
		xtype: 'tbspacer',
		flex:1,
		itemId:'tbspacerItemId',
	},{
		xtype : 'button',		
		text:getCommonTranslation('PROOF_OF_REGISTRATION'),
		itemId:'proofOfRegistrationButton',
		disabled:true
	}],
	columns:[{
		header:getCourseTxCommonTranslation('SELECT'),
		dataIndex : 'sel',
		flex:.09,
		renderer: function(value, metadata,record,rowIndex,colIndex,store,view) {
			var approv=null;
			var request=null;
			var normal=null;
			for(var j=0;j<record.data.variantList.length;j++){

				var variant=record.data.variantList[j];
				if(variant.whetherApproved && variant.whetherRequested){
					approv=true;
				}else if(variant.whetherRequested){
					request=true;
				}else if(!variant.whetherRequested && !variant.whetherApproved && !variant.whetherRejected){
					normal=true;
				}
			}
			
			if(record.data.isEnrolledInTransferCredit){
				return 	Ext.String.format("<input type='checkbox' name='rowSel' style='display:none;'/>");
			}
			
			if(record.data.isHiddenCheck){
				return 	Ext.String.format("<input type='checkbox' name='rowSel' style='display:none;'/>");
			}

			if(record.data.mustOptCourse){
				record.set('isDisabled', true);
				return 	Ext.String.format("<input type='checkbox' name='rowSel' checked=checked disabled/>");
			}

			if(record.data.whetherPassed){
				record.set('isDisabled', true);
				return 	Ext.String.format("<input type='checkbox' name='rowSel' checked=checked disabled/>");
			}

			if(approv){
				record.set('isDisabled', true);
				return Ext.String.format("<input type='checkbox' name='rowSel' id='sel_"+record.data.courseId+"' value='checkbox' checked=checked disabled/>");
			}else if(request){
				record.set('isDisabled', false);
				return Ext.String.format("<input type='checkbox' name='rowSel' id='sel_"+record.data.courseId+"' value='checkbox' checked=checked/>");
			}else if(normal){
				record.set('isDisabled', false);
				return Ext.String.format("<input type='checkbox' name='rowSel' id='sel_"+record.data.courseId+"' value='checkbox'/>");
			}

		}
	},{
		header :getCommonTranslation('PERIOD'),
		dataIndex:'periodName',
		flex:.2,
		sortable : true
	},{
		header :getCommonTranslation('COURSE_CODE_NAME'),
		dataIndex:'courseCode',
		flex:.2,
		sortable : true,
		renderer: function(value, e, rec){
			if(rec.data.isOfferedYearlyBadge == true){
				var yearlyDiv = '<span title="'+getCommonTranslation('YEARLY')+'" class="yearlyBadgeCls">Y</span>';
			}
			else{
				var yearlyDiv = '';
			}

			if(value.split("/").length > 1){
				var code = value.split("/")[0];
				var name = rec.data.courseName;

				return yearlyDiv+code+"/"+name;
			}
			return yearlyDiv+value;
		}
	},/*{
	    header :getCommonTranslation('COURSE_NAME'),
	    dataIndex:'courseName',
	    flex:.2,
	    sortable : true
	},*/
	{
		header:getCommonTranslation('COURSE_CODE'),
		dataIndex:'courseCodeNew',
		flex:.1
	},{
		header:getCommonTranslation('COURSE_NAME'),
		dataIndex:'courseName',
		flex:.1,	
	},
	{
		header : getCommonTranslation('COURSE_GROUP'),
		dataIndex : 'courseGroupName',
		flex:.1,
		sortable : true,
		hidden:true,
		renderer:function(value,record,rowIndex,view){
			/*if(value==1){
	            var grid = view;
				var $this= this;
	            var courseGroupName = rowIndex.data.courseGroupName;
	            if(courseGroupName!=null && courseGroupName!='')
	            return courseGroupName; 
	        }
			else if(value!=null && value>1){
			  return '<a  href="#">'+value+'</a>';
			}else{
				return 0;
			}*/
			if(!isNullOrEmpty(rowIndex.data.courseGroupName)) {
				return rowIndex.data.courseGroupName;
			}else{
				return "-";
			}
			return value;
		}
	},{
		header:getCourseTxCommonTranslation('TYPE'),
		dataIndex:'whetherOptional',
		flex:.1,
		renderer:function(val, metaData, record){
			if(!val){
				return getCourseTxCommonTranslation('MANDATORY');
			}else if(val){
				return getCourseTxCommonTranslation('OPTIONAL');
			}

		}
	},{
		header:getCommonTranslation('CREDITS'),
		//dataIndex:'credits',
		dataIndex:'parameterizedCredits',
		flex:.1
	},{
		header:getCommonTranslation('COURSE_VARIANT'),
		dataIndex:'courseVariantId',
		flex:.1,
		editor : {
			xtype: 'customcombobox',
			//itemId:'courseVariant_Id',
			name:'courseVariant_Name',
			store:'coursetransaction.studentenrollment.studentenrollmentdetail.StudentPortalEnrollmentCourseVariantDropDown',
			valueField : 'variantId',
			displayField : 'variantCode',
			forceSelection : true,
			editable : false,
			typeAhead:false,
			listeners:{
				select: function(combo){
					var grid = combo.up('grid');
					var store = grid.getStore();
					try{
						var record = grid.getSelectionModel().getSelection()[0];
						var recData = record.data;

						if(!recData.isHiddenCheck){
							var checkField = Ext.query('[data-recordid='+grid.getSelectionModel().getSelection()[0].internalId+']')[0].children[0].children[0].children[0];
							var getcontroller=Academia.app.getController('Academia.controller.coursetransaction.studentcourseenrollment.StudentPortalCourseRegistrationController');
							var tempStore= grid.gridTempStore;//getcontroller.getStore('coursetransaction.studentenrollment.studentenrollmentdetail.TempStudentEnrollmentDetailData');
							tempStore.remove(record,true);
							if(document.getElementById('sel_'+record.data.courseId).checked == false){
								grid.config.totalModuleFees=grid.config.totalModuleFees+record.data.moduleFee;
								grid.config.countModuleFees=grid.config.countModuleFees+1;
							}
							checkField.setAttribute('checked','checked');
							checkField.checked = true;
							tempStore.loadRawData(record,true);

							var isCheckTrue = true;

							//-- not allowing user to select multiple record with same course id, different course group
							Ext.each(store.data.items, function(currentStoreItem){
								var currentStoreItemCourseId = currentStoreItem.data.courseId;
								var currentStoreItemCourseGroupId =currentStoreItem.data.courseGroupId;

								if(!isNullOrEmpty(currentStoreItemCourseGroupId) && !isNullOrEmpty(recData.courseId) && !isNullOrEmpty(recData.courseGroupId) && recData.courseId == currentStoreItemCourseId && recData.courseGroupId != currentStoreItemCourseGroupId){
									currentStoreItem.set('isHiddenCheck', isCheckTrue);
								}
							})
						}
						else{
							combo.reset();
							return false;
						}
					}
					catch(e){}
				}
			}
		},
		renderer:function(val,rec,record,rowIndex,colIndex,store,view){
			var grid = view;
			var $this= this;
			var store = grid.getStore();
			var models = grid.getStore().getRange();
			
			if(record.data.isEnrolledInTransferCredit == true){
				return "";
			}

			for(var j=0;j<record.data.variantList.length;j++){
				var variant=record.data.variantList[j];
				if(variant.whetherApproved && variant.whetherRequested){
					rec.tdCls = "comboboxdisable";
				}
				if(variant.whetherRequested){
					rec.tdCls = "comboboxdisable";
				}
			}
			if((val=='' || val== undefined)){
				//models[rowIndex].set("variantCode","");
				var variantCode = record.data.variantCode;
				if(variantCode !='' && variantCode != null){
					return variantCode;
				} else {
					rec.tdCls = 'gridInputCustomStyle'; 
					return getExaminationTranslation('SELECT_VARIANT');
				}
			} else if(val!='' && val!= undefined){
				var grid = view.up();
				var ddlRecord = grid.getMlpData();
				for (var i in ddlRecord) {
					if(val == ddlRecord[i].data.variantId) {
						models[rowIndex].set("variantCode",""+ddlRecord[i].data.variantCode);
						models[rowIndex].set("courseVariantId",ddlRecord[i].data.variantId);
					}
				}
				return record.data.variantCode;
			} else {
				rec.tdCls = 'gridInputCustomStyle'; 
				return getExaminationTranslation('SELECT_VARIANT');
			}	

		}
	},{
		header: getCommonTranslation('TIME_TABLE'),
		dataIndex:'timeTable',
		columnId:'timeTable',
		flex:.1,
		renderer:function(value, metaData, record, rowIndex, colIndex, store, view){
			return '<a href="#">View</a>';
		}
	},{
		header:getCommonTranslation('EXAM_CENTER'),
		dataIndex:'examCenterId',
		flex:.1,
		editor : {
			xtype: 'customcombobox',
			itemId: 'examCenterId',
			name: 'examCenterId',
			width: 135,
			labelAlign: 'top',
			store:Ext.create('Academia.store.enquiry.ExamCenterCSMStore'),
			valueField: 'id',
			displayField: 'value',
			forceSelection:true,
			editable : false,
			typeAhead:false,
			listeners:{
				select: function(combo){
					var grid = combo.up('grid');
					try{
						var record = grid.getSelectionModel().getSelection()[0];
						var checkField = Ext.query('[data-recordid='+grid.getSelectionModel().getSelection()[0].internalId+']')[0].children[0].children[0].children[0];
						var getcontroller=Academia.app.getController('Academia.controller.coursetransaction.studentcourseenrollment.StudentPortalCourseRegistrationController');
						var tempStore= grid.gridTempStore;//getcontroller.getStore('coursetransaction.studentenrollment.studentenrollmentdetail.TempStudentEnrollmentDetailData');
						record.data.examCenterName = combo.getDisplayValue()
//						record.set('examCenterName',combo.getDisplayValue());
						tempStore.remove(record,true);
						checkField.setAttribute('checked','checked');
						checkField.checked = true;
						tempStore.loadRawData(record,true);
					}
					catch(e){}
				}
			}
		},renderer:function(val,rec,record,rowIndex,colIndex,store,view){
			if(record.data.isEnrolledInTransferCredit == true){
        		return "";
        	}
			var examCenterName = record.data.examCenterName;
			for(var j=0;j<record.data.variantList.length;j++){
				var variant=record.data.variantList[j];
				if(record.data.examCenterId!=null&&variant.whetherApproved && variant.whetherRequested){
					rec.tdCls = "comboboxdisable";
				}else if(record.data.examCenterId==null && variant.whetherApproved && variant.whetherRequested){
					rec.tdCls = "comboboxdisable";
				}
			}
			if(examCenterName !='' && examCenterName != null){
				return examCenterName;
			} else {
				rec.tdCls = 'gridInputCustomStyle'; 
				for(var j=0;j<record.data.variantList.length;j++){
					var variant=record.data.variantList[j];
					if(record.data.examCenterId==null && variant.whetherApproved && variant.whetherRequested){
						rec.tdCls = "comboboxdisable";
						return getProgramandcourseTranslation('');
					}
				}
				return getCommonTranslation('SELECT_EXAM_CENTER');
			}
		}
	},{
		header:getCourseTxCommonTranslation('VARIANT_DETAILS'),
		dataIndex:'variantDetail1',
		flex:.1,
		columnId:'viewVariantDetail',
		hidden:true,
		renderer:function(value, metaData, record, rowIndex, colIndex, store, view){
			return '<a href="#">View</a>';
		}
	},{
		header : getCommonTranslation('MODULE_FEE'),
		dataIndex:'moduleFee',
		flex : .2
	},{
		header :getCommonTranslation('COURSE_STATUS'),
		dataIndex:'courseStatus',
		flex:.2,
		sortable : true
	},{
		header: getCommonTranslation('ADDITIONAL_REQUISITE'),
		dataIndex: 'additionalRequisite',
		flex: .2,
		soratable: false,
		renderer:function(value, metaData, record, rowIndex, colIndex, store, view){
			if(value){
				return '<a href="#">View</a>'; //preRequisiteJson, coRequisiteJson
			}
			else if(!isNullOrEmpty(record.raw.compulsorySet) && record.raw.compulsorySet.length){
				return '<a href="#">View</a>'; //corequisite
			}
			else if(!isNullOrEmpty(record.raw.preRequsitViewModels) && record.raw.preRequsitViewModels.length){
				return '<a href="#">View</a>'; //prereq
			}
		}
	},{
		header:getProgramandcourseTranslation('COURSE_ENROLLMENT_STATUS'),
		dataIndex:'courseEnrollmentStatus',
		flex:.1,
		sortable : true,
		renderer:function(value, metaData, record, rowIndex, colIndex, store, view){
			if(record.data.isEnrolledInTransferCredit){
				return  "Enrolled";
			}
			else{
				return value;
			}
		}
	}],
	plugins: [
		{
			ptype : 'cellediting',
			clicksToEdit: 1
		}
	],
	listeners: {
		edit: function(obj, editor, context){
			var this$= this;
			var grid = obj.grid;
			var storeGrid = grid.getStore();
			var flag=true;
			var models = grid.getStore().getRange();
			for(var i =0; i<storeGrid.data.length;i++){
				if(editor.rowIdx==i){

				}
			}
		}
	},

});