/**
 * @author Rajkumar.patidar
 */
Ext.define('Academia.view.coursetransaction.studymaterialdistribution.CourseReading', {
    extend: 'Ext.window.Window',
    alias: 'widget.coursereading',
    modal: true,
    autoScroll:true,
    title:getCourseTxCommonTranslation('DL_COURSE_READING'),
    maxHeight:600,
    items: [{
        xtype: 'form',
        id: 'courseReading',
        itemId: 'courseReading_Id',
        method: 'POST',
        autoScroll:true,
        margin: 0,
        bodyPadding: '10 10 10 10',
        layout: {
            type: 'vbox'
        },
        defaults: {
            labelAlign: 'top',
            autoScroll:true,
            width: 226
        },
        standardSubmit: false,
        plugins:"formlabelrequired",
        items: [{  
        	    xtype: 'hidden',
                name: 'id',
                itemId:'hiddenId'
            },{
        	xtype: 'customcombobox',
            name: 'courseVariant',
            itemId:'courseVariant_Id',
            fieldLabel:getCourseTxCommonTranslation('DL_COURSE_VARIANT'),
            store:'coursetransaction.studymaterialdistribution.CourseVariantDropDown',
            displayField:'code',
            valueField:'id',
            allowBlank: false
        },{
        	xtype: 'customcombobox',
            name: 'readingType',
            itemId:'readingType_Id',
            fieldLabel:getCourseTxCommonTranslation('DL_READING_TYPE'),
            store:'coursetransaction.studymaterialdistribution.ReadingTypeDropDown',
            displayField:'value',
            valueField:'id',
            allowBlank: false
        },{
        	xtype: 'customcombobox',
            name: 'readingName',
            itemId:'readingName_Id',
            fieldLabel:getCourseTxCommonTranslation('READING_NAME'),
            store:'coursetransaction.studymaterialdistribution.ReadingNameDropDown',
            displayField:'value',
            valueField:'id',
            allowBlank: false
        },{
            layout: {
                type: 'hbox'
            },
            style:{
            	marginLeft:'0px'
            },
            
            items: [{
                xtype: 'button',
                text: getCommonTranslation('SAVE'),
                itemId: 'SubmitBtn',
                ui: 'CustomBtnSubmit',
                scale: CONSTANTS.BUTTONSIZE,
                formBind: true
            },{
                xtype: 'button',
                text: getCommonTranslation('CANCEL'),
                itemId: 'CancelBtn',
                ui: 'CustomBtnCancel',
                scale: CONSTANTS.BUTTONSIZE
            }]
        }]
    }]
});