/**
 * @author Rajkumar.Patidar
 */

Ext.define('Academia.view.coursetransaction.studymaterialdistribution.DistributionWinforCourseReading',{
	//extend : 'Ext.form.FormPanel',
	extend:'Academia.view.common.IdGeneratorCustomForm',
	formCode : 'distributionListForm',
	customFieldEntity:CONSTANTS.STUDY_DISTRIBUTION_CUSTOM_FIELD,
	alias: 'widget.distributionwinforcoursereading',
	 style:{
	    	marginLeft:CONSTANTS.MARGIN_LEFT_FOR_FORM
	    },
	autoScroll: true,
	//title:getCourseTxCommonTranslation('COURSE_READING_DISTRIBUTION'),
	title:getCommonTranslation('COURSE_READING_DISTRIBUTION'),
	requires: ['Ext.ux.form.ItemSelector'],
	frame: true,
	autoScroll:true,
	plugins : "formlabelrequired",
	layout: {
		type: 'vbox'
	},
	defaults: {
		labelAlign: 'top',
		width:226
	},
	standardSubmit: false,
	items: [{
			xtype: 'hidden',
			name: 'id'
		  },{
			xtype:'fieldcontainer',
      	    layout:'hbox',
      	    width:'100%',
      	    defaults: {
      		   width: 226,
      		   labelAlign: 'top'
      	    },
      	    items:[{
					xtype: 'textfield',
					name: 'listName',
					itemId:'listName',
					fieldLabel: getCourseTxCommonTranslation('LIST_NAME'),
				    emptyText: getCommonTranslation('ID_AUTOGENERATE'),
				    readOnly:true
				},{
					xtype: 'datefield',
        		    name: 'createdDate',
        		    itemId:'createdDate',
        		  //--submitFormat: CONSTANTS.DATE_FORMAT,
        		    fieldLabel: getCourseTxCommonTranslation('CREATED_DATE'),
//        		    value: new Date(),
					listeners: {
						render: function(obj) {
							obj = dateFormatRender(obj);						
							obj.setValue(new Date());
						}
					}
				}]
		},{
			xtype:'fieldcontainer',
      	    layout:'hbox',
      	    width:'100%',
      	    defaults: {
      		   width: 226,
      		   labelAlign: 'top'
      	    },
      	    items:[{
	      	    	xtype: 'textfield',
					name: 'createdById',
					value:'1',
					hidden:true,
					readOnly:true,
					fieldLabel: getCourseTxCommonTranslation('CREATED_BY_ID')
				 },{
					xtype: 'textfield',
					name: 'createdByName',
					value:'System Admin',
					readOnly:true,
					fieldLabel: getCourseTxCommonTranslation('CREATED_BY_NAME')
				 }]	
		},{
			xtype:'fieldcontainer',
      	    layout:'hbox', 
      	    width:'100%',
      	    defaults: {
      		   width: 226,
      		   labelAlign: 'top'
      	    },
      	    items:[{
					xtype: 'customcombobox',
					name: 'distributionMode',
					itemId: 'distributionMode',
					fieldLabel: getCourseTxCommonTranslation('DISTRIBUTION_MODE'),
					store:'coursetransaction.studymaterialdistribution.DistributionModeStore',
					displayField:'value',
					valueField:'id',
					typeAhead:true,
					 allowBlank:false,
					forceSelection:true
				},{
					xtype: 'checkboxfield',
		            width: 'auto',
		            style:{marginTop:'20px'},
		            itemId:'associateWithAssignment',
		            labelAlign: 'right',
		            boxLabel: getCourseTxCommonTranslation('ASSOCIATE_WITH_ASSIGNMENT'),
		            name: 'associateWithAssignment',
		            inputValue : getCourseTxCommonTranslation('HOMEWORK_ASSIGNMENT'),
		            uncheckedValue: getCourseTxCommonTranslation('COURSE_READ')
				}]
		},{
			xtype: 'textareafield',
     	    name: 'remarks',
     	    width: 460,
     	    itemId:'remarks',
			fieldLabel: getCourseTxCommonTranslation('REMARKS')
		},{
		    xtype: 'multiselectcombofield',
			name: 'courses',
			width: 460,
			itemId: 'courses',
			fieldLabel: getCourseTxCommonTranslation('COURSES'),
			store:'coursetransaction.studymaterialdistribution.CoursesAllStore',
			displayField:'value',
			valueField:'id',
			allowBlank:false,
			autoloadStore:false,
			typeAhead:true,
			forceSelection:true
		},{
		    xtype: 'customcombobox',
			name: 'assignmentName',
			itemId: 'assignmentName',
			fieldLabel: getCourseTxCommonTranslation('ASSIGNMENT_NAME'),
			store:'coursetransaction.studymaterialdistribution.AssignmentNameStore',
			displayField:'value',
			valueField:'id',
			hidden:true,
			typeAhead:true,
			forceSelection:true
					
		 },{
			    xtype: 'multiselectcombofield',
				name: 'courseVariants',
				width: 460,
				itemId: 'courseVariants',
				fieldLabel: getCommonTranslation('COURSE_VARIANTS'),//getCourseTxCommonTranslation('COURSES'),
				store:'coursetransaction.studymaterialdistribution.CourseVarinatTempStore',
				displayField:'code',
				valueField:'id',
				disabled:true,
				autoloadStore:false,
				allowBlank:false,
				typeAhead:true,
				forceSelection:true
			/*	
			  xtype: 'itemselector',
	          name: 'courseVariants',
	          itemId: 'courseVariants',
	          style:{marginLeft:'-10px'},
	          autoScroll:true,
	          minHeight:150,
	          width: 460,
	          maxHeight:200,
	          imagePath: '../ux/css/images/',
	          store : 'coursetransaction.studymaterialdistribution.CourseVarinatTempStore',
	          displayField: 'code',
	          valueField: 'id',
	          fromTitle: getCourseTxCommonTranslation('AVAILABLE_VARIANTS'),
	          toTitle: getCourseTxCommonTranslation('SELECT_VARIANTS'),
	          msgTarget: 'side',
	          delimiter: null,
	          buttons: ['top', 'add', 'remove', 'bottom']
		*/},{
		    xtype: 'multiselectcombofield',
			name: 'courseVariantsEdit',
			width: 460,
			itemId: 'courseVariantsEdit',
			fieldLabel: getCommonTranslation('COURSE_VARIANTS'),//getCourseTxCommonTranslation('COURSES'),
			store:'coursetransaction.studymaterialdistribution.CourseVarinatEditStore',
			displayField:'code',
			valueField:'id',
			hidden:true,
			autoloadStore:false,
			typeAhead:true,
			forceSelection:true
	},{
			  xtype: 'radiogroup',
			  itemId:'autoApprove',
			  fieldLabel: getCourseTxCommonTranslation('AUTO_APPROVE'),
			  items:[
			       { boxLabel:getCourseTxCommonTranslation('YES'), name: 'autoApprove', inputValue: true ,checked:true },
			       { boxLabel:getCourseTxCommonTranslation('NO'), name: 'autoApprove', inputValue: false}
			       ]
		},{
		},{	
			  layout:'hbox',
			  style:{marginTop:'10px'},
			  style:{
			    	marginLeft:'0px'
			    },
			  items: [{
					xtype: 'button',
					action: 'Submit',
					text: getCourseTxCommonTranslation('SAVE'),
					formBind: true,
					itemId: 'SubmitBtn',
					ui: 'CustomBtnSubmit',
					scale: CONSTANTS.BUTTONSIZE
		      	 },{
					xtype: 'button',
					text: getCourseTxCommonTranslation('RESET'),
					ui: 'CustomBtnCancel',
					itemId: 'CancelBtn',
					scale: CONSTANTS.BUTTONSIZE
			      }]
	       }]
});