/**
 * @author Rajkumar.Patidar
 */

Ext.define('Academia.view.coursetransaction.studymaterialdistribution.StudentStatusWin',{
	extend: 'Ext.window.Window',
	alias: 'widget.studentstatuswin',
	title:getCourseTxCommonTranslation('STUDENT'),
	frame: true,
	autoScroll:true,
	modal:true,
	method: 'POST',
	maxHeight: 600,
	items: [{
		//xtype: 'form',
		xtype: 'customform',
		customFieldEntity:CONSTANTS.COURSE_READING_STUDENT_CUSTOM_FIELD,
		itemId:'studentstatusform',
		bodyPadding: '5 5 5 5',
		plugins : "formlabelrequired",
		layout: {
			type: 'vbox'
		},
		defaults: {
			labelAlign: 'top',
			width:500
		},
		standardSubmit: false,
		items: [{
			xtype: 'hidden',
			name: 'id'
		},{
			xtype:'fieldcontainer',
      	    layout:'hbox',
      	    defaults: {
      		   width: 226,
      		   labelAlign: 'top'
      	    },
      	    items:[{
					xtype: 'textfield',
					name: 'sentById',
					readOnly:true,
					hidden:true,
					value:'1',
					itemId:'sentById',
					fieldLabel: getCourseTxCommonTranslation('SENT_BY_ID'),
				    allowBlank:false
				},{
					xtype: 'textfield',
					name: 'sentByName',
					readOnly:true,
					value:'System Admin',
					itemId:'sentByName',
					fieldLabel: getCourseTxCommonTranslation('SENT_BY_NAME'),
				    allowBlank:false
					
				}]
		},{
			xtype:'fieldcontainer',
      	    layout:'hbox',
      	    defaults: {
      		   width: 226,
      		   labelAlign: 'top'
      	    },
      	    items:[{
	      	    	xtype: 'datefield',
	    		    name: 'sentDate',
	    		    itemId:'sentDate',
	    		    endDateField: 'receivedDate',
	    		    vtype: 'daterange',
	    		    allowBlank:false,
	      	    	editable:false,
	    		    fieldLabel: getCourseTxCommonTranslation('SENT_DATE'),
	    		  //--submitFormat: CONSTANTS.DATE_FORMAT,
    				listeners: {
    					render: function(field) {
    						return dateFormatRender(field);
    					}
    				}
					
				 }]	
		},{
			xtype: 'displayfield',
			name: 'errorMessage',
			itemId:'errorMessage',
			hidden:true
		},{	
			xtype:'fieldcontainer',
      	    layout:'hbox',
      	    defaults: {
      		   width: 226,
      		   labelAlign: 'top'
      	    },
      	    items:[{
	      	    	xtype: 'textfield',
					name: 'serviceProvider',
					itemId:'serviceProvider',
					hidden:true,
					fieldLabel: getCourseTxCommonTranslation('SERVICE_PROVIDER'),
			        allowBlank:true
      	         },{
      	        	xtype: 'textfield',
					name: 'consignmentRef',
					hidden:true,
					itemId:'consignmentRef',
					fieldLabel: getCourseTxCommonTranslation('CONSIGNMENT_REF'),
			        allowBlank:true
				 }]  
		},{
			xtype: 'textareafield',
     	    name: 'remarks',
     	    width: 460,
     	    itemId:'remarks',
			fieldLabel: getCourseTxCommonTranslation('REMARKS')
		},{
			xtype:'fieldcontainer',
      	    layout:'hbox',
      	    defaults: {
      		   width: 226,
      		   labelAlign: 'top'
      	    },
      	    items:[{
					xtype: 'datefield',
				    name: 'receivedDate',
				    itemId:'receivedDate',
		            startDateField: 'sentDate',
		            vtype: 'daterange',
		            hidden:true,
				    fieldLabel: getCourseTxCommonTranslation('RECIEVED_DATE'),
				  //--submitFormat: CONSTANTS.DATE_FORMAT,
    				listeners: {
    					render: function(field) {
    						return dateFormatRender(field);
    					}
    				}
	      	      },{
		        	 xtype: 'datefield',
		   		     name: 'returnDate',
		   		     vtype: 'daterange',
		   		     startDateField: 'sentDate',
		   		     hidden:true,
		   		     width: 226,
		 		     itemId:'returnDate',
		 		     fieldLabel: getCourseTxCommonTranslation('RETURN_DATE'),
		 		  //--submitFormat: CONSTANTS.DATE_FORMAT,
		             listeners: {
		            	 render: function(field) {
		            		 return dateFormatRender(field);
		            	 }
		             }   
      	        },{
      	        	xtype: 'checkboxfield',
		            width: 'auto',
		            hidden:true,
		            style:{marginTop:'20px'},
		            itemId:'whetherReturn',
		            labelAlign: 'right',
		            boxLabel: getCourseTxCommonTranslation('MATERIAL_RETURNED'),
		            name: 'whetherReturn',
		            inputValue : true,
		            uncheckedValue: false
      	        }]
		},{	
			xtype:'fieldcontainer',
			width:'auto',
			layout:'hbox',
			style:{
//				marginTop:'10px',
			    marginLeft:'-3px'
			},
			items: [{
				xtype: 'button',
				action: 'Submit',
				text: getCourseTxCommonTranslation('SAVE'),
				formBind: true,
				itemId: 'SubmitBtn',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE
			},{
				xtype: 'button',
				text: getCourseTxCommonTranslation('CANCEL'),
				ui: 'CustomBtnCancel',
				itemId: 'CancelBtn',
				scale: CONSTANTS.BUTTONSIZE
			}]
		}]
		}]	
});