/**
 * @author akshay sharma
 */
Ext.define('Academia.view.coursetransaction.viewschedule.ViewScheduleGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.viewschedulegrid',
	autoScroll: true,
	border : true,
    margin : 1,
	refreshStoreData:true,
	store : 'programCourseDashboard.ScheduleGridStore',
	id:'programBatchesGridId',
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'programCourseDashboard.ScheduleGridStore',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
		var grid=this;
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);     

	},
	tbar : [{
		xtype : 'button',
		itemId : 'scheduleCalendarViewId',
		tooltip : getProgramandcourseTranslation('VIEW_CALENDAR'),
		text : getProgramandcourseTranslation('VIEW_CALENDAR'),
		disabled : true
	}],
	columns : [{
		header :getCommonTranslation('ACADEMY_LOCATION'),
		dataIndex : 'academyLocationName',
		flex : 1,
		sortable : true
	}, {
		header :getCommonTranslation('ADMISSION_ID'),
		dataIndex : 'admissionCode',
		flex : 1,
		sortable : true,
		hidden:true
	}, {
		header : getCommonTranslation('STUDENT_ID'),
		dataIndex : 'studentCode',
		flex : 1,
		sortable : true,
		hidden:true
	}, {
		header : getCommonTranslation('STUDENT_NAME'),
		dataIndex : 'studentName',
		flex : 1,
		sortable : true,
		hidden:true
	}, {
		header :getCommonTranslation('PROGRAM'),
		dataIndex : 'programName',
		flex : 1,
		sortable : true
	}, {
		header : getCommonTranslation('BATCH'),
		dataIndex : 'batchName',
		flex : 1,
		sortable : true
	}, {
		header : getCommonTranslation('PERIOD'),
		dataIndex : 'periodName',
		flex : 1,
		sortable : true
	}, {
		header : getCommonTranslation('COURSE_CODE'),
		dataIndex : 'courseName',
		flex : 1,
		sortable : true,
		hidden:true
	},{
		header : getCommonTranslation('SECTION'),
		dataIndex : 'sectionName',
		flex : 1,
		sortable : true
	},{
		header : getCommonTranslation('COURSE_VARIANT'),
		dataIndex : 'courseVariantName',
		flex : 1,
		sortable : true,
		hidden:true
	},{
		header : getProgramandcourseTranslation('FACULTY_CODE'),
		dataIndex : 'facultyCode',
		flex : 1,
		sortable : true,
		hidden:true
	},{
		header : getCommonTranslation('FACULTY_NAME'),
		dataIndex : 'facultyName',
		flex : 1,
		sortable : true,
		hidden:true
	},{
		header : getProgramandcourseTranslation('CLASS_ROOM_NAME'),
		dataIndex : 'roomName',
		flex : 1,
		sortable : true,
		hidden:true
	},{
		header : getProgramandcourseTranslation('CLASS_ROOM_CODE'),
		dataIndex : 'roomCode',
		flex : 1,
		sortable : true,
		hidden:true
	},{
		header : getCourseTxCommonTranslation('SECTION_GROUP'),
		dataIndex : 'sectionGroupName',
		flex : 1,
		sortable : true,
		hidden:true
	},{
		header : getCourseTxCommonTranslation('NO_OF_PROGRAM_BATCH_PERIOD'),
		dataIndex : 'periodCount',
		flex:1,
		sortable : true,
		hidden:true,
		renderer:function(value){
			if(value>0){
				return  '<a href="#">'+value+'</a>';
			}else{
				return value;
			}
		}
	},{
		header : getCourseTxCommonTranslation('NO_OF_COURSE_VARIANT'),
		dataIndex : 'courseVariantCount',
		flex:1,
		sortable : true,
		hidden:true,
		renderer:function(value){
			if(value>0){
				return  '<a href="#">'+value+'</a>';
			}else{
				return value;
			}
		}
	}],
	listeners: {
	    cellclick: function (grd, rowIndex, colIndex, e) {
	    	var $this = this;
	    	$this.down('#scheduleCalendarViewId').setDisabled(false);
	    }
	}
});
