Ext.define('Academia.view.dashboard.PortalDropHandler', {
    extend: 'Ext.dd.DropTarget',

    constructor: function(portal, cfg) {
        this.portal = portal;
        Ext.dd.ScrollManager.register(portal.body);
        Academia.view.dashboard.PortalDropHandler.superclass.constructor.call(this, portal.body, cfg);
        portal.body.ddScrollConfig = this.ddScrollConfig;
        //		this.portal.afterLayout = Ext.Function.createSequence(	this.portal.afterLayout, this.getGrid, this);
        this.getGrid();
    },

    notifyDrop: function(droppedPanel, evt, data) {

        this.getLocation(evt);
        var panel = droppedPanel.panel,
            this$ = this,
            returnStatus = false;

        Ext.suspendLayouts();
        if (this.portal.validatedrop) {

            // make sure panel is visible prior to inserting so that the layout
            // doesn't ignore it
            panel.el.dom.style.display = '';
            droppedPanel.panelProxy.hide();
            droppedPanel.proxy.hide();
            panel.style = {
                'float': 'left',
                left: '0px'
            };

            panel.el.dom.style.left = '';
            panel.el.dom.style.top = '';
            panel.margin = 10;

            this.overObj = this$.portal.items.getAt(this.index);
            if (this$.overObj && panel && panel.id != this$.overObj.id) {
                this.portal.move(panel, this.index);
            }

            returnStatus = true;
        }

        Ext.resumeLayouts(true);
        /*	// scroll position is lost on drop, fix it
		this.scrollPos = this.portal.body.getScroll();
		var st = this.scrollPos.left;
		if (st) {
			var d = this.portal.body.dom;
			setTimeout(function() {
				d.scrollLeft = st;
			}, 10);
		}*/
        this.portal.doLayout();
        return returnStatus;
    },

    getLocation: function(evt) {
        this.getGrid();
        var xy = evt.getXY(),
            cols = this.grid.columnX,
            rows = this.grid.columnY,
            length = cols.length,
            cmatch = false,
            index = 0;

        // determine index
        for (index; index < length; index++) {
            itemRight = cols[index].x + cols[index].w;
            itemBottom = rows[index].y + rows[index].h;
            if (cols[index].x < xy[0] && itemRight > xy[0] && rows[index].y < xy[1] && itemBottom > xy[1]) {
                cmatch = true;
                break;
            }
        }
        if (cmatch) this.index = index;
    },

    // internal cache of body and column coords
    getGrid: function() {
        var box = this.grid = this.portal.body.getBox();
        box.columnX = [];
        box.columnY = [];
        this.portal.items.each(function(c) {
            //        	c=c.up();
            box.columnX.push({
                x: c.el.getX(),
                w: c.el.getWidth()
            });
            box.columnY.push({
                y: c.el.getY(),
                h: c.el.getHeight()
            });
        });
        return box;
    },

    // unregister the dropzone from ScrollManager
    unreg: function() {
        Ext.dd.ScrollManager.unregister(this.portal.body);
        Academia.view.dashboard.PortalDropHandler.superclass.unreg.call(this);
        delete this.portal.afterLayout;
    }
});