Ext.define('Academia.view.dashboard.UserAccessibleGrid',{
    extend: 'Ext.grid.Panel',
    alias: 'widget.useraccessiblegrid',
    border: true,
    viewConfig: {
        stripeRows: true
    },
    initComponent: function() {
        var this$ = this;
        var store = this$.buildStore();
        Ext.apply(this$, {
            store: store,
            dockedItems: [{
                xtype: 'toolbar',
                dock: 'bottom',
                items: [{
                    xtype: 'custompagingtoolbar',
                    plugins: ['pagesize'],
                    store: store,
                    emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
                    displayInfo: true
                }]
            }]
        });
        this$.callParent(arguments);
    },
    
    tbar : [{
		xtype: 'button',
		itemId: 'revokeAccessBtn',
		tooltip : getCommonTranslation('REVOKE_ACCESS'),
		text: getCommonTranslation('REVOKE_ACCESS'),
		cls: 'dashbordOtherTbarBtn'
	}],
    selType: 'checkboxmodel',
    selModel: {
		multiSelect :true,
		mode:'SIMPLE',
		checkOnly : false
	},
    columns: [{
        header: getCommonTranslation('PORTAL'),
        dataIndex: 'portalName',
        sortable: true,
        flex: 1
    }, {
        header: getCommonTranslation('DASHLET_CODE'),
        dataIndex: 'dashletCode',
        sortable: true,
        flex: 1,
        renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) {
				return getCommonTranslation(value);
			} else {
				return value;
			}                 
		}
    }/*, {
        header: getCommonTranslation('DASHLET_CATEGORY'),
        dataIndex: 'dashletCategory',
        sortable: true,
        flex: 1
    }*/],    

    buildStore: function() {
        return Ext.create('Academia.store.dashboard.UserDashletStore');
    }
});
    
        
