/**
 * @author Rajkumar.patidar
 */

Ext.define('Academia.view.dashboard.dashlets.ActiveSurveyDashlet', {
	extend : 'Academia.view.dashboard.DashboardDashlet',
	alias : 'widget.activesurveydashlet',
	requires : ['Academia.model.enquiry.SurveyDashletMdl'],
    graphView:true,
    layout:'card',
    activeItem: 0, 
    cls:'ActiveSurveyDashletCLS dashlet activeSurveyColumnCls',
	loadDashlet :function(){
		var UserInfoModel =  Academia.model.authentication.UserInfoModel;
		var userId = UserInfoModel.get('userId');
		var portalId = UserInfoModel.get('portalId');
		var portalName;
		if(portalId==2){
			portalName = 'FACULTY'
		}else if(portalId==3 || portalId==7){
			portalName = 'STUDENT'
		}
		if(portalId==7){
			 var portalInfo = Academia.model.authentication.PortalInfoModel;
			 var student = portalInfo.get('student');
			 userId = student.id
		}
		var urlparams = 'type='+portalName+'&status=true&userId='+userId;
	
		var this$=this;
    	var tab = this.layout.getActiveItem();
    	var params=this$.getParams();
    	var extraparams = {
    		/*	endDate:params.endDate,
    			startDate:params.startDate,*/
    			type:portalName,
    			status:true,
    			userId:userId
    	}
    	var store= tab.getStore();
    	store.getProxy().extraParams = {
    		type:portalName,
    		status:true,
    		userId:userId
    	};
    	store.load();
	},
	defaults: {
		cls:'panelNoSpace',
		xtype:'griddashlet'
    },
	items:[{
	    xtype:'griddashlet',
		model:'Academia.model.enquiry.SurveyDashletMdl',
		url : SERVERURL.DISTRIBUTED_ACTIVE_SURVEY,
		addPagingToolbar : true,
		columns : [{
    		text : getCommonTranslation('SURVEY_TITLE'),
    		dataIndex : 'surveyTitle',
    		sortable : true,
    		flex:0.1,
    		renderer:function(val){
    			if(!isNullOrEmpty(val)) {
    				return '<a href="#">'+val+'</a>';
    			}
    		}
    	}, {
    		text : getCommonTranslation('COMPLETED_RESPONSES'),
    		dataIndex : 'completedResponses',
    		sortable : true,
    		flex:0.1
    	},{
    		text : getCommonTranslation('INCOMPLETE_RESPONSES'),
    		dataIndex : 'incompleteResponses',
    		sortable : true,
    		flex:0.1
    	},{
    		text : getCommonTranslation('START_DATE'),
    		dataIndex : 'surveyStartDate',
    		sortable : true,
    		flex:0.1,
    		renderer: function(date) {
    			if(!isNullOrEmpty(date)){
    				return dateRender(date);	
    			}
    		}
    	},{
    		text : getCommonTranslation('END_DATE_LABEL'),
    		dataIndex : 'surveyExpiredDate',
    		sortable : true,
    		flex:0.1,
    		renderer: function(date) {
    			if(!isNullOrEmpty(date)){
    				return dateRender(date);	
    			}
    		}
    	}],
		listeners:{
			activate:function(portlet){
				var surveydashlet=portlet.up('activesurveydashlet');
				surveydashlet.addExportToPdf(surveydashlet);
				surveydashlet.activeTab =1;
				
				var UserInfoModel =  Academia.model.authentication.UserInfoModel;
				var portalId = UserInfoModel.get('portalId');
				if(portalId != 3 && portalId != 7){
					surveydashlet.addGraphViewButton(surveydashlet);
				}
				if(portalId == 3 || portalId == 7){
					surveydashlet.down('[dataIndex=completedResponses]').setVisible(false);
					surveydashlet.down('[dataIndex=incompleteResponses]').setVisible(false);
				}
				
				surveydashlet.addExportToPdf(surveydashlet,portlet);
				surveydashlet.addExportToExcel(surveydashlet,portlet);
				portlet.doLayout();
			},
			deactivate:function(portlet){
					var surveydashlet=portlet.up('activesurveydashlet');
					surveydashlet.removeGraphViewButton(surveydashlet);
					surveydashlet.removeExportToPdf();
					surveydashlet.removeExportToExcel();
			},	
			cellclick: function( cell, td, cellIndex,record) {
    			var surveyGrid = cell.up('grid');
    			var columnName = surveyGrid.columnManager.columns[cellIndex].dataIndex;
    			if(columnName == 'surveyTitle') {
    				window.open(record.data.surveyUrl);
    			}
    		}
		}
	},{
		xtype:'columnchartdashlet',
		xAxesCategoryField :['completedResponses'],
		yAxesNumericField : ['incompleteResponses'],
		xAxesCategoryTitle :'completedResponses',
		yAxesNumericTitle :'incompleteResponses',
		model:'Academia.model.enquiry.SurveyDashletMdl',
		url : SERVERURL.DISTRIBUTED_ACTIVE_SURVEY,
		listeners:{
			activate:function(portlet){
				var surveydashlet=portlet.up('activesurveydashlet');
				surveydashlet.activeTab = 0;
				surveydashlet.addGridViewButton(surveydashlet);
				surveydashlet.addExportToPng(surveydashlet,portlet);
			},
			deactivate:function(portlet){
				var surveydashlet=portlet.up('activesurveydashlet');
				surveydashlet.removeGridViewButton(surveydashlet);
				surveydashlet.removeExportToPng();
			}
		}
	}]
});
