
Ext.define('Academia.view.dashboard.dashlets.StudentCountDashlet', {
	extend : 'Academia.view.dashboard.DashboardDashlet',
	alias : 'widget.studentcountdashlet',

   /* requires : ['Academia.view.dashboard.dashlets.GridDashlet',
               'Academia.model.common.AcademyLocationProgramModel' ], */

    graphView:true,
    layout:'card',
    activeItem: 0, 
    autoScroll:false,
    cls:'StudentTallyDashletCLS dashlet horizontalScrollingFixed',
	loadDashlet :function(paramObj){
	    var this$=this;
	    var view= this.layout.getActiveItem();
	    if(view.xtype=='griddashlet' || view.xtype=='columnchartdashlet'){
	    	var store= view.getStore();
	    	var userId = this$.getCurrentlyLoggedInDashletUser().id;
	    	var portalId = this$.getCurrentlyLoggedInDashletUser().portalId;
	    	var programBatchSeatConfigurationId;
	    	if(!isNullOrEmpty(store.getProxy().extraParams.programBatchSeatConfigurationId)){
	    		programBatchSeatConfigurationId=store.getProxy().extraParams.programBatchSeatConfigurationId;	    		
	    	}
	    	var extraparams;
			if(paramObj !=undefined){
				extraparams=paramObj;
			}else{
				extraparams=this$.getParams();
			}
			
			if(this$.getParams()!=undefined){
				extraparams['intakeYearId']=this$.getParams().intakeYearId;
				extraparams['locationId']=this$.getParams().locationId;
				extraparams['academyId']=this$.getParams().academyId;
				extraparams['programId']=this$.getParams().programId;
				extraparams['batchId']=this$.getParams().batchId;
				extraparams['seatTypeId']=this$.getParams().seatTypeId;
			}			
			
			switch (view.itemId) {
			case 'StudentTally1':
				store.getProxy().extraParams = {
					userId: userId,
					portalId: portalId,
					programBatchSeatConfigurationId:programBatchSeatConfigurationId,
					endDate: ((extraparams && !isNullOrEmpty(extraparams)) ? extraparams.endDate : null),
					startDate:  ((extraparams && !isNullOrEmpty(extraparams)) ? extraparams.startDate : null)
			};
				break;
			case 'StudentTally2':
				store.getProxy().extraParams = {
					userId: userId,
					portalId: portalId,
					programBatchSeatConfigurationId:programBatchSeatConfigurationId		
			};
				break;
			case 'StudentTally3':
				if(paramObj !=undefined){
				this$.getParams().program1Id =paramObj.program1Id;
				this$.getParams().batch1Id =paramObj.batch1Id;
				}
				if(isNullOrEmpty(extraparams.program1Id) && isNullOrEmpty(extraparams.batch1Id)){
					extraparams['program1Id']=store.getProxy().extraParams.program1Id;
					extraparams['batch1Id']=store.getProxy().extraParams.batch1Id;
				}
				store.getProxy().extraParams = {
					userId: userId,
					portalId: portalId,
					programBatchSeatConfigurationId:programBatchSeatConfigurationId,
					program1Id: extraparams.program1Id,
					batch1Id: extraparams.batch1Id
				};
				break;
			case 'StudentTally4':
				if(paramObj !=undefined){
				this$.getParams().sectionId =paramObj.sectionId;
				this$.getParams().periodId =paramObj.periodId;
				}
				if(isNullOrEmpty(extraparams.periodId) && isNullOrEmpty(extraparams.sectionId)){
					extraparams['periodId']=store.getProxy().extraParams.periodId;
					extraparams['sectionId']=store.getProxy().extraParams.sectionId;
				}
				store.getProxy().extraParams = {
					userId: userId,
					portalId: portalId,
					programBatchSeatConfigurationId:programBatchSeatConfigurationId,
					periodId:extraparams.periodId,
					sectionId:extraparams.sectionId
			};
				break;
			case 'StudentTally5':
				store.getProxy().extraParams = {
					userId: userId,
					portalId: portalId,
					programBatchSeatConfigurationId:programBatchSeatConfigurationId,
			};
				break;
			}
	    	store.load({params:extraparams,
	    		callback: function(rec, operation, success) {/*
	    			if(rec.length==0){
	    				this$.layout.setActiveItem(5);
	    			}
	    		*/}
	    	});
	    }
	},
	defaults: {
		cls:'panelNoSpace',
		xtype:'griddashlet'
    },
    
	items:[{
		model:'Academia.model.common.AcademyLocationProgramModel',
		title:getCommonTranslation('STUDENT_COUNT'),
		header:false,
		url : SERVERURL.FIND_STUDENT_COUNT,
		addPagingToolbar : true,
		itemId:'StudentTally1',
		columns : [{
			text : getCommonTranslation('ACADEMY_LOCATION'),
			dataIndex: 'academyLocationName',
			sortable : true,
			flex:0.1
		}, {
			text : getCommonTranslation('PROGRAM_CODE_OR_NAME'),
			dataIndex : 'codeValue',
			sortable : true,
			flex:0.1
		}, {
			text : getAdmissionTranslation('BATCH'),
			dataIndex : 'batchName',
			sortable : true,
			flex:0.1
		},  {
			text : getAdmissionTranslation('SEAT_TYPE'),
			dataIndex: 'seatName',
			sortable : true,
			flex:0.1
		},  {
			text : getCommonTranslation('SECTION'),
			dataIndex: 'sectionCount',
			sortable : true,
			hidden: true,
			renderer: function(value) {
				if(value>0){
					return "<a href='#'>"+value+"</a>";
				}else{
					return "-";
				}
			},
			flex:0.1
		},{
			text : getExaminationTranslation('STUDENT_COUNT'),
			dataIndex: 'count',
			sortable : true,
			tpl: '<a>{count}</a>',
			 renderer: function(value) {
				 value="<a href='#'>"+value+"</a>"; 
	             return value;
	         },
			flex:0.1
		}/*,  {
			hidden: true,
			dataIndex: 'id'
		}*/,{
			header : getCommonTranslation('PERCENTAGE_SEATS_FILLED'),
			dataIndex : 'percentageSeatsFilled',
			//flex : .2,
			sortable : true,
			renderer:function(value, rec){
				return value+'%';
			}
		}],
		listeners:{
			activate:function(portlet){
				var studentcountdashlet=portlet.up('studentcountdashlet');
				studentcountdashlet.addExportToPdf(studentcountdashlet);
				studentcountdashlet.activeTab = 1;
				studentcountdashlet.addGraphViewButton(studentcountdashlet);
				studentcountdashlet.addExportToPdf(studentcountdashlet,portlet);
				studentcountdashlet.addExportToExcel(studentcountdashlet,portlet);
				portlet.doLayout();
			},
			deactivate:function(portlet){
					var studentcountdashlet=portlet.up('studentcountdashlet');
					studentcountdashlet.removeGraphViewButton(studentcountdashlet);
					studentcountdashlet.removeExportToPdf();
					studentcountdashlet.removeExportToExcel();
			},
    		cellclick: function( cell, td, cellIndex) {
    			var studentCountGrid = cell.up('grid');
    			var columnName = studentCountGrid.columnManager.columns[cellIndex].dataIndex;
    			if(columnName == 'count') {
    				var selectedRecord = studentCountGrid.getSelectionModel().getSelection()[0];
    				var id = selectedRecord.get('programBatchSeatConfigurationId');
    				if(!isNullOrEmpty(id)) {
    					var studentcountdashlet=studentCountGrid.up('studentcountdashlet');
    					studentcountdashlet.params ={ programBatchSeatConfigurationId : id};
    					studentcountdashlet.getLayout().setActiveItem(2);
    					
    					var store = studentcountdashlet.getLayout().getActiveItem().getStore();
    					store.getProxy().extraParams = {
    						programBatchSeatConfigurationId : id
    					};
    					studentcountdashlet.loadDashlet();
    				}
    			}
    			if(columnName == 'sectionCount') {
    				var selectedRecord = studentCountGrid.getSelectionModel().getSelection()[0];
    				if(selectedRecord.data.sectionCount>0)
    				{
    				var pIds = selectedRecord.get('programId');
    				var batchId=selectedRecord.get('batchId');
    				var studentcountdashlet=studentCountGrid.up('studentcountdashlet');
    				studentcountdashlet.params ={ 
    						program1Id : pIds,
    						batch1Id:batchId
    				};
    				
    				/*var store = studentcountdashlet.getLayout().getActiveItem().getStore();
    				store.getProxy().extraParams = {
    					program1Id : pIds,
    					batch1Id:batchId
    				};*/
    				var paramsObj={
    						program1Id : pIds,
        					batch1Id:batchId
    				};
    				studentcountdashlet.getLayout().setActiveItem(3);
    				studentcountdashlet.loadDashlet(paramsObj);
    			}
    			}
    		}
		}
	},{
		xtype:'columnchartdashlet',
		xAxesCategoryField :['academyLocationName','programName', 'batchName','seatName','sectionCount'],
		yAxesNumericField : 'count',
		xAxesCategoryTitle :getCommonTranslation('STUDENT'),
		yAxesNumericTitle :getCommonTranslation('COUNTS'),
		model:'Academia.model.common.AcademyLocationProgramModel',
		itemId:'StudentTally5',
		url : SERVERURL.FIND_STUDENT_COUNT,
		listeners:{
			activate:function(portlet){
				var studentcountdashlet=portlet.up('studentcountdashlet');
				studentcountdashlet.activeTab = 0;
				studentcountdashlet.addGridViewButton(studentcountdashlet);
				studentcountdashlet.addExportToPng(studentcountdashlet,portlet);
			},
			deactivate:function(portlet){
				var studentcountdashlet=portlet.up('studentcountdashlet');
				studentcountdashlet.removeGridViewButton(studentcountdashlet);
				studentcountdashlet.removeExportToPng();
			}
		}
	},{
		fields:['id','personId','progamBatchSeatConfigId','code','printName','admissionId','birthDate','fatherFullName','motherFullName'],
		title:getCommonTranslation('STUDENT_COUNT'),
		header:false,
		url : SERVERURL.FIND_STUDENT_BASIC_DETAIL,
		addPagingToolbar : true,
		itemId:'StudentTally2',
		columns : [{
			text : getCommonTranslation('STUDENT_CODE'),
			dataIndex: 'code',
			sortable : true,
			tpl: '<a>{code}</a>',
			 renderer: function(value) {
				 value="<a href='#'>"+value+"</a>"; 
	             return value;
	         },
			flex:0.2
		}, {
			text : getAdmissionTranslation('STUDENT_NAME'),
			dataIndex : 'printName',
			sortable : true,
			flex:0.2
		}, {
			text : getPersonModuleTranslation('DATE_OF_BIRTH'),
			hidden: true,
			dataIndex: 'birthDate',
			renderer: function(value){
				return dateRender(value);
			},
			flex:0.2
		}, {
			text : getPersonModuleTranslation("FATHER_FULL_NAME"),
			hidden: true,
			dataIndex: 'fatherFullName',
			flex:0.2
		}, {
			text : getPersonModuleTranslation("MOTHER_FULL_NAME"),
			hidden: true,
			dataIndex: 'motherFullName',
			flex:0.2
		}
		/*,{
			hidden: true,
			dataIndex: 'id'
		},  {
			hidden: true,
			dataIndex: 'personId'
		},  {
			hidden: true,
			dataIndex: 'progamBatchSeatConfigId'
		}*/],
		listeners:{
			activate:function(portlet){
				var studentcountdashlet=portlet.up('studentcountdashlet');
				studentcountdashlet.addExportToPdf(studentcountdashlet,portlet);
				studentcountdashlet.addExportToExcel(studentcountdashlet,portlet);
				studentcountdashlet.addTool(Ext.create('Ext.panel.Tool',{
		         type: 'prev',
		         handler: function(btn, target, header, tool){
		        	 header.ownerCt.getLayout().setActiveItem(0);
		        	 header.remove(tool);
		        	 studentcountdashlet.params={};
		        	// reset the page param after going previous page
		        	 var itemStore = studentcountdashlet.items.get(2).getStore();
		        	 itemStore.currentPage = 1;
		        	 //studentcountdashlet.loadDashlet();
		        	 }
			     }));

			},
			deactivate:function(portlet){
					var studentcountdashlet=portlet.up('studentcountdashlet');
					studentcountdashlet.removeExportToPdf();
					studentcountdashlet.removeGridViewButton(studentcountdashlet);
					studentcountdashlet.removeExportToExcel();
			},
    		cellclick: function( cell, td, cellIndex) {
    			var studentDetailGrid = cell.up('grid');
    			var columnName = studentDetailGrid.columnManager.columns[cellIndex].dataIndex;
    			if(columnName == 'code') {
    				var record = studentDetailGrid.getSelectionModel().getSelection()[0];
    				var userId = record.get('id');
    				if(!isNullOrEmpty(userId)) {
					 	var tabTitle = record.get('code');
			            var personId = record.get('personId');
			            var admissionId=record.get('admissionId');
			            var programBatchSeatTypeConfigId = record.get('progamBatchSeatConfigId');
			            Academia.app.getController('Academia.controller.personinfo.student.StudentPersonalController');
			            var personController=  Academia.app.getController('Academia.controller.personinfo.common.PersonCommonController');
			            var studentListController =  Academia.app.getController('Academia.controller.personinfo.student.StudentListController');
			            personController.isProfilePicSaved = false;
			            personController.addContentPanelTab(tabTitle, 'studentprofile', userId, personId, null, admissionId, programBatchSeatTypeConfigId);
			            /*var studentProfile = studentListController.getTabReferenceByTabTitle(tabTitle);
						var studentPersonDetailsLinkPanel = studentProfile.down('#studentPersonDetailsLinkPanel');
						if(!isNullOrEmpty(studentPersonDetailsLinkPanel)){
							var studentLinkPanelObject = studentPersonDetailsLinkPanel.getStudentProfileLink();
							studentListController.loadPanellinkForStudent(studentProfile, studentLinkPanelObject);        	
						}*/
			            if(Ext.isDefined(studentDetailGrid.up('window'))){
			            	studentDetailGrid.up('window').close();
			            }
    				}
    			}
    		}
		}
	},{
		fields:['programName', 'batchName','sectionCode','studentCount'],
		title:getCommonTranslation('STUDENT_COUNT'),
		header:false,
		url : SERVERURL.FIND_SECTION_LIST_BY_BATCH_ID,
		addPagingToolbar : true,
		itemId:'StudentTally3',
		columns : [{
			text : getAdmissionTranslation('PROGRAM'),
			dataIndex : 'programName',
			sortable : true,
			flex:0.1
		}, {
			text : getAdmissionTranslation('BATCH'),
			dataIndex : 'batchName',
			sortable : true,
			flex:0.1
		}, {
			text : getCommonTranslation	('SECTION_NAME'),
			dataIndex: 'sectionCode',
			sortable : true,
			flex:0.2
		}, {
			text : getExaminationTranslation('STUDENT_COUNT'),
			dataIndex: 'studentCount',
			sortable : true,
			tpl: '<a>{count}</a>',
			renderer:function(value){
    			if(value>0){
    				return  '<a href="#">'+value+'</a>';
    			}else{
    				return value;
    			}
    		},
			flex:0.1
		}],
		listeners:{
			activate:function(portlet){
				var studentcountdashlet=portlet.up('studentcountdashlet');
				studentcountdashlet.addExportToPdf(studentcountdashlet,portlet);
				studentcountdashlet.addExportToExcel(studentcountdashlet,portlet);
				studentcountdashlet.addTool(Ext.create('Ext.panel.Tool',{
		         type: 'prev',
		         handler: function(btn, target, header, tool){
		        	 header.ownerCt.getLayout().setActiveItem(0);
		        	 header.remove(tool);
		        	 studentcountdashlet.params={};
		        	 //reset the page param after going previous page
		        	 var itemStore = studentcountdashlet.items.get(2).getStore();
		        	 itemStore.currentPage = 1;
		        	 //studentcountdashlet.loadDashlet();
		        	 }
			     }));

			},
			deactivate:function(portlet){
					var studentcountdashlet=portlet.up('studentcountdashlet');
					studentcountdashlet.removeExportToPdf();
					studentcountdashlet.removeGridViewButton(studentcountdashlet);
					studentcountdashlet.removeExportToExcel();
			},
			cellclick: function( cell, td, cellIndex) {
    			var studentCountGrid = cell.up('grid');
    			var columnName = studentCountGrid.columnManager.columns[cellIndex].dataIndex;
    			if(columnName == 'studentCount') {
    				var selectedRecord = studentCountGrid.getSelectionModel().getSelection()[0].raw;
    				if(selectedRecord.studentCount>0)
    				{
    				var periodId = selectedRecord.periodId;
    				var sectionId=selectedRecord.id;
    				var studentcountdashlet=studentCountGrid.up('studentcountdashlet');
    				studentcountdashlet.params ={ 
    						periodId : periodId,
    						sectionId:sectionId
    				};
    				var paramsObj={
    						periodId : periodId,
    						sectionId:sectionId
    				};
    				studentcountdashlet.getLayout().setActiveItem(4);
    				store = studentcountdashlet.getLayout().getActiveItem().getStore();
    				store.currentPage = 1;
    				/*var store = studentcountdashlet.getLayout().getActiveItem().getStore();
    				store.getProxy().extraParams = {
    					periodId : periodId,
    					sectionId:sectionId
    				};*/
    				studentcountdashlet.loadDashlet(paramsObj);
    			}
    			}
    		}
		}
	},{
		fields:['id','personId','progamBatchSeatConfigId','studentId','studentName','admissionId','birthDate','fatherFullName','motherFullName'],
		title:getCommonTranslation('STUDENT_COUNT'),
		header:false,
		url : SERVERURL.PATH_FIND_BY_CRITERIA,
		addPagingToolbar : true,
		itemId:'StudentTally4',
		columns : [{
			text : getCommonTranslation('STUDENT_CODE'),
			dataIndex: 'studentId',
			sortable : true,
			tpl: '<a>{studentId}</a>',
			 renderer: function(value) {
				 value="<a href='#'>"+value+"</a>"; 
	             return value;
	         },
			flex:0.2
		}, {
			text : getAdmissionTranslation('STUDENT_NAME'),
			dataIndex : 'studentName',
			sortable : true,
			flex:0.2
		}],
		listeners:{
			activate:function(portlet){
				var studentcountdashlet=portlet.up('studentcountdashlet');
				studentcountdashlet.addExportToPdf(studentcountdashlet,portlet);
				studentcountdashlet.addExportToExcel(studentcountdashlet,portlet);
				Ext.each(studentcountdashlet.getHeader().getTools(),function(currentHeaderTool){
					if(Ext.isDefined(currentHeaderTool.type) && currentHeaderTool.type=="prev"){
						studentcountdashlet.getHeader().remove(currentHeaderTool);
					}
				});
				studentcountdashlet.addTool(Ext.create('Ext.panel.Tool',{
		         type: 'prev',
		         handler: function(btn, target, header, tool){
		        	 header.ownerCt.getLayout().setActiveItem(3);
		        	 header.remove(tool);
		        	 studentcountdashlet.params={};
		        	 var itemStore = studentcountdashlet.items.get(2).getStore();
		        	 itemStore.currentPage = 1;
		        	 //studentcountdashlet.loadDashlet();
		        	 }
			     }));

			},
			deactivate:function(portlet){
					var studentcountdashlet=portlet.up('studentcountdashlet');
					studentcountdashlet.removeExportToPdf();
					studentcountdashlet.removeExportToExcel();
			},
    		cellclick: function( cell, td, cellIndex) {
    			var studentDetailGrid = cell.up('grid');
    			var columnName = studentDetailGrid.columnManager.columns[cellIndex].dataIndex;
    			if(columnName == 'studentId') {
    				var record = studentDetailGrid.getSelectionModel().getSelection()[0];
    				var userId = record.get('id');
    				if(!isNullOrEmpty(userId)) {
					 	var tabTitle = record.get('studentId');
			            var personId = record.get('personId');
			            var admissionId=record.get('admissionId');
			            var programBatchSeatTypeConfigId = record.get('progamBatchSeatConfigId');
			            Academia.app.getController('Academia.controller.personinfo.student.StudentPersonalController');
			            var studentListController =  Academia.app.getController('Academia.controller.personinfo.student.StudentListController');
			            var personController=  Academia.app.getController('Academia.controller.personinfo.common.PersonCommonController');
			            personController.isProfilePicSaved = false;
			            personController.addContentPanelTab(tabTitle, 'studentprofile', userId, personId, null, admissionId, programBatchSeatTypeConfigId);
			            /*var studentProfile = studentListController.getTabReferenceByTabTitle(tabTitle);
						var studentPersonDetailsLinkPanel = studentProfile.down('#studentPersonDetailsLinkPanel');
						if(!isNullOrEmpty(studentPersonDetailsLinkPanel)){
							var studentLinkPanelObject = studentPersonDetailsLinkPanel.getStudentProfileLink();
							studentListController.loadPanellinkForStudent(studentProfile, studentLinkPanelObject);        	
						}*/
			            if(Ext.isDefined(studentDetailGrid.up('window'))){
			            	studentDetailGrid.up('window').close();
			            }
    				}
    			}
    		}
		}
	},{
		xtype: 'image',
		width: '100%',
		height: '100%',
		frame : false,
		src: CONSTANTS.NO_DATA_DISPALY_DASHBORD_IMAGE_SRC,//'resources/images/no_data_to_display.png',
		listeners:{
			activate:function(portlet){
				var studentcountdashlet=portlet.up('studentcountdashlet');
				studentcountdashlet.addExportToPdf(studentcountdashlet);
				studentcountdashlet.activeTab = 1;
				studentcountdashlet.addGraphViewButton(studentcountdashlet);
				studentcountdashlet.addExportToPdf(studentcountdashlet,portlet);
				studentcountdashlet.addExportToExcel(studentcountdashlet,portlet);
			},
			deactivate:function(portlet){
					var studentcountdashlet=portlet.up('studentcountdashlet');
					studentcountdashlet.removeGraphViewButton(studentcountdashlet);
					studentcountdashlet.removeExportToPdf();
					studentcountdashlet.removeExportToExcel();
			}
		}
	}]
});
