/**
 * @author Amit G
 */
Ext.define('Academia.view.dashboard.dashlets.StudentTipChartForHeight' ,{
	extend: 'Ext.chart.Chart',
	requires:['Ext.chart.*','Ext.layout.container.Fit','Ext.window.MessageBox','Ext.grid.Panel'],
	style: 'background:#fff',
	alias : 'widget.studenttipchartforheight',
	  //requires: ['Ext.chart.axis.OverlapLabelOptions'], // added for get rid of not showing  bigger length labels
	    animate: true,
	    shadow: true,
	    legend : {
			position : 'bottom'
		},
	    initComponent: function() {
	        var this$ = this;
	        var numberField = this.yAxesNumericField || 'number'; 
	        var numberField1 = this.yAxesNumericField1 || 'number'; 
	        var numberField2 = this.yAxesNumericField2 || 'number'; 
	        var categoryField ='category';
	        var numericTitle = this.yAxesNumericTitle|| getCommonTranslation('HEIGHTCMS');
	        var categoryTitle = this.xAxesCategoryTitle||getCommonTranslation('MONTHYEAR');
	        var columnWidth = this.columnWidth|| REPORT_CONSTANTS.COMMON_COLUMN_WIDTH;
	        var columnColor = this.columnColor|| REPORT_CONSTANTS.COMMON_COLOR;
	        var chartStore = this$.buildStore();
	        	
	        Ext.apply(this$, {
	        	store: chartStore,
	            axes: [{
	                type: 'Numeric',
	                position: 'left',
	                //fields: [numberField1],
	                label: {
	                    renderer: Ext.util.Format.numberRenderer('0,0')
	                },
	                title: numericTitle,
	                grid: true,
	                minimum: 0
	            }, {
	                type: 'Category',
	                position: 'bottom',
	                fields: [categoryField],
	                title: categoryTitle,
//	                style: {
//	                	 'fill':'red !important'
//	                },
	               
	                //below options added for get rid of not showing bigger length labels 
	                //labelRows: 2,
	                //hideOverlappingLabels: false,
	                label   : {
	                	rotate:{degrees:45},
	                renderer: function(s) {
	                    return Ext.String.ellipsis(s,11);    
	                   }
	                }
	            }],
	            series: [{
	                type: 'line',
	                axis: 'left',
	                xField: categoryField,
	                yField: numberField,
	                title:['Student Height'],
	                gutter : 40,
	                highlight: true,
	                tips: {
	                  trackMouse: true,
	                  height: 28,
	                  layout: 'fit',
	                  renderer: function(storeItem, item) {
	                	  var tipTitle;
	                	  if (!isNullOrEmpty(storeItem.get(numberField))) {
	                		  tipTitle = 'Height' + ':'
	                		  + storeItem.get(numberField);
	                	  }
	                	  var length = (tipTitle.length)* 10;
	                	  this.setWidth(length);
	                	  this.setTitle(tipTitle);
	                  }
	                },
	                renderer: function(sprite, storeItem, barAttr, i, store) {
	                	barAttr.fill = columnColor;
	                	barAttr.width = columnWidth;
	              	  	return barAttr;
	                },
	                style: {
	                    'stroke-width': 2,
	                    'stroke': '#808080'
	                },
	                renderer: function(sprite, record, attr, index, store) {
//	                	var color = [ "#669900","#3366CC", "#AC3030","#FFAD33", "#FF957A","#FFFF99","#FF9999","#FFFFB2","#99CC99","#D6ADC2","#C2EBFF","#99C2EB"][index];
	                	var baseController = Academia.app.getController('Academia.controller.base.BaseController');
	                	var color = baseController.getRandomColor(index);
	                    if(store.getCount() <= 5){
	                		return Ext.apply(attr, {
	                            fill: color,
	                            width: 30,
	                            x: Math.max(attr.x, attr.x + (attr.width - 30) / 2)
	                        });
	                	}
	                	else{
		                    return Ext.apply(attr, {
		                        fill: color
		                    });
	                	} 
	                }
	            },{

	                type: 'line',
	                axis: 'left',
	                xField: categoryField,
	                yField: numberField1,
	                title:['Class Average'],
	                gutter : 40,
	                highlight: true,
	                tips: {
	                  trackMouse: true,
	                  height: 28,
	                  layout: 'fit',
	                  renderer: function(storeItem, item) {
	                	  var tipTitle;
	                	  if (!isNullOrEmpty(storeItem.get(numberField1))) {
	                		  tipTitle = 'Class Avg Height' + ':'
	                		  + storeItem.get(numberField1);
	                	  }
	                	  var length = (tipTitle.length)* 10;
	                	  this.setWidth(length);
	                	  this.setTitle(tipTitle);
	                  }
	                },
	                renderer: function(sprite, storeItem, barAttr, i, store) {
	                	barAttr.fill = columnColor;
	                	barAttr.width = columnWidth;
	              	  	return barAttr;
	                },
	                style: {
	                    'stroke-width': 2,
	                    'stroke': '#87ceeb'
	                },
	                renderer: function(sprite, record, attr, index, store) {
//	                	var color = [ "#669900","#3366CC", "#AC3030","#FFAD33", "#FF957A","#FFFF99","#FF9999","#FFFFB2","#99CC99","#D6ADC2","#C2EBFF","#99C2EB"][index];
	                	var baseController = Academia.app.getController('Academia.controller.base.BaseController');
	                	var color = baseController.getRandomColor(index);
	                    if(store.getCount() <= 5){
	                		return Ext.apply(attr, {
	                            fill: color,
	                            width: 30,
	                            x: Math.max(attr.x, attr.x + (attr.width - 30) / 2)
	                        });
	                	}
	                	else{
		                    return Ext.apply(attr, {
		                        fill: color
		                    });
	                	} 
	                }
	            
	            },{
	                type: 'line',
	                axis: 'left',
	                xField: categoryField,
	                yField: numberField2,
	                title:['Age Average'],
	                gutter : 40,
	                highlight: true,
	                tips: {
	                  trackMouse: true,
	                  height: 28,
	                  layout: 'fit',
	                  renderer: function(storeItem, item) {
	                	  var tipTitle;
	                	  if (!isNullOrEmpty(storeItem.get(numberField2))) {
	                		  tipTitle = 'Age Avg Height' + ':'
	                		  + storeItem.get(numberField2);
	                	  }
	                	  var length = (tipTitle.length)* 10;
	                	  this.setWidth(length);
	                	  this.setTitle(tipTitle);
	                  }
	                },
	                renderer: function(sprite, storeItem, barAttr, i, store) {
	                	barAttr.fill = columnColor;
	                	barAttr.width = columnWidth;
	              	  	return barAttr;
	                },
	                style: {
	                    'stroke-width': 2,
	                    'stroke': '#32CD32'
	                },
	                renderer: function(sprite, record, attr, index, store) {
//	                	var color = [ "#669900","#3366CC", "#AC3030","#FFAD33", "#FF957A","#FFFF99","#FF9999","#FFFFB2","#99CC99","#D6ADC2","#C2EBFF","#99C2EB"][index];
	                	var baseController = Academia.app.getController('Academia.controller.base.BaseController');
	                	var color = baseController.getRandomColor(index);
	                    if(store.getCount() <= 5){
	                		return Ext.apply(attr, {
	                            fill: color,
	                            width: 30,
	                            x: Math.max(attr.x, attr.x + (attr.width - 30) / 2)
	                        });
	                	}
	                	else{
		                    return Ext.apply(attr, {
		                        fill: color
		                    });
	                	} 
	                }
	            }]
	        });

	        this$.callParent(arguments);
	    },

createPostGridStore: function(columnModel, url, params,fields1,xAxesCategoryField) {
  var store = Ext.create('Ext.data.Store', {
  	model : columnModel,
  	fields : fields1,
      autoDestroy: true,
      autoLoad: false,
      pageSize: CONSTANTS.DEFAULT_PAGESIZE,
      extraParams: params,
      proxy: {
  		type : 'jsonajax',
  		header: {
              contentType: 'application/json'
          },
          actionMethods: {
              read: 'POST'
          },  
  		api : {
  			 read: url
  		},
  		reader : {
  			type : 'json',
  			root : 'rows',
  			totalProperty: 'records'
  		},
          extraParams: params
      },
      listeners:{
     	 load: function(store,option,success){
           for(var i=0; i< store.getCount(); i++){
               var record = store.getAt(i);
               var value='';
               for(var j=0; j< xAxesCategoryField.length-1; j++){
              	 value=value + record.get(xAxesCategoryField[j])+"#";
               }
          	 value=value + record.get(xAxesCategoryField[j]);
               record.set("category",value);
           }
           store.commitChanges();
  	 }
      }
  });
  return store;
},

buildStore: function(xAxesCategoryField) {
  return this.createPostGridStore(this.model,this.url, this.params,this.fields,this.xAxesCategoryField );
}

});
