/**
 * @author Saket.Puranik
 
 * This component is used for to show department details.
 */
Ext.define('Academia.view.department.DepartmentGrid',
		{
			extend : 'Ext.grid.Panel',
			alias : 'widget.departmentgrid',
			/* requires : ['Academia.view.department.DepartmentFormWindow','Academia.view.department.CopyDepartmentWindow' ], */
			store : 'department.DepartmentStore',
			title : getCommonTranslation('DEPARTMENTS'),//Departments
			collapsible:false,
			border: true,
			viewConfig : {
				stripeRows : CONSTANTS.STRIPEROWS
			},
			headerFix:{
				headerFix: true,
				portalIdsWithStructure: {
					'department':1
				}
			},
			cls: 'centerAlignTitle',
			columns : [ {
				header : getCommonTranslation('DEPARTMENT_NAME'),//Department Name	
				dataIndex : 'name',
				sortable : false,	
			    flex : .5
			}, {
				header : getCommonTranslation('DEPARTMENT_TYPE'),//Department Type
				dataIndex : 'departmentType',	
				sortable : false,	
				flex : .4,
				renderer:function(val){					
					return getCommonTranslation(val);
				}
			}, {
				header : getCommonTranslation('STATUS'),//Status
				dataIndex : 'status',	
				sortable : false,	
				flex : .2,
				renderer:function(value){
					return statusRender(value); 
			    }
			}, {
				header : getCommonTranslation('ACADEMY_LOCATION'),//Academy Location
				dataIndex : 'academyLocationName',	
				sortable : false,	
				flex : .4
			}, {
				header : getCommonTranslation('CURRENT_HOD'),//Current HOD
				dataIndex : 'headOfDepartment',	
				sortable : false,	
				flex : .4,
				renderer:function(headOfDepartment){
					return comboRender(headOfDepartment,'value');
				}
			}, {
				header : getCommonTranslation('HOD_HISTORY'),//HOD History
				dataIndex : 'id',	
				sortable : false,
				hidden:true,
				flex : .4,
				renderer:function(val){					
					return "<a href='#' id='hodHistoryLink'>"+getCommonTranslation('HOD_HISTORY')+"</a>";
				}
			}],
						
			tbar : [ {
				xtype : 'button',				
				itemId : 'btnAdd',
				tooltip : getCommonTranslation('ADD'),//Add department
				glyph: ICONGLYPH.ADDGLYPH
				//text : getCommonTranslation('ADD')
			},{
				xtype : 'button',				
				itemId : 'btnEdit',
				tooltip : getCommonTranslation('EDIT'),//Edit department
				glyph: ICONGLYPH.EDITGLYPH
				//text : getCommonTranslation('EDIT')
			},{
				xtype : 'button',				
				itemId : 'btnView',
				tooltip : getCommonTranslation('VIEW'),//View department
				iconCls: 'view-icon'
				//text : getCommonTranslation('VIEW')
			},{
				xtype : 'button',				
				itemId : 'btnDelete',
				cls: 'CustomToolbarBtnReject',
				tooltip :getCommonTranslation('DELETE'),//Delete department
				glyph: ICONGLYPH.DELETEGLYPH
				//text : getCommonTranslation('DELETE')
			}/*,{
				xtype : 'button',				
				itemId : 'btnCopyDepartment',
				tooltip :getCommonTranslation('COPY_TO_OTHER_ACADLOC'),//Copy to other Academy-Locations
				glyph: ICONGLYPH.COPYGLYPH				
				//text : 'Copy to other Academy-Locations'
			}*/,{
				xtype : 'splitbutton',
				itemId:'spBtnMoreActions',
				text : getCommonTranslation('MOREACTIONS'),//More Actions
				menu:[{
					text:getCommonTranslation('COPY_TO_OTHER_ACADLOC'),//Copy to other Academy-Locations
					itemId:'btnCopyDepartment'
				}, {
					text:getCommonTranslation('HOD_HISTORY'),//HOD History
					itemId:'hodHistoryMenu'
				}],
				listeners: { click: function() { this.showMenu(); } }
			}],
			dockedItems : [ {
				xtype : 'toolbar',
				dock : 'bottom',
				items : [ {
					xtype: 'custompagingtoolbar',
		            plugins:['pagesize'],
					store : 'department.DepartmentStore',
					emptyMsg : getCommonTranslation('EMPTY_DEPARTMENT_MESSAGE'),//No departments to display
					displayInfo : true
				} ]
			} ],
			showDepartmentForm: function() {				
				var winDepartmentForm=Ext.widget('departmentformwindow');
				winDepartmentForm.show();					
			},
			showCopyDepartmentWindow: function() {				
				var winCopyDepartmentWindow=Ext.widget('copydepartmentwindow');
				winCopyDepartmentWindow.show();					
			}
		});
