/**
 * @author Pritam.Patil
 * This is used for add Document window 
 */
Ext.define('Academia.view.documentmanagement.AddDocumentWindow', {
    extend: 'Ext.window.Window',
    alias: 'widget.adddocumentwindow',
    modal: true,
//    autoScroll: true,
    height : 430,
    width : 800,
    title: getDocumentTranslation('ADD_DOCUMENT'),
    frame: true,
    items: [{
        xtype: 'form',
        itemId: 'documentForm',
        standardSubmit: false,
        height : 400,
        plugins: "formlabelrequired",
        layout: 'anchor',
        defaults: {
            labelAlign: 'top'
        },
        items: [{
            xtype: 'hidden',
            name: 'documentTypeId',
            itemId: 'document_type_id'
        }, {
            xtype: 'fieldcontainer',
            anchor: '100%',
            defaults: {
                labelAlign: 'top',
                width: 360
            },
            layout: 'hbox',
            items: [{
                xtype: 'customcombobox',
                name: 'configLevel',
                fieldLabel: getDocumentTranslation('DOCUMENT_CATEGORY'),
                itemId: 'document_category',
                editable: false,
                allowBlank: false,
                displayField: 'value',
                valueField: 'name',
                queryMode: 'local',
                msgTarget: 'qtip',
                listeners: {
                    render: function(combo) {
                        var store = Ext.create('Academia.store.documentmanagement.DocumentCategorys');
                        combo.bindStore(store);
                    }
                }
            }]
        }, {
            xtype: 'fieldcontainer',
            anchor: '100%',
            defaults: {
                labelAlign: 'top',
                //width: 360
                flex: 1
            },
            layout: 'hbox',
            items: [{
                xtype: 'textfield',
                name: 'typeCode',
                allowBlank: false,
                fieldLabel: getDocumentTranslation('DOCUMENT_CODE'),
                itemId: 'document_code',
                msgTarget: 'qtip'
            }, {
                xtype: 'textfield',
                name: 'typeName',
                allowBlank: false,
                fieldLabel: getDocumentTranslation('DOCUMENT_NAME'),
                itemId: 'document_name',
                msgTarget: 'qtip',
                margin: '0 0 0 2'
            }/*, {
                xtype: 'customcombobox',
                name: 'dataProviders',
                fieldLabel: getDocumentTranslation('DATA_PROVIDER'),
                itemId: 'dataProviderSelector',
                editable: false,
                allowBlank: false,
                displayField: 'providerName',
                valueField: 'id',
                msgTarget: 'qtip',
                listeners: {
                    render: function(combo) {
                        var store = Ext.create('Academia.store.documentmanagement.DocumentDataProviderStore');
                        combo.bindStore(store);
                    }
                }
            }*/]
        }, {
            xtype: 'itemselector',
            itemId: 'dataProviderSelector',
            labelAlign: 'top',
            name: 'dataProviders',
            width: 749,
            maxHeight: 170,
            style: {
                marginLeft: '-9px'
            },
            autoScroll: true,
            imagePath: '../ux/css/images/',
            store : 'documentmanagement.DocumentDataProviderStore',
            displayField: 'providerName',
            valueField: 'id',
            editable: false,
            fromTitle: getDocumentTranslation('AVAILABLE_ITEM'),
            toTitle: getDocumentTranslation('SELECTED_ITEM'),
            delimiter: null,
            buttons: ['top', 'add', 'remove', 'bottom'],
            cls: 'data-provider-selector',
            listeners: {
            	afterrender: function(cmp) {
            		Ext.defer(function() {
            			cmp.items.items[1].setMargin('0 0 0 -5');
            		}, 200);
            	}
            }
        }, {
            xtype: 'fieldcontainer',
            anchor: '100%',
            defaults: {
                labelAlign: 'top',
                width: 226
            },
            style : {
            	marginTop : '-16px'
            },
            layout: 'hbox',
            items: [{
                xtype: 'checkbox',
                boxLabel: getDocumentTranslation('WHETHER_AVAILABLE_FOR_ADHOC'),
                name: 'availableForAdhoc',
                inputValue: true,
                uncheckedValue: false,
                itemId: 'availableForAdhoc',
                msgTarget: 'qtip'
            }]
        }, {
            xtype: 'fieldcontainer',
            //width: '100%',
            anchor: '100%',
            items: [{
                xtype: 'button',
                itemId: 'submitButtonId',
                text: getCommonTranslation('SUBMIT'), //Submit
                ui: 'CustomBtnSubmit',
                scale: CONSTANTS.BUTTONSIZE,
                formBind: true
            }, {
                xtype: 'button',
                text: getServiceRequestTranslation('CANCEL'),
                ui: 'CustomBtnCancel',
                itemId: 'cancelButtonId',
                scale: CONSTANTS.BUTTONSIZE
            }]
        }]
    }]
});