/**
 * @author Pritam.Patil
 * This component is used for document template mapping List Grid
 */
Ext.define('Academia.view.documentmanagement.DocumentTemplateMappingGrid', {
    extend: 'Ext.grid.Panel',
    alias: 'widget.documenttemplatemappinggrid',
    collapsible: false,
    border: true,
    viewConfig: {
        stripeRows: true
    },
    tbar: [{
        xtype: 'button',
        itemId: 'btnAdd',
        tooltip: getCommonTranslation('ADD'),
        glyph: ICONGLYPH.ADDGLYPH

    }, {
        xtype: 'button',
        itemId: 'btnEdit',
        tooltip: getCommonTranslation('EDIT'),
        glyph: ICONGLYPH.EDITGLYPH

    }, {
        xtype: 'button',
        itemId: 'btnView',
        tooltip: getCommonTranslation('VIEW'),
        iconCls: 'view-icon'

    }, {
        xtype: 'button',
        itemId: 'btnDelete',
        cls: 'CustomToolbarBtnReject',
        tooltip: getCommonTranslation('DELETE'),
        glyph: ICONGLYPH.DELETEGLYPH

    }, {
        xtype: 'button',
        itemId: 'btnApplyTo',
        //cls: 'CustomToolbarBtnReject',
        tooltip: getExaminationTranslation('APPLY_TO'),
        text: getExaminationTranslation('APPLY_TO')
    }],
    columns: [/*{
        dataIndex: 'id',
        hidden: true
    },*/ {
    	header: getDocumentTranslation('DOCUMENT_CATEGORY'),
    	dataIndex: 'configLevel',
//  	align: 'center',
    	sortable: true,
    	flex: .2,
    	renderer: function(value){
    		var msg;
    		if(!isNullOrEmpty(value)){
    			msg = getDocumentTranslation(value);
    		}
    		return msg;
    	}
    },{
        header: getDocumentTranslation('DOCUMENT_NAME'),
        dataIndex: 'documentTypeName',
//        align: 'center',
        sortable: true,
        flex: .2
    }, {
        header: getDocumentTranslation('TEMPLATE_TYPE'),
        dataIndex: 'documentTemplateTypeEnum',
//        align: 'center',
        sortable: true,
        flex: .2,
        renderer : function(value){
        	return getDocumentTranslation(value);
        }
    },{
	    header: getDocumentTranslation('TEMPLATE_NAME'),
	    dataIndex: 'templateName',
//	    align: 'center',
	    sortable: true,
	    flex: .2
    }, {
	    header: getDocumentTranslation('DEFAULT_TEMPLATE'),
	    dataIndex: 'useDefaultTemplate',
//	    align: 'center',
	    sortable: true,
	    flex: .2,
	    renderer: function(value){
	    	var msg;
	    	if(!isNullOrEmpty(value)){
	    		if(value){
	    			msg = getCommonTranslation('TRUE');
	    		}else{
	    			msg = getCommonTranslation('FALSE');
	    		}
	    	}else{
	    		msg = value;
	    	}
	    	return msg;
	    }
    }, {
	    header: getDocumentTranslation('WHETHER_ACTIVE'),
	    dataIndex: 'whetherActive',
//	    align: 'center',
	    sortable: true,
	    flex: .2,
	    renderer: function(value){
	    	var msg;
	    	if(!isNullOrEmpty(value)){
	    		if(value){
	    			msg = getCommonTranslation('TRUE');
	    		}else{
	    			msg = getCommonTranslation('FALSE');
	    		}
	    	}else{
	    		msg = value;
	    	}
	    	return msg;
	    }
    }],
    initComponent: function() {
        var this$ = this;
        var store = this$.buildStore();
        Ext.apply(this$, {
            store: store,
            dockedItems: [{
                xtype: 'toolbar',
                dock: 'bottom',
                items: [{
                    xtype: 'custompagingtoolbar',
                    plugins: ['pagesize'],
                    store: store,
                    emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
                    displayInfo: true
                }]
            }]
        });

        this$.callParent(arguments);
    },
    buildStore: function() {
        return Ext.create('Academia.store.documentmanagement.DocumentTemplateMappings');
    }
});