/**
 *  Education History Grid
 */
Ext.define('Academia.view.enquiry.Education.EducationDetailGrid', {
	//extend : 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.educationdetailgrid',
	store : 'enquiry.exam.ExamDetailStore',
	title :  getEnquiryTranslation('EDUCATION_DETAILS'),
	border : true,
	id:'educationDetail_grid',
	autoScroll : false,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	dockedItems : [ {
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype: 'custompagingtoolbar',
            plugins:['pagesize'],
            store : 'enquiry.exam.ExamDetailStore',
		    emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
		    displayInfo : true
		}]
	}],
    initComponent: function() {
        var grid=this;                   
        grid.addExportToolBarItems(grid);
        this.callParent(arguments);     
 },
	tbar : [ {
		xtype : 'button',
		itemId : 'btnAdd',
		tooltip : getCommonTranslation('ADD'),
		glyph : ICONGLYPH.ADDGLYPH,
        hasDisableForProfileViewMode:true
	}, {
		xtype : 'button',
		itemId : 'btnEdit',
		tooltip : getCommonTranslation('EDIT'),
		glyph : ICONGLYPH.EDITGLYPH,
        hasDisableForProfileViewMode:true
	}, {
		xtype : 'button',
		itemId : 'btnView',
		tooltip : getCommonTranslation('VIEW'),
		iconCls : 'view-icon'
	}, {
		xtype : 'button',
		itemId : 'btnDelete',
		cls : 'CustomToolbarBtnReject',
		tooltip : getCommonTranslation('DELETE'),
		glyph : ICONGLYPH.DELETEGLYPH,
        hasDisableForProfileViewMode:true
	} ],
	plugins : [ {
		ptype : 'rowexpander',
		rowBodyTpl : [ '<tpl for="."><tpl if="!Ext.isEmpty(subjectMarkInfo)">',
		               	'<table style="border:1px solid black; width:50%;">',

		               	'<col style="width:20%">',
		                '<col style="width:10%">',
		                '<thead>',
		                '<tr>',
		                        '<th style="width:100px;border-bottom:1px solid black;background-color: #f2f2f2">'+getEnquiryTranslation('SUBJECT')+'</th>',
		                        '<th style="width:100px;border-bottom:1px solid black;background-color: #f2f2f2">'+getEnquiryTranslation('MARKS_GRADE')+'</th>',
		                '</tr>',
		                '</thead>',
		               		'<tpl for="subjectMarkInfo">',
		               			'<tr>',
		               				'<td style="width:100px;text-align:center">{subject.value}</td>',
		               				'<td style="width:100px;text-align:center">{marks}</td>',
		               			'</tr>',
		               		'</tpl>',
		               	'</table></tpl>',
		               '</tpl>' ]
	} ],
	columns : [ {
		header : getEnquiryTranslation('EXAM_CONDUCTED_BY_COLLAGE'),
		dataIndex : 'examConductedBy',
		sortable : true,
		hidden : true,
		flex : 1
	},{
		header : getEnquiryTranslation('EXAM_PASSED'),
		dataIndex : 'examPassed',
		sortable : true,
		flex : 1,
		renderer: function(value){
			return columnObjRender(value,"value");
		}
	},{
		header : getEnquiryTranslation('EXAM_CONDUCTED_BY_COLLAGE'),
		dataIndex : 'examConductedBy',
		sortable : true,
		flex : 1
	},{
		header : getEnquiryTranslation('INSTITUTE_NAME'),
		dataIndex : 'instituteName',
		sortable : true,
		flex : 1
	},{
		header : getEnquiryTranslation('MARKS_GRADE_OBTAINED'),
		dataIndex : 'marksOrGradeObtained',
		sortable : true,
		flex : 1
	},{
		header : getEnquiryTranslation('GPA/Percentage'),
		dataIndex : 'percentage',
		sortable : true,
		flex : 1
	}, {
		header : getEnquiryTranslation('YEAR_OF_EXAM'),
		dataIndex : 'yearOfExamination',
		sortable : true,
		flex : 1
	}, {
		header : getEnquiryTranslation('RESULT_STATUS'),
		dataIndex : 'resultStatus',
		sortable : true,
		flex : 1,
		renderer: function(value){
			return columnObjRender(value,"value");
		}
	/*}, {
		header : getEnquiryTranslation('ENROLLMENT_NUMBER'),
		dataIndex : 'enrollmentNumber',
		sortable : true,
		flex : .2*/
	}],

    

});