/**
 * @author Ravi Choudhary
 */
Ext.define('Academia.view.enquiry.EnquiryFormRevamp', {
	extend:'Academia.view.common.IdGeneratorCustomForm',
	customFieldEntity:CONSTANTS.ENQUIRY_RAISE_CF_DATA,
	columns: 1,
	title: getEnquiryTranslation('ENQUIRY_FORM_TITLE'),
	alias: 'widget.enquiryformrevamp',
	autoScroll: true,
	frame: true,
	method: 'POST',
	standardSubmit: false,
	plugins : "formlabelrequired",
	layout:'anchor',
	cls:'horizontalScrollingFixed', 
	defaults: {
		width: 226,
		labelAlign: 'top',
		tdAttrs: { style: 'padding: 5px;' }
	},
	items: [{
		xtype: 'hidden',
		name: 'id'
	},{
		xtype: 'hidden',
		name: 'status',
		value:'O'
	},{
		xtype: 'hidden',
		name: 'regType',
		itemId: 'regType'
	},{
		xtype: 'hidden',
		name: 'modeOfDelivery',
		itemId: 'modeOfDelivery'
	},{	
		xtype:'fieldcontainer',
		layout:'hbox',
		width:'100%',
		defaults: {
			width: 226,
			labelAlign: 'top'
		},
		items:[{
			xtype: 'customcombobox',
			name: 'enquiryType',
			allowBlank:false,
			store: 'enquiry.EnquiryTypeStore',
			fieldLabel: getEnquiryTranslation('ENQUIRY_TYPE'),
			valueField: 'id',
			displayField: 'enquiryTypeName',
			itemId: 'enquiryTypeCombo',
			typeAhead:true,
			forceSelection:true
		},{
			xtype: 'customcombobox',
			name: 'registeredBy',
			itemId: 'registeredBy',
			fieldLabel: getEnquiryTranslation('ENQUIRED_BY'),
			store: 'enquiry.EnquiryRegisteredBy',
			allowBlank:false,
			valueField: 'id',
			displayField: 'value',
			typeAhead:true,
			forceSelection:true,
			editable: false
		},{
			xtype: 'customcombobox',
			name: 'enqRegByStudent',
			itemId:'enqRegByStudent',
			//allowBlank:false,
			hidden:true,
			store: 'enquiry.ReferredStudentId',
			valueField: 'studentId',
			displayField: 'printName',
			queryParam:'name',
			minChars:3,
			editable:true,
			typeAhead:true,
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,  
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerAction: '',
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{printName}' +
					'</div>';
				}
			},
			fieldLabel: getCommonTranslation('STUDENT_EXISTISING'),
		},{
			xtype: 'customcombobox',
			name: 'enqRegByInternalUser',
			itemId:'enqRegByInternalUser',
			//allowBlank:false,
			hidden:true,
			store: 'enquiry.ReferredInternalUserId',
			valueField: 'code',
			displayField: 'nameToBePrinted',
			queryParam:'codeOrName',
			minChars:3,
			editable:true,
			typeAhead:true,
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,  
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerAction: '',
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{printName}' +
					'</div>';
				}
			},
			fieldLabel: getCommonTranslation('STUDENT_EXISTISING'),
		},{
			xtype: 'textfield',
			name: 'enqRegByStudentUserName',
			fieldLabel: getEnquiryTranslation('STUDENT_NAME'),
			allowBlank:true,
			hidden:true,
			disabled:true
		}]
	},{	
		xtype:'fieldcontainer',
		layout:'hbox',
		width:'100%',
		defaults: {
			width: 226,
			labelAlign: 'top'
		},
	},{
		xtype:'fieldcontainer',
		layout:'hbox',
		width:'100%',
		defaults: {
			width: 226,
			labelAlign: 'top',
			//regex: /[a-zA-Z0-9]+/
		},
		items:[{        	
			xtype: 'customcombobox',
			name: 'raiseEnquirySalutation',
			fieldLabel:getCommonTranslation('TITLE'),
			store: 'common.SalutationStore',
			queryMode: 'remote',
			valueField: 'id',
			displayField: 'salutationName',
			//width: 100,
			allowBlank:false,
			itemId:'raiseEnqSalutaion',
			forceSelection:true,
			editable: false
		},{
			xtype: 'textfield',
			name: 'enquirerFirstName',
			itemId: 'enquirerFirstNameId',
			fieldLabel: getEnquiryTranslation('PARENT_FIRST_NAME'),
			allowBlank:false,
			maxLength:75,
			//maskRe:/^[a-zA-Z ]+$/,
			enforceMaxLength : true,
			minChars:3,
			editable:true,
			typeAhead:true,
		},{
			xtype: 'textfield',
			name: 'enquirerMiddleName',
			itemId: 'enquirerMiddleNameId',
			fieldLabel: getEnquiryTranslation('PARENT_MIDDLE_NAME'),
			maxLength:75,
			//maskRe:/^[a-zA-Z ]+$/,
			enforceMaxLength : true

		}]  

	},{   
		xtype:'fieldcontainer',
		layout:'hbox',
		width:'100%',
		defaults: {
			width: 226,
			labelAlign: 'top'
		},
		items:[{
			xtype: 'textfield',
			name: 'enquirerLastName',
			itemId: 'enquirerLastNameId',
			fieldLabel: getEnquiryTranslation('PARENT_LAST_NAME'),
			allowBlank:false,
			maxLength:75,
			//maskRe:/^[a-zA-Z .]+$/,
			enforceMaxLength : true
		},{
			xtype: 'textfield',
			name: 'regdEmail',
			itemId:'regdEmail',
			fieldLabel: getEnquiryTranslation('PARENT_EMAIL'),
			vtype:'myemail',
			allowBlank:false,
			maxLength:100,
			enforceMaxLength : true
		},{
			xtype:'fieldcontainer',
			labelSeparator : '',
			fieldLabel: getEnquiryTranslation('PARENT_ADDRESS_MOBILE_NO')+':<span class="required" style="color:red"> *</span>',
			itemId:'parentMobileNoRaiseEnquiry',
			layout:'hbox',
			labelAlign:'top',
			items:[{
				xtype: 'customcombobox',
				valueField: 'isdCode',
				displayField: 'isdCode',
				store: 'common.CountryStore',
				itemId:'phoneCountryCode',
				triggerAction: 'all',
				name: 'phoneCountryCode',
				width: 80,
				typeAhead:true,
				forceSelection:true,
				emptyText: 'Code', 
				allowBlank:false	,
				minChars: 1
			},{
				xtype: 'numberfield',
				name: 'cellNumber',
				itemId:'cellNumber',
	//			fieldLabel: getEnquiryTranslation('ADDRESS_MOBILE_NO'),
				minLength: 0,
				maxLength: 15,
				allowNegative: false,
			    minValue: 1,
				allowBlank:true,
				hideTrigger:true,
				mouseWheelEnabled:false,
				width: 135,
				enforceMaxLength : true,			
				emptyText: 'Mobile Number',
				allowBlank:false
				/*style:{
					marginTop:'28px'
				}*/
			//allowDecimals : false,
			//	regex:new RegExp('^\\d{1}[.05]*$')
			//regex:new RegExp('^\\d{1,}[.05]*$')
			//regexText: 'decimal are not allowed'
			}]
		}]  
	},{
		xtype:'fieldcontainer',
		layout:'hbox',
		width:'100%',
		defaults: {
			width: 226,
			labelAlign: 'top'
		},
		items:[{
			xtype:'fieldcontainer',
			fieldLabel: getEnquiryTranslation('ALTERNATE_NUMBER'),
			layout:'hbox',
			labelAlign:'top',
			items:[{
				xtype: 'customcombobox',
				valueField: 'isdCode',
				displayField: 'isdCode',
				store: 'common.CountryStore',
				itemId:'alternatePhoneCountryCode',
				triggerAction: 'all',
				name: 'alternatePhoneCountryCode',
				width: 80,
				typeAhead:true,
				forceSelection:true,
				emptyText: 'Code',
				minChars: 1
	
			},{
				xtype: 'numberfield',
				name: 'alternateCellNumber',
				itemId:'alternateCellNumber',
	//			fieldLabel: getEnquiryTranslation('ADDRESS_MOBILE_NO'),
				minLength: 0,
				maxLength: 15,
				allowNegative: false,
			    minValue: 1,
				allowBlank:true,
				hideTrigger:true,
				mouseWheelEnabled:false,
				width: 135,
				enforceMaxLength : true,			
				emptyText: 'Mobile Number',
			}]
		},{
			 xtype: 'datefield',
			 name: 'enquiryDate',
			 itemId:'enquiryDate',
			//--submitFormat: 'd-m-Y',
			 itemId:'enquiryDateItemId',
			 fieldLabel: getEnquiryTranslation('ENQUIRY_DATE'),
//			 value: new Date(),
			 maxValue:new Date(),
			 allowBlank:false,
			 listeners: {
				 render: function(obj) {
					 obj = dateFormatRender(obj);						
					 obj.setValue(new Date());
				 }
			 }

		 },{
			 xtype: 'customcombobox',
			 name: 'followUpUser',
			 store: 'enquiry.FollowUpUserWithDepartment',
			 fieldLabel: getEnquiryTranslation('ENQUIRY_OWNER'),
			 valueField: 'id',
			 displayField: 'value',
			 itemId:'followUpUser',
			 queryParam:'name',
			 minChars:3,
			 editable:true,
			 typeAhead:true,
			 triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			 enableKeyEvents  : 'true',
			 hideTrigger:false,
			 emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			 triggerAction: '',
			 forceSelection:true,
			 allowBlank:false,
			 listConfig: {
				 listeners: {
					 beforeshow: function(picker) {
						 picker.minWidth = picker.up('combobox').getSize().width;
					 }
				 },
				 loadingText: getCommonTranslation('SEARCHING'),
				 emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				 getInnerTpl: function() {
					 return '<div class="search-item">' +
					 '{value}'+
					 '</div>';
				 }
			 }
		 }]  
	
	},{
		 xtype:'fieldcontainer',
		 layout:'hbox',
		 width:'100%',
		 defaults: {
			 width: 226,
			 labelAlign: 'top'
		 },
		 items:[{
				xtype: 'customcombobox',
				name: 'campaignNew',
				itemId: 'campaignNew',
				fieldLabel : getCommonTranslation("BRAND_CAMPAIGN_NAME"),
				valueField: 'id',
				displayField: 'value',
				store: 'campaignnew.CampaignNameFilterStore',
				queryParam:'campaignName',
				minChars:3,
				forceSelection:true,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
							picker.width = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					}
				}
			}, {
				xtype: 'textfield',
				name: 'campaignType',
				itemId:'campaignType',
				fieldLabel: getCommonTranslation('CAMPAIGN_TYPE'),
				readOnly: true
			}, {
				xtype: 'textfield',
				name: 'presentationType',
				itemId:'presentationType',
				fieldLabel: getCommonTranslation('PRESENTATION_TYPE'),
				readOnly: true
			}, {

		 }]
	 },{
		 xtype:'fieldcontainer',
		 layout:'hbox',
		 width:'100%',
		 defaults: {
			 width: 226,
			 labelAlign: 'top'
		 },
		 items:[{
				xtype: 'customcombobox',
				name: 'educationDepartment',
				itemId: 'educationDepartmentItemId',
				store: 'enquiry.EducationDepartmentStore',
				fieldLabel: getEnquiryTranslation('EDUCATION_DEPARTMENT'),
				valueField: 'id',
				displayField: 'value',
				allowBlank: true,
				forceSelection: true,
				editable: false
			},{
			 xtype: 'customcombobox',
			 name: 'campaignSchool',
			 itemId: 'campaignSchool',
			 fieldLabel: getCommonTranslation("SCHOOL"),
			 valueField: 'schoolId',
			 displayField: 'schoolName',
			 store: Ext.create('Academia.store.campaignnew.CampaignSchoolNameStore'),
			 queryParam:'schoolName',
			 minChars:3,
			 allowBlank:true,
			 forceSelection:true,
			 emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			 listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
							picker.width = picker.up('combobox').getSize().width;
						}
					},
			 loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					}
				}
		 },{
			 xtype: 'customcombobox',
			 name: 'schoolPriorityNew',
			 itemId:'schoolPriorityNew',
			 fieldLabel: getCommonTranslation('SCHOOL_PRIORITY'),
			 store: Ext.create('Academia.store.campaignnew.AllSchoolPriorityStore'),
			 valueField: 'id',
			 displayField: 'value',
			 typeAhead:true,
			 forceSelection:true,
			 allowBlank:true,
			 editable: false,
			 disabled:true
		 }, {
			 xtype: 'textfield',
			 name: 'schoolPriority',
			 itemId:'schoolPriority',
			 fieldLabel: getCommonTranslation('BRAND_CAMP_SCHOOL_PRIORITY'),
			 readOnly: true,
			 hidden:true
		 }, {
				xtype: 'multiselectcombofield',
				name: 'enquiryMode',
				itemId:'enquiryModeItemId',
				fieldLabel: getEnquiryTranslation('MODE_OF_ENQUIRY'),
				store:'enquiry.EnquiryModeStore',
	    		valueField: 'id',
	    		forceSelection:true,
	    		displayField: 'value'
			}
		 ]
	 },{
		 xtype:'fieldcontainer',
		 layout:'hbox',
		 width:'100%',
		 defaults: {
			 width: 226,
			 labelAlign: 'top'
		 },
		 items:[{
			 xtype: 'customcombobox',
			 name: 'enquirySource',
			 itemId:'enquirySource',
			 minChars:3,
			 fieldLabel: getEnquiryTranslation('SOURCE'),
			 store: 'enquiry.EnquirySourceStore',
			 valueField: 'id',
			 displayField: 'value',
			 typeAhead:true,
			 forceSelection:true,
			 allowBlank:false,
			 hidden:false,
			 editable: false
		 }, {
				xtype: 'textfield',
				name: 'enquirySourceOther',
				itemId: 'enquirySourceOther',
				fieldLabel: getEnquiryTranslation('OTHER_SOURCE'),
				maxLength:53,
				enforceMaxLength : true,
				hidden : true

			}, {
			 xtype      : 'radiogroup',
			 fieldLabel : getCommonTranslation('COMPANY_SPONSORED'),
			 itemId: 'isCompanySponsored',
			 name: 'isCompanySponsored',
			 defaults: {
				 flex: 1
			 },
			 layout: 'hbox',
			 items:[{ 
				 boxLabel: getCommonTranslation('YES'), 
				 name: 'whetherCompanySponsored', 
				 inputValue: true
			 },{ 
				 boxLabel: getCommonTranslation('NO'), 
				 name: 'whetherCompanySponsored', 
				 inputValue: false,
				 checked:true
			 }]
		 }, {
			 xtype: 'customcombobox',
			 name: 'campaign',
			 itemId: 'raiseEnquiryCampaign',
			 fieldLabel: getEnquiryTranslation('ENQUIRY_CAMPAIGN_NAME'),
			 store: 'campaign.CampaignComboStore',
			 valueField: 'id',
			 displayField: 'value',
			 queryParam:'codeOrName',
			 minChars:3,
			 typeAhead:true,
			 forceSelection:true,
			 emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			 listConfig: {
				 listeners: {
					 beforeshow: function(picker) {
						 picker.minWidth = picker.up('combobox').getSize().width;
					 }
				 },
				 loadingText: getCommonTranslation('SEARCHING'),
				 emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				 getInnerTpl: function() {
					 return '<div class="search-item">' +
					 '{code} / {value}'  +
					 '</div>';
				 }
			 }
		 }/*,{
			 xtype: 'customcombobox',
			 name: 'campaignNew',
			 itemId: 'captutreLeadCampaign',
			 fieldLabel: getEnquiryTranslation('ENQUIRY_CAMPAIGN_NAME'),
			 store: 'campaignnew.CampaignOpenComboStore',
			 valueField: 'id',
			 displayField: 'value',
			 hidden:true,
			 maxLength: 500
		 }*/
		 ]
	  },{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			width: '100%',
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			items: [{
				xtype: 'customcombobox',
				name: 'countryCombo',
				fieldLabel: getCommonTranslation('ADDRESS_COUNTRY'),
				store: 'common.CountryStore',
				valueField: 'id',
				displayField: 'countryName',
				itemId: 'countryComboId',
				editable:false,
				forceSelection:true

			}, {
				xtype : 'customcombobox',
				fieldLabel : getCommonTranslation('COUNTRY_REGION'),
				name : 'countryRegionCombo',
				itemId : 'countryRegionComboId',
				store:Ext.create('Academia.store.organization.CountryRegionStore'),
				valueField : 'id',
				displayField : 'countryRegionName',
				editable : false,
				valueNotFoundText:"",        		        						
				forceSelection :true,
				disabled:true
			},{
				xtype: 'customcombobox',
				fieldLabel: getCommonTranslation('ADDRESS_CITY'),
				name: 'cityCombo',
				editable: false,
				itemId: 'cityComboId',
				store: Ext.create('Academia.store.organization.CityByCountryRegion'),
				valueField: 'id',
				displayField: 'value',
				disabled:true
			}]
		},{
      	xtype: 'fieldcontainer',
    	width: '100%',
    	layout: {
    		type: 'hbox'
    	},
    	defaults: {
    		width: 226,
    		labelAlign:'top'
    	},
    	items:[{
    		xtype      : 'radiogroup',
    		fieldLabel : getCommonTranslation('IS_ENQ_STUDENT_SA_CITIZEN'),
    		itemId: 'isLearnerSACitizenItemId',
    		name: 'isLearnerSACitizenItemId',
    		hidden:true,
    		defaults: {
    			flex: 1
    		},
    		layout: 'hbox',
    		items:[{ 
    			boxLabel: getCommonTranslation('YES'), 
    			name: 'isLearnerSACitizen', 
    			inputValue: true,
    			checked:true
    		},{ 
    			boxLabel: getCommonTranslation('NO'), 
    			name: 'isLearnerSACitizen', 
    			inputValue: false
    		}]
    	},{
			xtype: 'textfield',
			name: 'nationalId',
			itemId:'nationalId',
			fieldLabel: getEnquiryTranslation('NATIONAL_ID_NUMBER'),
			hidden:true,
			maxLength: 50,
		   // vtype: 'NoSpecialCharactersWithNumberWithoutSpaceAsInput'
		}, {
			xtype: 'customcombobox',
            name: 'programCategory',
            itemId:'programCategoryId',
            fieldLabel: getCommonTranslation('ENQUIRY_PROGRAM_CATEGORY'),
            displayField:'value',
            valueField:'id',
            store:Ext.create('Academia.store.program.ProgramCategoryStore'),
            forceSelection:true
		}, {
			 xtype : 'customcombobox',
			 name : 'enqIntakeYear',
			 itemId : 'enqIntakeYear',
			 fieldLabel : getCommonTranslation('INTAKE_YEAR'),
			 store: Ext.create('Academia.store.common.IntakeYearStore'),
			 valueField : 'id',
			 displayField : 'value',
			 editable : false
		 },{
				xtype      : 'radiogroup',
				fieldLabel : getCommonTranslation('RECEIVE_AUTOMATIC_COMMUNICATION'),
				itemId: 'receiveCommunicationItemId',
				name: 'receiveCommunication',
				defaults: {
					flex: 1
				},
				layout: 'hbox',
				items:[{ 
					boxLabel: getCommonTranslation('YES'), 
					name: 'whetherReceiveCommunication', 
					inputValue: true,
					checked:true
				},{ 
					boxLabel: getCommonTranslation('NO'), 
					name: 'whetherReceiveCommunication', 
					inputValue: false
				}]
			
			}]
    }/*,{		xtype:'label',
			text:'<u>'+ getEnquiryTranslation('ENQUIRY_INFORMATION')+'</u>',
//			labelStyle: 'font-weight:bold',
			style: 'font-weight:bold;',
		 xtype:'displayfield',
		 itemId:'enquiryInfo',
		 value:'<b class="menu-title">'+getEnquiryTranslation('ENQUIRY_INFORMATION')+'</b>',
		 style: {
			 textDecoration: "underline"
		 }
	 }*/,{
		 xtype: 'panel',
		 width:'100%',
		 cls: 'panelNoSpace',
		 items: [{
			 xtype : 'enquirygrid',
			 hidden:false,
			 margin: '8 0 25 0'
		 }]
	 },{
		 xtype:'fieldcontainer',
		 width:'auto',
		 layout: {
			 type: 'hbox'
		 },
		 items: [{

			 xtype: 'button',
			 action: 'Submit',
			 text: getCommonTranslation('SAVE'),
			 formBind: true,
			 itemId: 'enquirySubmitButtonId',
			 ui: 'CustomBtnSubmit',
			 scale: CONSTANTS.BUTTONSIZE
		 },{
			 xtype: 'button',
			 text: getCommonTranslation('RESET'),
			 ui: 'CustomBtnCancel',
			 itemId:'enquiryform_cancelbuttonId',
			 scale: CONSTANTS.BUTTONSIZE

		 }]
	 }]
});
