Ext.define('Academia.view.enquiry.EnquiryRevampGrid', {
	extend : 'Ext.grid.Panel',
	alias : 'widget.enquiryrevampgrid',
    store : 'enquiry.EnquiryGridStore',
	title : getCommonTranslation('ENQUIRY_STUDENT_DETAILS'),
//	hidden:true,
	border : true,
	autoScroll : true,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	
	tbar : [ {
		xtype : 'button',
		itemId : 'btnAdd',
		tooltip : getCommonTranslation('ADD'),
		glyph : ICONGLYPH.ADDGLYPH
	},
	{
		xtype : 'button',				
		itemId : 'btnEdit',
		tooltip : getCommonTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH
	},
	{
			xtype : 'button',				
			itemId : 'btnDelete',
			cls: 'CustomToolbarBtnReject',
			tooltip :getCommonTranslation('DELETE'),
			glyph: ICONGLYPH.DELETEGLYPH
	}
	],
	columns : [{
		header : getCommonTranslation('TRACK_ENQUIRER_STUDENT_NAME'),
		dataIndex : 'studentName',
		flex : 1,
		sortable : true
	}, {
	    header : getCommonTranslation('ACADEMY'),
	    dataIndex : 'academy',
	    sortable : true,
	    flex : 1
	}, {
	    header : getCommonTranslation('LOCATION'),
	    dataIndex : 'location',
	    sortable : true,
	    flex : 1
	}, {
	    header : getCommonTranslation('PROGRAM'),
	    dataIndex : 'program',
	    sortable : true,
	    flex : 1
	}, {
	    header : getCommonTranslation('ACADEMIC_BATCH'),
	    dataIndex : 'batchName',
	    flex : 1
	},{
	    header : getCommonTranslation('SEAT_TYPE'),
	    dataIndex : 'seatType',
	    flex : 1
	},{
		hidden:true,
	    dataIndex : 'studentFName'
	},{
		hidden:true,
	    dataIndex : 'studentMName'
	},{
		hidden:true,
	    dataIndex : 'studentLName'
	},{
		header : getCommonTranslation('DOB_OF_STUDENT'),
		dataIndex : 'studentDateOfBirth'/*,
	    renderer:function(val){		
			return dateRender(val);
		}*/
	},{
		hidden:true,
	    dataIndex : 'academyId'
	},{
		hidden:true,
	    dataIndex : 'locationId'
	},{
		hidden:true,
	    dataIndex : 'programId'
	},{
		hidden:true,
	    dataIndex : 'batchId'
	},{
		hidden:true,
	    dataIndex : 'seatTypeId'
	}  	
	
	/*, {
	    header : "Status",
	    dataIndex : 'status',
	    renderer : function(value) {
		if (value) {
		    return value = 'Active';
		} else {
		    return value = 'Inactive';
		}
		console.log(value);
	    }
	} */]

});