/**
 * Rajkumar
 */
Ext.define('Academia.view.enquiry.EnquiryTabStructure', {
	extend : 'Ext.form.FormPanel',
	alias : 'widget.enquirytabstructure',
	plain: true,
	title:getEnquiryTranslation('ENQUIRY_DETAILS'),
	style:{
    	marginLeft:CONSTANTS.MARGIN_LEFT_FOR_FORM
    },
	border:true,
	autoScroll: false,
	method: 'POST',
	standardSubmit: true,
	frame:false,
	layout : {
		type : 'vbox',
		align: 'stretch'
	},
	items : [{
		xtype:'fieldcontainer',
		layout:'hbox',
		style:{marginTop:'20px',marginLeft:'20px', marginBottom:'15px'},
		width: '100%',
		defaults: {
			width: 130,
			labelAlign: 'top'
		},
		items:[{
			xtype:'hidden',
			id:'hiddenEnquiryId',
			itemId:'hiddenEnquiryId',
			name:'enqId'
		},{
			xtype:'hidden',
			itemId:'hiddenEnquiryStudentEmail',
			name:'hiddenEnquiryStudentEmail'
		},{
			xtype:'hidden',
			itemId:'hiddenEnquiryMobileNo',
			name:'hiddenEnquiryMobileNo'
		},{
			xtype:'hidden',
			itemId:'hiddenEnquiryMobileCode',
			name:'hiddenEnquiryMobileCode'
		},{
			xtype:'textfield',
			id:'enquiryTxtId',
			hidden:true,
			width: 226,
			submitValue:true,
			readOnly:true,
			itemId:'enquiryTxtId',
			name:'enquiryTxtId',
			fieldLabel: getEnquiryTranslation('ENQUIRY_ID')
		},{
			xtype:'displayfield',
			submitValue:true,
			name:'enquiryId',
			id:'dispalyEnquiryId',
			itemId:'dispalyEnquiryId',
			fieldLabel: getEnquiryTranslation('ENQUIRY_ID')
		},{
			xtype:'displayfield',
			id:'dispalyEnquiryStatus',
			name:'enquiryStatus',
			itemId:'dispalyEnquiryStatus',
			style:{'margin-left':'20px !important'},
			fieldLabel: getEnquiryTranslation('TRACK_ENQUIRY_STATUS')
		},{
			xtype: 'displayfield',
			id:'enqtab_intermediateStage',
			itemId:'enqtab_intermediateStage',
			style:{'margin-right':'50px !important'},
			name: 'stage',
			//width: 180,
			fieldLabel: getEnquiryTranslation('ENQ_STAGE')
		},{
			xtype:'displayfield',
			id:'assignToId',
			name:'assignTo',
			hidden:true,
			itemId:'assignToId',
			fieldLabel: getEnquiryTranslation('ASSIGN_TO'),
			renderer:function(value,rec){
				if(!isNullOrEmpty(value)){
					rec.inputEl.el.dom.setAttribute('data-qtip',value);
					rec.inputEl.el.dom.style.textAlign = 'left';
					rec.inputEl.el.dom.style.overflow = 'hidden'; 
					rec.inputEl.el.dom.style.display = '-webkit-box';
					rec.inputEl.el.dom.style.webkitBoxOrient='vertical';
					rec.inputEl.el.dom.style.webkitLineClamp='3';
				}
				return value;
		    }
		},{
			xtype: 'displayfield',
			id:'displayStudentName',
			itemId:'displayStudentName',
			hidden:true,
			name: 'studentname',
			fieldLabel: getEnquiryTranslation('STUDENT_NAME'),
			renderer:function(value,rec){
				if(!isNullOrEmpty(value)){
					rec.inputEl.el.dom.setAttribute('data-qtip',value);
					rec.inputEl.el.dom.style.textAlign = 'left';
					rec.inputEl.el.dom.style.overflow = 'hidden'; 
					rec.inputEl.el.dom.style.display = '-webkit-box';
					rec.inputEl.el.dom.style.webkitBoxOrient='vertical';
					rec.inputEl.el.dom.style.webkitLineClamp='3';
				}
				return value;
		    }
		},{
			xtype: 'displayfield',
			id:'displayParentName',
			itemId:'displayParentName',
			name: 'parentName',
			fieldLabel: getEnquiryTranslation('PARENT_FIRST_NAME'),
			renderer:function(value,rec){
				if(!isNullOrEmpty(value)){
					rec.inputEl.el.dom.setAttribute('data-qtip',value);
					rec.inputEl.el.dom.style.textAlign = 'left';
					rec.inputEl.el.dom.style.overflow = 'hidden'; 
					rec.inputEl.el.dom.style.display = '-webkit-box';
					rec.inputEl.el.dom.style.webkitBoxOrient='vertical';
					rec.inputEl.el.dom.style.webkitLineClamp='3';
				}
				return value;
		    }
		},{
			xtype: 'displayfield',
			fieldLabel: getEnquiryTranslation('PROGRAM_INTAKE_YEAR'),
			id:'displayGradeIntakeYear',
			itemId:'displayGradeIntakeYear',
			name: 'gradeintakeYear',
			renderer:function(value,rec){
				if(!isNullOrEmpty(value)){
					rec.inputEl.el.dom.setAttribute('data-qtip',value);
					rec.inputEl.el.dom.style.textAlign = 'left';
					rec.inputEl.el.dom.style.overflow = 'hidden'; 
					rec.inputEl.el.dom.style.display = '-webkit-box';
					rec.inputEl.el.dom.style.webkitBoxOrient='vertical';
					rec.inputEl.el.dom.style.webkitLineClamp='3';
				}
				return value;
		    }
		},{
			xtype:'textfield',
			id:'studentDetailId',
			hidden:true,
			itemId:'studentDetailId',
			name:'studentDetailId'
		},{
			xtype:'hidden',
			id:'enqTypeId',
			itemId:'enqTypeId',
			name:'enqTypes'
		},{
			xtype:'hidden',
			name:'intermediateStageId',
			itemId:'enqtab_intermediateStageId',
			id:'enqtab_intermediateStageId'
		},{
			xtype:'displayfield',
			id:'dispalyPriority',
			name:'priority',
			itemId:'dispalyPriority',
			hidden:true,
			fieldLabel: getEnquiryTranslation('ASSIGN_TO')
		}/*,{
			xtype:'displayfield',
			id:'assignToId',
			name:'assignTo',
			hidden:true,
			width:460,
			itemId:'assignToId',
			fieldLabel: getEnquiryTranslation('ASSIGN_TO')
		}*/,{
			xtype:'hidden',
			id:'dispalyPriorityId',
			itemId:'dispalyPriorityId',
			name:'priorityId'
		},{
			xtype: 'hidden',
			name: 'buttonType',
			id:'buttonType',
			itemId:'buttonTypeItemId'
		},{
			xtype: 'hidden',
			name: 'forEnquiryStaffTargetFlag',
			id:'forEnquiryStaffTargetFlag',
			itemId:'forEnquiryStaffTargetFlag'
		}]
	},{
		xtype:'panel',
		itemId:'enquiryTabPanelArea',
		items:[]
	}/*{
		xtype:'tabpanel',
		plain: true,
		id:'enquiry_tabPanelId',
		itemId:'enquirytabpanel',
		style:{margin:'0!important'}, 
		border:false,
		frame: false,
		name:'tabPanels',
		items : [{
			title : getEnquiryTranslation('ENQUIRY_DETAILS'),      
			xtype: 'enquirydetailstructure',
			itemId:'enquirydetailsId',
			frame: false,
			border:false,
			closable: false
		}, {
			title :  getEnquiryTranslation('STUDENT_DETAILS'), 
			xtype: 'studentdetailstructure',
			itemId:'studentdetailsId',
			id:'enquirytabpanel_studentdetailsId',
			frame: false,
			border:false,
			closable: false
			},{
			title : getEnquiryTranslation('EDUCATION_DETAILS'),             
			xtype: 'educationdetailstructure',
			itemId:'examdetailsId',
			frame: false,
			border:false,
			closable: false 
		},{
			title : getEnquiryTranslation('ADMISSION_DEATILS'),             
			xtype: 'admissionreqmntstructure',
			frame: false,
			border:false,
			closable: false
	    },{
			title : getEnquiryTranslation('FOLLOW_UP_DETAIL'),             
			xtype: 'followupstructure',
			frame: false,
			border:false,
			closable: false	
		},{
			title : getEnquiryTranslation('CLOSURE_TITLE'),             
			xtype: 'closuredetailstructure',
			frame: false,
			border:false,
			closable: false
		}/*{
			title : getEnquiryTranslation('ENQUIRY_CHECK_LIST_TITLE'),             
			xtype: 'checkliststructure',
			closable: false
		}]

	}*/]
});
