/**
 * @author Ravi.patidar
 */
Ext.define('Academia.view.enquiry.dashboard.EnquirySummaryForm', {   
	extend : 'Ext.form.Panel',
	alias : 'widget.enquirysummaryform',
	autoScroll: false,
	frame: false,
	cls:'customSearchPanel',
	layout: 'vbox',
	plugins : "formlabelrequired",
	items: [{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 226,
			labelAlign: 'top'
		},
		items:[{
			xtype : 'customcombobox',
			fieldLabel : getEnquiryTranslation('INTAKE_YEAR'),
			name : 'intakeYear',
			itemId : 'intakeYear',
			displayField:'value',
			valueField:'id',
			width:226,
			allowBlank:false,
			//typeAhead:true,
			forceSelection:true,
            editable: false,
			//minChars:3,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}'  +
					'</div>';
				}
			},
			listeners  :{
				render : function(combo){
					var store=Ext.create('Academia.store.common.IntakeYearStore');
					combo.bindStore(store)
				}
			}
		}]
	},{
		xtype:'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 226,
			labelAlign: 'top'
		},
		items:[{
        	xtype: 'customcombobox',
            name: 'programGroup',
            itemId:'programGroupItemId',
            fieldLabel: getCommonTranslation('PROGRAM_GROUP'),
            store:'program.ProgramGroupStore',
            displayField:'value',
            valueField:'id',
            forceSelection:true
        }, {
        	xtype: 'customcombobox',
            name: 'programCategory',
            itemId:'programCategoryId',
            fieldLabel: getProgramandcourseTranslation('PROGRAM_CATEGORY'),
            store:'program.ProgramCategoryByProgramGroupStore',
            disabled:true,
            displayField:'value',
            valueField:'id',
            forceSelection:true
        }]

	},{
		xtype:'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 226,
			labelAlign: 'top'
		},
		items:[{
			xtype: 'datefield',
			name:'fromDate',
			itemId:'fromDate',
			vtype : 'daterange',
     	   	endDateField : 'toDate',
			fieldLabel: getEnquiryTranslation('FROM_DATE'),
			//--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			}
		},{
			xtype: 'datefield',
			name:'toDate',
			itemId:'toDate',
			vtype : 'daterange',
      	   	startDateField : 'fromDate',
			fieldLabel: getEnquiryTranslation('TO_DATE'),
			//--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			}
		}]

	},{
		xtype: 'fieldcontainer',
		width: 'auto',
		items: [{
			xtype: 'button',
			text: getCommonTranslation('SEARCH'),
			itemId: 'searchBtn',
			formBind:true,
			// buttonAlign: 'left',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE               
		},{
			xtype: 'button',
			text: getCommonTranslation('RESET'),
			itemId: 'resetBtn',
			// buttonAlign: 'left',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE   
		}]	
	}]
});