/**
 * @author
 * Manas
 */
Ext.define('Academia.view.examexecution.RegAssessmentGroupCoreFilter', {
    extend: 'Ext.form.FormPanel',
    alias: 'widget.regassessmentgroupcorefilter',

    autoScroll: false,
    frame: false,
    cls: 'customSearchPanel',
    modal: true,
    method: 'POST',
    standardSubmit: false,
    plugins: "formlabelrequired",

    items: [
        // ---------------------- ROW 1 ----------------------
        {
            xtype: 'fieldcontainer',
            layout: 'hbox',
            defaults: {
                width: 226,
                labelAlign: 'top'
            },
            items: [{
                xtype: 'customcombobox',
                name: 'academicTerm',
                itemId: 'academicTermId',
                fieldLabel: getCommonTranslation('ACADEMIC_TERM'),
                store: Ext.create('Academia.store.common.AcademicTermStore'),
                valueField: 'id',
                displayField: 'value',
                forceSelection: true,
                typeAhead: false,
                allowBlank: false
            }, {
                xtype: 'customcombobox',
                name: 'assessmentGroupId',
                itemId: 'assessmentGroupId',
                store: 'RegEGStores.EvaluationGroupStore',
                displayField: 'itemValue',
                valueField: 'id',
                fieldLabel: getExaminationTranslation('EVALUATION_GROUP'),
                queryParam: 'evaluationGroupCode',
                minChars: 3,
                width: 226,
                typeAhead: false,
                triggerCls: Ext.baseCSSPrefix + 'x-form-trigger',
                enableKeyEvents: true,
                hideTrigger: false,
                forceSelection: true,
                allowBlank: false,
                disabled: true,
                emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
                listConfig: {
                    listeners: {
                        beforeshow: function (picker) {
                            picker.minWidth = picker.up('combobox').getSize().width;
                        }
                    },
                    loadingText: getCommonTranslation('SEARCHING'),
                    emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                    getInnerTpl: function () {
                        return '<div class="search-item">{value}</div>';
                    }
                }
            }]
        },

        // ---------------------- ROW 2 ----------------------
        {
            xtype: 'fieldcontainer',
            layout: 'hbox',
            defaults: {
                width: 226,
                labelAlign: 'top'
            },
            items: [{
                xtype: 'customcombobox',
                name: 'program',
                itemId: 'programItemId',
                store: 'RegEGStores.EvaluationGroupProgramStore',
                fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
                valueField: 'id',
                displayField: 'valueCode',
                queryParam: 'name',
                minChars: 3,
                width: 460,
                typeAhead: false,
                triggerCls: Ext.baseCSSPrefix + 'x-form-trigger',
                enableKeyEvents: true,
                hideTrigger: false,
                forceSelection: true,
                allowBlank: true,
                disabled: true,
                emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
                listConfig: {
                    listeners: {
                        beforeshow: function (picker) {
                            picker.minWidth = picker.up('combobox').getSize().width;
                        }
                    },
                    loadingText: getCommonTranslation('SEARCHING'),
                    emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                    getInnerTpl: function () {
                        return '<div class="search-item">{value}</div>';
                    }
                }
            }, {
                xtype: 'customcombobox',
                name: 'batchId',
                itemId: 'batchIdItemId',
                store: 'RegEGStores.EvaluationGroupBatchStore',
                displayField: 'value',
                valueField: 'id',
                forceSelection: true,
                typeAhead: true,
                minChars: 3,
                disabled: true,
                fieldLabel: getExaminationTranslation('BATCH'),
                allowBlank: true
            }]
        },

        // ---------------------- ROW 3 ----------------------
        {
            xtype: 'fieldcontainer',
            layout: 'hbox',
            defaults: {
                width: 226,
                labelAlign: 'top'
            },
            items: [{
                xtype: 'customcombobox',
                name: 'appStatus',
                itemId: 'appStatus',
			    store: 'RegEGStores.EvaluationGroupApplicationStatusStore',
                displayField: 'value',
                valueField: 'id',
                forceSelection: true,
                typeAhead: true,
                fieldLabel: getExaminationTranslation('APPLICATION_STATUS'),
                disabled: true
            }, {
                xtype: 'customcombobox',
                name: 'groupStatus',
                itemId: 'evaluationGroupStatus',
                store: 'RegEGStores.EvaluationGroupStatusStore',
			    displayField: 'value',
                valueField: 'id',
                typeAhead: true,
                fieldLabel: getExaminationTranslation('EVALUATION_GROUP_STATUS'),
				hidden:false,
                disabled: true,
                forceSelection: true
            }]
        },

        // ---------------------- ROW 4 (HALL TICKET FILTERS) ----------------------
        {
            xtype: 'fieldcontainer',
            layout: 'hbox',
            defaults: {
                width: 226,
                labelAlign: 'top'
            },
            items: [{
                xtype: 'customcombobox',
                name: 'hallticketgenerated',
                itemId: 'hallticketgenerated',
                fieldLabel: getExaminationTranslation('HALL_TICKET_GENERATED'),
               // store: 'examinationcenters.evalresultlisting.HallTicketGeneratedStatusStore',
                displayField: 'name',
                valueField: 'id',
				hidden:true,
                forceSelection: true,
                editable: false,
                value: 'ALL',
                disabled: false
            }, {
                xtype: 'customcombobox',
                name: 'hallticketpublished',
                itemId: 'hallticketpublished',
                fieldLabel: getExaminationTranslation('HALL_TICKET_PUBLISHED'),
              //  store: 'examinationcenters.evalresultlisting.HallTicketPublishedStore',
                displayField: 'name',
                valueField: 'id',
				hidden:true,
                forceSelection: true,
                editable: false,
                value: 'ALL',
                disabled: false
            }]
        },

        // ---------------------- BUTTON ROW ----------------------
        {
            xtype: 'fieldcontainer',
            width: '100%',
            cls: 'windowBtnPos',
            items: [{
                xtype: 'button',
                itemId: 'searchBtn',
                text: getCommonTranslation('SEARCH'),
                ui: 'CustomBtnSubmit',
                scale: CONSTANTS.BUTTONSIZE,
                formBind: true
            }, {
                xtype: 'button',
                text: getCommonTranslation('RESET'),
                itemId: 'resetBtn',
                ui: 'CustomBtnCancel',
                scale: CONSTANTS.BUTTONSIZE
            }]
        }
    ]
});