/**
 * @author
 * Manas
 * @description
 * Grid for “Events Available for Student” (used inside RegGroupApplyWindow)
 */

Ext.define('Academia.view.examexecution.RegGroupApplyEventGrid', {
    extend: 'Ext.grid.Panel',
    alias: 'widget.reggroupapplyeventgrid',

    store: 'RegEGStores.ApplyCoursesGridStore',
    itemId: 'eventGrid',
    title: getMegaMenuTranslation('EVENT_AVAILABLE_FOR_STUDENT'),

    margin: '0 0 0 0',
    height: 240,
    border: true,
    frame: false,

    columnLines: true,
    viewConfig: {
        stripeRows: true,
        emptyText: '<div style="text-align:center;color:#777;margin-top:20px;">No events available</div>',
        deferEmptyText: false
    },

    columns: [
        { xtype: 'checkcolumn', dataIndex: 'selected', width: 40, itemId: 'selectCol' },
        { text: 'Course Name', dataIndex: 'courseName', flex: 1 },
        { text: 'Course Variant', dataIndex: 'courseVariantCode', flex: 1.5 },
        { text: 'Period', dataIndex: 'periodName', flex: 1 },
        { text: 'Section', dataIndex: 'sectionName', flex: 1 },
        { text: 'Assessment Event', dataIndex: 'eventName', flex: 1 }
    ]
});
