/**
 * @author Ankush.Solanki
 */
Ext.define('Academia.view.examinationOBEAttainment.AttainmentRuleGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.attainmentrulegrid',
    title: getExaminationTranslation('ATTAINMENT_RULES_LIST'),
    store:'examinationOBEAttainment.AttainmentRuleGridStore',
    border: true,
    autoScroll: false,
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
   tbar: [{
       xtype: 'button',
       itemId: 'btnAdd',
       tooltip: getCommonTranslation('ADD'),
       glyph: ICONGLYPH.ADDGLYPH,
   }, {
       xtype: 'button',
       itemId: 'btnEdit',
       tooltip: getCommonTranslation('EDIT'),
       glyph: ICONGLYPH.EDITGLYPH,
       disabled: true
   }, {
       xtype: 'button',
       itemId: 'btnDelete',
       tooltip: getCommonTranslation('DELETE'),
       glyph: ICONGLYPH.DELETEGLYPH,
       disabled: true
   }],
    columns: [{
        header: getExaminationTranslation('ATTAINMENT_RULE_NAME'),
        dataIndex: 'value',
        flex:1
    }],
    initComponent: function() {
        var this$ = this;
        Ext.apply(this$, {
            store: 'examinationOBEAttainment.AttainmentRuleGridStore',
            dockedItems: [{
                xtype: 'toolbar',
                dock: 'bottom',
                items: [{
                    xtype: 'custompagingtoolbar',
                    plugins: ['pagesize'],
                    store: 'examinationOBEAttainment.AttainmentRuleGridStore',
                    emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
                    displayInfo: true
                }]
            }]
        });
//        this$.addExportToolBarItems(this$);
        this$.callParent(arguments);
    }
});