/**
 * @author bhanu ps
 */
Ext.define('Academia.view.examinationcenters.assessmentEvent.AssessmentEventGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.assessmenteventgrid',
	store: 'examinationcenters.assessmentEvent.AssessmentEventStore',
	title: getExaminationTranslation('MANAGE_ASSESSMENT_EVENTS'),
	border: true,
	frame:false,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	selType:'checkboxmodel',
	selModel: {
		mode:'MULTI',
		showHeaderCheckbox: true,
		allowDeselect: false,
		checkOnly : false
	},
	dockedItems: [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype : 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'examinationcenters.assessmentEvent.AssessmentEventStore',
			emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);     
	},
	tbar: [{
		xtype: 'button',
		itemId: 'btnSaveDetails',
		tooltip: getCommonTranslation('SAVE'),
		text : getCommonTranslation('SAVE'),
	}, {
		xtype: 'button',
		itemId: 'btnRemoveDetails',
		tooltip: getExaminationTranslation('REMOVE'),
		text : getExaminationTranslation('REMOVE'),
	}, {
		xtype : 'splitbutton',
		itemId:'spBtnMoreActionsAssessmentEvent',
		text : getExaminationTranslation('CHANGE_EVENT_STATUS'),
		menu:[{
			text:getExaminationTranslation('CNTRL_ASSESSMENT_EVENT_PENDING'),
			tooltip: getExaminationTranslation('CNTRL_ASSESSMENT_EVENT_PENDING'),
			itemId:'btnPendingAssessmentEvent'	
		},{
			itemId: 'btnReopenAssessmentEvent',
			tooltip: getExaminationTranslation('OPEN_FOR_MARKENTRY'),
			text:getExaminationTranslation('OPEN_FOR_MARKENTRY'),
		},{
			text:getExaminationTranslation('COMPLETED_MARK_ENTRY'),
			tooltip: getExaminationTranslation('COMPLETED_MARK_ENTRY'),
			itemId:'btnCompletedAssessmentEvent'
		}]
	},/*{
		xtype : 'splitbutton',
		itemId:'spBtnMoreActions',
		text : getFeeAndPaymentCommonTranslation('MOREACTIONS'),
		menu:[{
			text:getExaminationTranslation('RECALCULATE_RESULTS'),
			itemId:'btnRecalculateResult'	
		},{
			text:getExaminationTranslation('MANAGE_QUESTIONS'),
			itemId:'btnManageQuestions'	
		}]
	},*/,{
		xtype: 'button',
		itemId: 'btnRecalculateResult',
		tooltip: getExaminationTranslation('RECALCULATE_RESULTS'),
		text : getExaminationTranslation('RECALCULATE_RESULTS'),
	},{
		xtype: 'displayfield',
		fieldLabel: getCommonTranslation('REMAINING_WEIGHTAGE'),
		itemId: 'remainingWeightage',
		cls: 'remainingWeightageCls',
		width: 226,
		labelWidth: 146
	}],
	columns: [],
	plugins: [{
		ptype : 'cellediting',
		clicksToEdit: 1,
		listeners: {
			//afteredit: function(obj, editor, context){},
			beforeedit: function(obj, editor, context){
				if (((editor.column.dataIndex == "minGrade" || editor.column.dataIndex == "minMarks") || (editor.column.dataIndex == "maxGrade" || editor.column.dataIndex == "maxMarks"))
					&& (obj.grid.getSelectionModel().selected.items[0].data.examStatus === 'CONDUCTED')) {
						return false;
				}
				if(editor.column.dataIndex=="minGrade" && isNullOrEmpty(editor.value)){
					setTimeout(function(){
						editor.column.getEditor().setValue("");
					},10);
				}
				else if(editor.column.dataIndex=="maxGrade" && isNullOrEmpty(editor.value)){
					setTimeout(function(){
						editor.column.getEditor().setValue("");
					},10);
				}
				else if(editor.column.dataIndex=="conductedTime" && isNullOrEmpty(editor.value)){
					setTimeout(function(){
						editor.column.getEditor().setValue("");
					},10);
				}
				else if(editor.column.dataIndex=="conductedTime" && !isNullOrEmpty(editor.value)){
					setTimeout(function(){
						var date = new Date();
						var newVal = editor.value.split(':');
						date.setHours(newVal[0]);
						date.setMinutes(newVal[1]);
                        var setTime = Ext.Date.format(date, 'H:i');
						editor.column.getEditor().setValue(setTime);
					},0);
				}
				var dataindex = editor.column.dataIndex;
				var selected = editor.record;
				var removeBtn = obj.grid.down('#btnRemoveDetails');
				if((dataindex == 'userDefinedWeighting' || dataindex == 'minMarks' || dataindex == 'maxMarks') && !isNullOrEmpty(selected.get('copyEventId'))) {
					removeBtn.disable();
					return false;
				}
				if(dataindex == 'maxMarks') {
					if(selected.data.id != null) {
						var flag = Academia.app.getController('Academia.controller.examinationcenters.assessmentEvent.AssessmentEventController').checkMarkentryStatusOfEvent(selected);
						return !(flag.responseText == "true");
					}
					else{
						return true;
					}
				}
			}
		}
	}]
});
