/**
 * @author 
 */
Ext.define('Academia.view.examinationcenters.assessmentEvent.DownloadConductedDateFilter', {
	extend: 'Ext.form.Panel',
	alias: 'widget.downloadconducteddatefilter',
	autoScroll: false,
	frame: false,
	standardSubmit: false,
	plugins:"formlabelrequired",
	items: [{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 226,
			labelAlign: 'top'
		},
		items: []
	},{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
//			width: 460,
			labelAlign: 'top'
		},
		items: [{
            xtype: 'customcombobox', 
            name: 'academicTermId',
            itemId:'academicTermId',
            labelAlign:'top',
            queryMode: 'local',
            groupField: 'code',
            groupDisplayField: 'code',
            store:'common.AcademicTermStore', 
            fieldLabel: getCommonTranslation('ACADEMIC_TERM'), 	
            displayField: 'value',
            valueField: 'id', 
            minChar : 3,
            width: 226,
			allowBlank:false, 
            forceSelection:true,  //V2D-401618
            listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
						picker.maxWidth = picker.up('combobox').getSize().width;  
					}
            },
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>'; 
				}
			}
        },{
			xtype: 'customcombobox',
			name:'planId',
			itemId:'planId', 
			store:'examinationcenters.assessmentEvent.EligibleStudentsEvaluationPlanForEventStore',
			fieldLabel:getExaminationTranslation('EVALUATION_PLAN'),
			valueField: 'id',
			width: 226,
			displayField: 'value',
			queryParam:'evaluationPlanNumber',
			minChars:3,
			typeAhead:false,
			allowBlank:false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			hidden:false,
			disabled:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
						picker.maxWidth = picker.up('combobox').getSize().width;
					}
					
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			},select: function(combo, records){
						var form = combo.up('form'); 
						if(form.down('#academicTermId').getValue() && form.down('#planId').getValue()){
							form.down('#dateDownload').setDisabled(false);
						}
					} 

		}]
	},{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 226,
			labelAlign: 'top'
		},
		items: []
	},{ 
		xtype: 'fieldcontainer',
		width:'100%',
		cls:'windowBtnPos',
		items: [{
			xtype:'button',
			itemId:'dateDownload',
			disabled:true,
			text:getExaminationTranslation('MARK_ENTRY_DOWNLOAD'), 
			ui: 'CustomBtnSubmit',
			formBind:true
		}, 
		{
			xtype: 'button',
			text: getCommonTranslation('RESET'),
			itemId:'resetBtn',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE
		}]
	}]
});
