/**
 * @author Rohit Sharma
 */
Ext.define('Academia.view.examinationcenters.assessmentEvent.DownloadPreExamDetailFilter', {
    extend: 'Ext.form.Panel',
    alias: 'widget.downloadPreExamDetailFilter',
    autoScroll: false,
    frame: false,
    standardSubmit: false,
    plugins: "formlabelrequired",
    items: [{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            width: 226,
            labelAlign: 'top'
        },
        items: [{
        	xtype: 'hidden',
        	name: 'assessmentSchemeId'
        }, {
        	xtype: 'hidden',
        	name: 'courseIds'
        }, {
        	xtype: 'hidden',
        	name: 'assessmentEventIds'
        }, {
        	xtype: 'hidden',
        	name: 'assessmentLevelSelected'
        }, {
			xtype: 'customcombobox',
			name:'templateFor',
			itemId:'downloadTemplateForItemId',
			store: Ext.create('Ext.data.Store', {
				fields: [
			    	'id',
			    	'value',
			    	'displayValue'
			    ],
			    data: [{
			    	displayValue: getCommonTranslation('ImportConcessionAllocation'),
			    	value: 'Import Concession Allocation'
			    }, {
			    	displayValue: getCommonTranslation('ImportNonConcessionAllocation'),
			    	value: 'Import Non Concession Allocation'
			    }]
			}),
			fieldLabel : getProgramandcourseTranslation('TEMPLATE_FOR'),	
			valueField: 'displayValue',
			displayField: 'displayValue',
			typeAhead:false,
			allowBlank:false,
			forceSelection: true,
			editable: false,
			listConfig: {
                listeners: {
                    beforeshow: function (picker) {
                        picker.minWidth = picker.up('combobox').getSize().width;
                        picker.maxWidth = picker.up('combobox').getSize().width;
                    }
                },
                loadingText: getCommonTranslation('SEARCHING'),
                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                getInnerTpl: function () {
                    return '<div class="search-item">' +
                        '{value}' +
                        '</div>';
                }
            }
		}]
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        hidden: true,
        disabled: true,
        itemId: 'container1',
        defaults: {
            width: 226,
            labelAlign: 'top'
        },
        items: [{
            xtype: 'customcombobox',
            name: 'administrativeBy',
            itemId: 'administrativeByRoomAndStaffAllocation',
            fieldLabel: getExaminationTranslation('ADMINISTRATIVE_BY'),
            store: Ext.create('Academia.store.examinationcenters.assessmentEvent.AdministrativeByStore'),
            valueField: 'value',
            displayField: 'value',
            forceSelection: true,
            allowBlank: false
        }, {
            xtype: 'customcombobox',
            name: 'academicTermId',
            itemId: 'downloadPreExamDetailAcademicTermId',
            fieldLabel: getCommonTranslation('ACADEMIC_TERM'),
            store: Ext.create('Academia.store.common.AcademicTermStore'),
            valueField: 'id',
            displayField: 'value',
            forceSelection: true,
            typeAhead: true,
    		editable: false,
            allowBlank: false
        }, {
            xtype: 'multiselectcombofield',
            name: 'schemeId',
            itemId: 'downloadPreExamDetailAssesmentSchemeId',
            store: Ext.create('Academia.store.examinationcenters.assessmentEvent.EvaluationPlanSmartSearchStore'),
            fieldLabel: getExaminationTranslation('EVALUATION_PLAN'),
            valueField: 'id',
            width: 226,
            displayField: 'evaluationPlanNumber',
            disabled: true,
            allowBlank: false,
            triggerCls: Ext.baseCSSPrefix + 'form-search-trigger',
            forceSelection: true,
    		cls: 'commonAutoHeightMultiselectField resetPasswordMultiselect',
            autoloadStore: false,
            listConfig: {
                listeners: {
                    beforeshow: function (picker) {
                        picker.minWidth = picker.up('combobox').getSize().width;
                        picker.maxWidth = picker.up('combobox').getSize().width;
                    }
                },
                loadingText: getCommonTranslation('SEARCHING'),
                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                getInnerTpl: function () {
                    return '<div class="search-item">' +
                        '{value}' +
                        '</div>';
                }
            }
        }]
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        hidden: true,
        disabled: true,
        itemId: 'container2',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
        	xtype: 'multiselectcombofield',
            name: 'courseId',
            itemId: 'downloadPreExamDetailCourseItemId',
            labelAlign: 'top',
            fieldLabel: getExaminationTranslation('COURSE_CODE_NAME'),
            store: Ext.create('Academia.store.examinationcenters.preExamDetails.CoursesStore'),
            valueField: 'id',
            displayField: 'displayValue',
            queryParam: 'courseName',
            autoloadStore: false,
            disabled: true,
            typeAhead: false,
            forceSelection: true,
            matchFieldWidth: true,
            submitValue: false,
            autoloadStore: false,
            cls: 'commonAutoHeightMultiselectField resetPasswordMultiselect',
            triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
            listConfig: {
                listeners: {
                    beforeshow: function (picker) {
                        picker.minWidth = picker.up('combobox').getSize().width;
                        picker.maxWidth = picker.up('combobox').getSize().width;
                    }
                },
                loadingText: getCommonTranslation('SEARCHING'),
                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                getInnerTpl: function () {
                    return '<div class="search-item">' +
                        '{code}' +
                        '</div>';
                }
            }
        }, {
            xtype: 'datefield',
            name: 'fromdate',
            itemId: 'fromDateDownloadPreExam',
            disabled: true,
            listeners: {
                render: function (field) {
                    return dateFormatRender(field);
                }
            },
            vtype: 'daterange',
            endDateField: 'tillDateDownloadPreExam',
            editable: false,
            fieldLabel: getExaminationTranslation('FROM_DATE')
        }, {
            xtype: 'datefield',
            name: 'tilldate',
            itemId: 'tillDateDownloadPreExam',
            disabled: true,
            vtype: 'daterange',
            startDateField: 'fromDateDownloadPreExam',
            editable: false,
            listeners: {
                render: function (field) {
                    return dateFormatRender(field);
                }
            },
            fieldLabel: getExaminationTranslation('TILL_DATE')
        }]
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        hidden: true,
        disabled: true,
        itemId: 'container3',
        defaults: {
            width: 226,
            labelAlign: 'top'
        },
        items: [/*{
            xtype: 'groupingcombobox',
            name: 'assessmentSchemeLevelId',
            itemId: 'downloadPreExamDetailEvaluationLevelNameId',
            labelAlign: 'top',
            groupField: 'code',
            groupDisplayField: 'code',
            valueField: 'levelId',
            store: Ext.create('Academia.store.examinationcenters.preExamDetails.EvalPlanLevels'),
            fieldLabel: getExaminationTranslation('EVALUATION_PLAN_LEVEL'),
            displayField: 'value',
            disabled: true,
            forceSelection: true,
    		editable: false
        }, */{
        	xtype: 'multiselectcombofield',
            name: 'detailSequence',
            itemId: 'downloadPreExamDetailDetailSequenceItemId',
            disabled: true,
            cls: 'receiptHeaderMultiselect resetPasswordMultiselect',
            displayField: 'eventName',
            valueField: 'eventId',
            forceSelection: true,
            store: Ext.create('Academia.store.examinationcenters.preExamDetails.EventsStore', {
            	autoloadStore: false
            }),
            queryMode: 'local',
            fieldLabel: getExaminationTranslation('DETAILED_SEQUENCE'),
            disabled: true,
            submitValue: false,
            autoloadStore: false,
            allowBlank: false,
            listConfig: {
                listeners: {
                    beforeshow: function (picker) {
                        picker.minWidth = picker.up('combobox').getSize().width;
                        picker.maxWidth = picker.up('combobox').getSize().width;
                    }
                },
                loadingText: getCommonTranslation('SEARCHING'),
                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                getInnerTpl: function () {
                    return '<div class="search-item">' +
                        '{value}' +
                        '</div>';
                }
            }
        }]
    }, {
        xtype: 'fieldcontainer',
        width: '100%',
        cls: 'windowBtnPos',
        items: [{
            xtype: 'button',
            itemId: 'preExamDetailDownload',
            disabled: true,
            text: getExaminationTranslation('MARK_ENTRY_DOWNLOAD'),
            ui: 'CustomBtnSubmit',
            formBind: true
        }, {
            xtype: 'button',
            text: getCommonTranslation('RESET'),
            ui: 'CustomBtnCancel',
            itemId: 'resetBtn',
            scale: CONSTANTS.BUTTONSIZE
        }]
    }]
});