/**
 * @author bhanu ps
 */
Ext.define('Academia.view.examinationcenters.assessmentEvent.EligibleStudentGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.eligiblestudentgrid',
	store: 'examinationcenters.assessmentEvent.EligibleStudentGridStore',
	title:  getExaminationTranslation('ELIGIBLE_STUDENT'),
	header:{
		layout:
	    {
	        type: 'hbox',
	        pack: 'end'
	    },
	    titlePosition: 0,
		items:[
			{
	        	xtype: 'textfield',
	        	fieldLabel: getProgramandcourseTranslation('TOTAL_NO_STUDENT'),
	        	cls: 'headerTextField',
	        	itemId: 'studentCountField',
	        	labelWidth: 180,
	        	readOnly: true
	        }
		]
	},
	border: true,
	autoScroll: false,
	frame:false,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	selType:'checkboxmodel',
	selModel: {
		mode:'MULTI',
		showHeaderCheckbox: true,
		allowDeselect: false,
		checkOnly : false
	},
	dockedItems: [{
		xtype : 'toolbar',
		dock : 'bottom',
//		hidden:true,
		items : [{
			xtype : 'custompagingtoolbar',
			plugins:['pagesize'],
			store: 'examinationcenters.assessmentEvent.EligibleStudentGridStore',
			emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);     
	},
	tbar: [{
    	xtype: 'button',
        text: getExaminationTranslation('SAVE_MAPPED_STUDENT'),
        itemId: 'btnMapStudents',
        scale: CONSTANTS.BUTTONSIZE
    }],
	columns: [{
		header: getExaminationTranslation('SECTION'),
		dataIndex: 'sectionName',
		flex:.3,
		sortable: true
	},{
		header: getCommonTranslation('STUDENT_CODE'),
		dataIndex: 'studentCode',
		flex:.3,
		sortable: true
	},{
		header: getExaminationTranslation('ADMISSION_ID'),
		dataIndex: 'admissionCode',
		flex:.4,
		sortable:true
	},{
		header: getExaminationTranslation('STUDENT_NAME'),
		dataIndex: 'studentName',
		flex:.3,
		sortable: true
	},{
		header: getExaminationTranslation('COURSE'),
		dataIndex: 'courseName',
		flex:.3,
		sortable: true
	}/*,{
		header: getExaminationTranslation('COURSE_VARIANT'),
		dataIndex: 'courseVariantName',
		flex:.3,
		sortable: true
	},*//*,{
		header: getExaminationTranslation('BATCH'),
		dataIndex: 'batchName',
		flex:.3,
		sortable: true
	},{
		header: getExaminationTranslation('PERIOD'),
		dataIndex: 'periodName',
		flex:.3,
		sortable: true
	}*/]
});
