/**
 * @author Rohit Sharma
 */
Ext.define('Academia.view.examinationcenters.assessmentEvent.ExamConcessionStaffAllocationFilter', {
    extend: 'Academia.view.common.DynamicFieldForm',
    alias: 'widget.examConcessionStaffAllocationFilter',
    autoScroll: true,
    frame: false,
    cls: 'customSearchPanel',
    layout: 'vbox',
    method: 'POST',
    standardSubmit: false,
    plugins: "formlabelrequired",
    items: [{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            width: 226,
            labelAlign: 'top'
        },
        items: [{
            xtype: 'customcombobox',
            name: 'administrativeBy',
            itemId: 'administrativeByExamConcessionStaffAllocation',
            fieldLabel: getExaminationTranslation('ADMINISTRATIVE_BY'),
            store: Ext.create('Academia.store.examinationcenters.assessmentEvent.AdministrativeByStore'),
            valueField: 'value',
            displayField: 'value',
            forceSelection: true,
            allowBlank: false
        }]
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            width: 226,
            labelAlign: 'top'
        },
        items: [{
            xtype: 'customcombobox',
            name: 'assessmentSchemeAcademicTerm',
            itemId: 'assessmentSchemeAcademicTermExamConcessionStaffAllocation',
            fieldLabel: getCommonTranslation('ACADEMIC_TERM'),
            store: Ext.create('Academia.store.common.AcademicTermStore'),
            valueField: 'id',
            displayField: 'value',
            forceSelection: true,
            typeAhead: true,
            allowBlank: false,
            disabled: true
        }, {
            xtype: 'multiselectcombofield',
            name: 'assesmentScheme',
            itemId: 'assesmentSchemeIdExamConcessionStaffAllocation',
            store: Ext.create('Academia.store.examinationcenters.assessmentEvent.EvaluationPlanSmartSearchStore'),
            fieldLabel: getExaminationTranslation('EVALUATION_PLAN'),
            valueField: 'id',
            width: 226,
            displayField: 'evaluationPlanNumber',
            //minChars: 3,
            //queryParam: 'qry',
            typeAhead: false,
            disabled: true,
            allowBlank: false,
            cls: 'commonAutoHeightMultiselectField resetPasswordMultiselect',
            triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
            enableKeyEvents: 'true',
            hideTrigger: false,
            forceSelection: true,
            //emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            listConfig: {
                listeners: {
                    beforeshow: function (picker) {
                        picker.minWidth = picker.up('combobox').getSize().width;
                        picker.maxWidth = picker.up('combobox').getSize().width;
                    }
                },
                loadingText: getCommonTranslation('SEARCHING'),
                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                getInnerTpl: function () {
                    return '<div class="search-item">' +
                        '{value}' +
                        '</div>';
                }
            }
        }, {
        	xtype: 'multiselectcombofield',
            name: 'courseManageItem',
            itemId: 'courseManageItemIdExamConcessionStaffAllocation',
            labelAlign: 'top',
            fieldLabel: getExaminationTranslation('COURSE_CODE_NAME'),
            store: Ext.create('Academia.store.examinationcenters.assessmentEvent.AssessmentCoursesForRoomAllocationStore'),
            valueField: 'id',
            displayField: 'valueCode',
            autoloadStore: false,
            disabled: true,
            typeAhead: false,
            forceSelection: true,
            matchFieldWidth: true,
            width: 226,
            cls: 'commonAutoHeightMultiselectField resetPasswordMultiselect',
            triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
            listConfig: {
                listeners: {
                    beforeshow: function (picker) {
                        picker.minWidth = picker.up('combobox').getSize().width;
                        picker.maxWidth = picker.up('combobox').getSize().width;
                    }
                },
                loadingText: getCommonTranslation('SEARCHING'),
                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                getInnerTpl: function () {
                    return '<div class="search-item">' +
                        '{code}' +
                        '</div>';
                }
            }
        }]
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            width: 226,
            labelAlign: 'top'
        },
        items: [{
            xtype: 'datefield',
            name: 'fromdate',
            itemId: 'fromdateExamConcessionStaffAllocation',
            allowBlank: true,
            disabled: true,
            listeners: {
                render: function (field) {
                    return dateFormatRender(field);
                }
            },
            vtype: 'daterange',
            endDateField: 'tilldateExamConcessionStaffAllocation',
            editable: false,
            fieldLabel: getExaminationTranslation('FROM_DATE')
        }, {
            xtype: 'datefield',
            name: 'tilldate',
            itemId: 'tilldateExamConcessionStaffAllocation',
            disabled: true,
            allowBlank: true,
            vtype: 'daterange',
            startDateField: 'fromdateExamConcessionStaffAllocation',
            editable: false,
            listeners: {
                render: function (field) {
                    return dateFormatRender(field);
                }
            },
            fieldLabel: getExaminationTranslation('TILL_DATE')
        }, /*{
            xtype: 'groupingcombobox',
            name: 'evaluationLevelName',
            itemId: 'evaluationLevelNameExamConcessionStaffAllocation',
            labelAlign: 'top',
            groupField: 'code',
            groupDisplayField: 'code',
            store: Ext.create('Academia.store.examinationcenters.preExamDetails.EvalPlanLevels'),
            fieldLabel: getExaminationTranslation('EVALUATION_PLAN_LEVEL'),
            displayField: 'value',
            disabled: true,
            forceSelection: true
        }*/{
        	xtype: 'multiselectcombofield',
            name: 'detailSequence',
            itemId: 'detailSequenceItemIdExamConcessionStaffAllocation',
            disabled: true,
            cls: 'receiptHeaderMultiselect resetPasswordMultiselect',
            displayField: 'eventName',
            valueField: 'id',
            forceSelection: true,
            store: Ext.create('Academia.store.examinationcenters.assessmentEvent.EvalPlanLevelRoomAllocationStore'),
            fieldLabel: getExaminationTranslation('DETAILED_SEQUENCE'),
            disabled: true,
            allowBlank: false,
            listConfig: {
                listeners: {
                    beforeshow: function (picker) {
                        picker.minWidth = picker.up('combobox').getSize().width;
                        picker.maxWidth = picker.up('combobox').getSize().width;
                    }
                },
                loadingText: getCommonTranslation('SEARCHING'),
                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                getInnerTpl: function () {
                    return '<div class="search-item">' +
                        '{value}' +
                        '</div>';
                }
            }
        }]
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            width: 226,
            labelAlign: 'top'
        },
        items: [{
            xtype: 'customcombobox',
            name: 'requestCategory',
            itemId: 'requestCategoryExamConcessionStaffAllocation',
            store: Ext.create('Ext.data.Store', {
            	fields: ['name', 'value'],
            	data: [{
            		name: 'Exam Consession',
            		value: 'Exam Consession'
            	}]
            }),
            fieldLabel: getCommonTranslation('REQUEST_CATEGORY'),
            valueField: 'value',
            width: 226,
            displayField: 'name',
            typeAhead: false,
            disabled: true,
            triggerCls: Ext.baseCSSPrefix + 'x-form-trigger',
            enableKeyEvents: 'true',
            hideTrigger: false,
            forceSelection: true,
            //value: 'Exam Consession',
            listConfig: {
                listeners: {
                    beforeshow: function (picker) {
                        picker.minWidth = picker.up('combobox').getSize().width;
                        picker.maxWidth = picker.up('combobox').getSize().width;
                    }
                },
                loadingText: getCommonTranslation('SEARCHING'),
                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                getInnerTpl: function () {
                    return '<div class="search-item">' +
                        '{value}' +
                        '</div>';
                }
            }
        }, {
            xtype: 'customcombobox',
            name: 'requestType',
            itemId: 'requestTypeExamConcessionStaffAllocation',
            store: 'exam.examConcessionStaffAllocation.RequestTypeStore',
            fieldLabel: getCommonTranslation('REQUEST_TYPE'),
            valueField: 'secondId',
            width: 226,
            displayField: 'display',
            minChars: 3,
            queryParam: 'qry',
            typeAhead: false,
            disabled: true,
            triggerCls: Ext.baseCSSPrefix + 'x-form-trigger',
            enableKeyEvents: 'true',
            hideTrigger: false,
            forceSelection: true,
            //emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            listConfig: {
                listeners: {
                    beforeshow: function (picker) {
                        picker.minWidth = picker.up('combobox').getSize().width;
                        picker.maxWidth = picker.up('combobox').getSize().width;
                    }
                },
                loadingText: getCommonTranslation('SEARCHING'),
                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                getInnerTpl: function () {
                    return '<div class="search-item">' +
                        '{display}' +
                        '</div>';
                }
            }
        }]
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            width: 226,
            labelAlign: 'top'
        },
        items: [{
            xtype: 'customcombobox',
            name: 'externalRef',
            itemId: 'externalRef',
            store: 'exam.examConcessionStaffAllocation.StudentStore',
            fieldLabel: getExaminationTranslation('EXTERNAL_REF1_SU_NO'),
            valueField: 'id',
            width: 460,
            displayField: 'display',
            minChars: 3,
            queryParam: 'qry',
            typeAhead: false,
            disabled: true,
            triggerCls: Ext.baseCSSPrefix + 'x-form-trigger',
            enableKeyEvents: 'true',
            hideTrigger: false,
            forceSelection: true,
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            listConfig: {
                listeners: {
                    beforeshow: function (picker) {
                        picker.minWidth = picker.up('combobox').getSize().width;
                        picker.maxWidth = picker.up('combobox').getSize().width;
                    }
                },
                loadingText: getCommonTranslation('SEARCHING'),
                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                getInnerTpl: function () {
                    return '<div class="search-item">' +
                        '{value}' +
                        '</div>';
                }
            }
        }]
    }, {
        xtype: 'fieldcontainer',
        width: 'auto',
        items: [{
            xtype: 'button',
            text: getCommonTranslation('SEARCH'),
            itemId: 'searchBtnId',
            buttonAlign: 'left',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind: true
        }, {
            xtype: 'button',
            itemId: 'resetBtn',
            text: getCommonTranslation('RESET'),
            ui: 'CustomBtnCancel',
            scale: CONSTANTS.BUTTONSIZE
        }]
    }]
});