var calculateAverageLevelWiseStore = Ext.create('Academia.store.examinationcenters.calculateAverage.calculateAverageLevelWise.CalculateAverageLevelWiseGridStore');
Ext.define('Academia.view.examinationcenters.calculateAverage.CalculateAverageLevelWiseGrid', {
    extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.calculateAverageLevelWiseGrid',
    store: calculateAverageLevelWiseStore,
    border: true,
    frame: false,
    selType: 'checkboxmodel',
    title: getExaminationTranslation('LIST_OF_STUDENTS'),
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
    selModel: {
        showHeaderCheckbox: true,
        checkOnly: true,
        allowDeselect: false
    },
    isGridConfigurable: true,
    enableColumnHide: false,
    initComponent: function () {
        var grid = this;
        grid.addExportToolBarItems(grid);
        this.callParent(arguments);
    },
    dockedItems: [{
        xtype: 'toolbar',
        dock: 'bottom',
        items: [{
            xtype: 'custompagingtoolbar',
            plugins: ['pagesize'],
            store: calculateAverageLevelWiseStore,
            emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
            displayInfo: true
        }]
    }],
    tbar: [{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        width: 'auto',
        cls: 'windowBtnPos',
        defaults: {
            labelAlign: 'top'
        },
        items: [{
            xtype: 'button',
            text: getExaminationTranslation('CALCULATE_AVERAGE'),
            itemId: 'caclulateAverageLevelWiseBtnId',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            tooltip: getExaminationTranslation('CALCULATE_AVERAGE'),
            disabled: true
        }, {
            xtype: 'button',
            text: getExaminationTranslation('DELETE'),
            itemId: 'deleteLevelWiseBtnId',
            ui: 'CustomBtnCancel',
            scale: CONSTANTS.BUTTONSIZE,
            tooltip: getExaminationTranslation('DELETE'),
            disabled: true
        }]
    }],
    columns: [{
        header: getCommonTranslation('ADMISSION_ID'),
        dataIndex: 'admissionCode',
        flex: .4,
        sortable: true
    }, {
        header: getCommonTranslation('STUDENT_ID'),
        dataIndex: 'studentCode',
        flex: .4,
        sortable: true
    }, {
        header: getCommonTranslation('STUDENT_NAME'),
        dataIndex: 'studentName',
        flex: .3,
        sortable: true
    }, {
        header: getExaminationTranslation('PROGRAM'),
        dataIndex: 'programName',
        flex: .4,
        sortable: true
    }, {
        header: getExaminationTranslation('BATCH'),
        dataIndex: 'batchName',
        flex: .4,
        sortable: true
    }, {
        header: getCommonTranslation('LEVEL_NAME'),
        dataIndex: 'assessmentSchemeLevel',
        flex: .3,
        sortable: true,
        renderer: function(val) {
        	return getCommonTranslation(val);
        }
    }, {
        header: getCommonTranslation('AVERAGE'),
        dataIndex: 'isAvgCalculated',
        flex: .3,
        sortable: true,
        renderer: function(val) {
        	if(!isNullOrEmpty(val) && val) {
        		return '<a href=#>VIEW</a>';
        	}
        	return '';
        }
    }]
});