/**
 * @author Abhishek Chouhan
 */
Ext.define('Academia.view.examinationcenters.calculateAverage.ExamResultDeletionFilter', {
	extend : 'Ext.form.FormPanel',
	alias: 'widget.examresultdeletionfilter',
	autoScroll: true,
	frame: false,
	cls:'customSearchPanel',
	layout: 'vbox',
	method: 'POST',
	standardSubmit: false,
	plugins:"formlabelrequired",
	items:[{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				labelAlign: 'top'
			},
			items: [{
				xtype: 'customcombobox',
				width: 460,
				name: 'multiselectAcademyLocation',
				itemId: 'multiselectAcademyLocationId',
				fieldLabel : getProgramandcourseTranslation('ACADEMY_LOCATION'),
				store:'user.UserAcademyLocationStore',
				displayField:'value',
				valueField:'id',
				autoloadStore: false,
				allowBlank:false,
				queryParam:'qry',
				minChars:3,
				typeAhead:false,
				triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
				enableKeyEvents  : 'true',
				hideTrigger:false,
				forceSelection:true,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{code}' +
						'</div>';
					}
				}
			}]
		},{
		xtype:'fieldcontainer',
		width:'100%',
		layout:'hbox',
		defaults:{
			labelAlign:'top',
			width:226
		},
		items:[{
			xtype: 'customcombobox',
			name: 'evaluationplan',
			itemId: 'evaluationplanId',
			store:'examinationcenters.reports.ExaminationPlanStore',
			fieldLabel:getExaminationTranslation('EVALUATION_PLAN'),
			valueField: 'id',
			displayField: 'valueCode',
			queryParam:'name',
			minChars:3,
			width:226,
			allowBlank:false,
			typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{valueCode}' +
					'</div>';
				}
			}
		},{
    		xtype: 'customcombobox',
    		name: 'evaluationLevel',
    		itemId: 'evaluationLevelItemId',
    	    store:'examinationcenters.marksheet.EventEvaluationLevelType',
    		displayField:'value',
    		valueField:'id',
    		forceSelection:true,
    		typeAhead:true,
    		minChars:3,
    		disabled:true,
    		fieldLabel:getExaminationTranslation('EVALUATION_PLAN_LEVEL'),
    	},{
    		xtype: 'customcombobox',
    		name: 'evaluationOtherLevel',
    		itemId: 'evaluationOtherLevelItemId',
    	    store:'examinationcenters.marksheet.AssessmentOtherLevelStore',
    		displayField:'value',
    		valueField:'id',
    		forceSelection:true,
    		typeAhead:true,
    		minChars:3,
    		disabled:true,
    		hidden:true,
    		fieldLabel:getExaminationTranslation('EVALUATION_PLAN_LEVEL'),
    	},{
       		xtype: 'customcombobox',
       		name: 'evaluationLevelName',
       		itemId: 'evaluationLevelNameId',
       		store:'examinationcenters.calculateAverage.CalculateAverageEvalLevelTypeStore',
       		fieldLabel : getExaminationTranslation('EVALUATION_LEVEL_NAME'),
       		displayField:'value',
       		valueField:'id',
       		disabled:true,
       		forceSelection:true,
    		typeAhead:true,
       	}]
	},{
		xtype:'fieldcontainer',
		width:'100%',
		layout:'hbox',
		itemId:'academicCourseFieldContainer',
		defaults:{
			labelAlign:'top',
			width:226
		},
		items:[{
			xtype: 'customcombobox',
			name:'course',
			itemId:'courseItemId',
			store: 'examinationcenters.reports.ExaminationReportCourseStore',
			fieldLabel: getCommonTranslation('COURSE_CODE_NAME'),
			valueField: 'id',
			displayField: 'value',
			queryParam:'name',
			minChars:3,
			disabled:true,
			typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			width:226,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		},{
        	xtype: 'customcombobox',
            name: 'courseVariant',
            itemId:'courseVariantItemId',
            store:'attendance.VariantMappedToSpecialGrade',
            displayField:'value',
            valueField:'id',
            width:226,
            maxLength:9999,
  			maxSelections :9999,
            forceSelection:true,
            disabled:true,
            typeAhead:true,
            fieldLabel:getExaminationTranslation('COURSE_VARIANT'),
            disabled:true,
        	listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
        	}
		},{
			xtype: 'customcombobox',
			name: 'studentId',
			itemId: 'studentItemId',
			store:'examinationcenters.reports.ExaminationReportStudentStore',
			fieldLabel:getExaminationTranslation('STUDENTID_STUDENTNAME'),
			valueField: 'id',
			displayField: 'valueCode',
			queryParam:'name',
			minChars:3,
			width:226,
			typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			disabled:true,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{valueCode}' +
					'</div>';
				}
			}
		}]
	},{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		itemId:'otherProgramBatchPeriodContainer',
		hidden:true,
		defaults: {
			width: 226,
			labelAlign: 'top'
		},
		style:{
    		marginTop:'-2px !important',
    	},
		items: [{
			xtype: 'customcombobox',
			name:'otherProgram',
			itemId:'otherProgramItemId',
			store:'examinationcenters.reports.ExaminationReportProgramStore',
			fieldLabel:getExaminationTranslation('PROGRAM'),
			valueField: 'id',
			displayField: 'value',
			queryParam:'name',
			minChars:3,
			width:226,
			typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			disabled:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		},{
			xtype: 'customcombobox',
			name:'otherBatch',
			itemId:'otherBatchItemId',
			store:'examinationcenters.reports.SpecialGradeBatchStore',
			fieldLabel:getExaminationTranslation('BATCH'),
			valueField: 'id',
			displayField: 'value',
			queryParam:'name',
			minChars:3,
			width:226,
			disabled:true,
			typeAhead:false,
			forceSelection:true,
			
		},{
			xtype: 'customcombobox',
			name: 'otherPeriod',
			itemId: 'otherPeriodItemId',
			store:'examinationcenters.reports.SpecialGradePeriodStore',
			fieldLabel:getExaminationTranslation('PERIOD'),
			valueField: 'id',
			displayField: 'value',
			disabled:true,
			queryParam:'name',
			minChars:3,
			width:226,
			typeAhead:false,
			forceSelection:true,
		}]
	},{
			xtype:'fieldset',
			title: getTransportTranslation('MORE_FILTERS'),
			layout:'vbox',
			frame:true,	
			collapsible:true,
			collapsed:true,
			style:{marginTop: '33px!important',paddingTop:'25px!important'},
			width:'100%',
			itemId:'moreFilterId',
			items: [{
				xtype: 'fieldcontainer',
				layout: 'hbox',
				defaults: {
					width: 226,
					labelAlign: 'top'
				},
				items: [{	
					xtype:'fieldcontainer',
					width: '100%',
					layout : 'hbox',
					itemId:'academicProgramFieldContainer',
					defaults: {
						labelAlign:'top',
						width:226
				},items:[{
					xtype: 'customcombobox',
					name:'program',
					itemId:'programItemId',
					store:'examinationcenters.reports.ExaminationReportProgramStore',
					fieldLabel:getCommonTranslation('PROGRAM_CODE_OR_NAME'),
					valueField: 'id',
					displayField: 'valueCode',
					queryParam:'name',
					minChars:3,
					width:226,
					typeAhead:false,
					triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
					enableKeyEvents  : 'true',
					hideTrigger:false,
					forceSelection:true,
					disabled:true,
					emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
					listConfig: {
						listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
						loadingText: getCommonTranslation('SEARCHING'),
						emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
						getInnerTpl: function() {
							return '<div class="search-item">' +
							'{value}' +
							'</div>';
						}
					}
				},{
					xtype: 'customcombobox',
					name:'batch',
					itemId:'batchItemId',
					store:'examinationcenters.reports.ExaminationReportBatchStore',
					fieldLabel:getExaminationTranslation('BATCH'),
					valueField: 'id',
					displayField: 'value',
					queryParam:'name',
					minChars:3,
					width:226,
					disabled:true,
					typeAhead:false,
					hideTrigger:false,
					forceSelection:true,
				},{
    				xtype: 'customcombobox',
    				name: 'period',
    				itemId: 'periodItemId',
    				store:'examinationcenters.reports.ExaminationReportPeriodStore',
    				fieldLabel:getExaminationTranslation('PERIOD'),
    				valueField: 'id',
    				displayField: 'value',
    				disabled:true,
    				minChars:3,
    				width:226,
    				typeAhead:false,
    				forceSelection:true,
    				
    			}]},{
					xtype:'fieldcontainer',
					width: '100%',
					layout : 'hbox',
					itemId:'otherStudentFieldContainer',
					hidden:true,
					defaults: {
						labelAlign:'top',
						width:226
				},items:[{
					xtype: 'customcombobox',
    				name: 'otherStudentId',
    				itemId: 'otherStudentItemId',
    				store:'examinationcenters.reports.PeriodWiseExamLevelReportStudentStore',
    				fieldLabel:getExaminationTranslation('STUDENTID_STUDENTNAME'),
    				valueField: 'id',
    				displayField: 'value',
    				queryParam:'name',
    				minChars:3,
    				width:226,
    				typeAhead:false,
    				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
    				enableKeyEvents  : 'true',
    				hideTrigger:false,
    				forceSelection:true,
    				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
    				listConfig: {
    					listeners: {
    						beforeshow: function(picker) {
    							picker.minWidth = picker.up('combobox').getSize().width;
    						}
    					},
    					loadingText: getCommonTranslation('SEARCHING'),
    					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    					getInnerTpl: function() {
    						return '<div class="search-item">' +
    						'{valueCode}' +
    						'</div>';
    					}
    				}}]
    			}]
			}],listeners:{
				render: function(myfieldset){
					myfieldset.setMargin('-10px');
				}
			}
		},
		{	
			xtype:'fieldcontainer',
			width: '100%',
			layout : 'hbox',
			defaults: {
			labelAlign:'top',
			width:226
		},
		items:[{
		xtype : 'fieldcontainer',
		width : 'auto',
		cls : 'windowBtnPos',
		items: [{
			xtype: 'button',
			text: getCommonTranslation('SEARCH'),
			itemId: 'searchBtn',
			buttonAlign: 'left',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE,
			formBind : true
		},{
			xtype: 'button',
			text: getCommonTranslation('RESET'),
			itemId: 'resetBtn',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE   
		}]	
	}]
}]});
