/**
 * @author sumit.meena
 */
Ext.define('Academia.view.examinationcenters.evaluationresult.EvaluationResultStudentGrid',{
	//extend:'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias:'widget.evaluationresultstudentgrid',
	title: getCommonTranslation('SEARCHRESULTSGRIDHEADER'),
	border: true,
	store:'examinationcenters.evaluationresult.EvaluationResultStudent',
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
		        xtype: 'custompagingtoolbar',
	            plugins:['pagesize'],
	            store : 'examinationcenters.evaluationresult.EvaluationResultStudent',
			    emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			    displayInfo : true
		}]
	}],
	   initComponent: function() {
	        var grid=this;                   
	        grid.addExportToolBarItems(grid);
	        this.callParent(arguments);     
	 },
    columns:[{
	  	header : getExaminationTranslation('COURSE'),
	  	dataIndex : 'courseName',	  	
	  	flex:1
   },{
	  	header : getExaminationTranslation('VARIANT'),
	  	dataIndex : 'courseVariantName',
		hidden:true,
	  	flex:1
   },{
	  	header : getExaminationTranslation('EVENT'),
	  	dataIndex : 'event',
	  	hidden:true,
	  	flex:1
   },{
	  	header : getExaminationTranslation('MARK_GRADE'),
	  	dataIndex : 'grade',
	  	flex:1,
	  	renderer:function(value,r,rec){
	  		if(rec.data.status=="Hold Applied"){
	  			return getCommonTranslation('HOLD_APPLIED');
	  		} else if(rec.data.status=="ABSENT"){
	  			return "Absent";
	  		} else{
	  			if(!isNullOrEmpty(rec.data.obtainedMarks)){
	  				return rec.data.obtainedMarks;
	  			}else if(!isNullOrEmpty(rec.data.grade)){
	  				return rec.data.grade;	  			
	  			}
	  		}
	  	}
   },/*{
	  	header : getExaminationTranslation('RANK'),
	  	dataIndex : 'courseRank',
		hidden:true,
	  	flex:1                     ///V2D-472590
   },*/{
	  	header : getExaminationTranslation('STATUS'),
	  	dataIndex : 'status',
	  	flex:1,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) {
				if(value=="Hold Applied"){
		  			return "";
		  		}
				return getExaminationTranslation(value);
			}
			else
				return ''
		}
   },{
	  	header : getExaminationTranslation('REMARK'),
	  	dataIndex : 'eventRemark',
	  	flex:1
   }]
});


