/**
 * Santosh Sahu
 */
Ext.define('Academia.view.examinationcenters.examSpecialGrade.MangeSpecialGradeGrid', {
    //extend: 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.mangespecialgradegrid',
    store: 'examinationcenters.reports.SpecialGradeListStore',
    border: true,
    frame:false,
    selType:'checkboxmodel',
    title:getExaminationTranslation('SPECIAL_GRADE_LIST'),
	 headerFix:{
        headerFix: true,
        portalIdsWithStructure: {   
            'managespecialgradesearch':1
        }
    },
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
    selModel: {
		 showHeaderCheckbox: true,
	     checkOnly : true, //I have option checkOnly: true that mean rows can only be selected by clicking on the checkbox column.
	     allowDeselect: false,
	     //injectCheckbox:1
   },
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
		        xtype: 'custompagingtoolbar',
		        itemId:'managePaggingToolBarItemId',
	            plugins:['pagesize'],
			    store : 'examinationcenters.reports.SpecialGradeListStore',
			    emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			    displayInfo : true
		}]
	}
	],
	initComponent: function() {
        var grid=this;                   
        grid.addExportToolBarItems(grid);
        this.callParent(arguments);     
 },
 tbar: [{
     xtype: 'button',
     itemId: 'btnDelete',
     cls: 'CustomToolbarBtnReject',
     tooltip: getCommonTranslation('DELETE'),
     glyph: ICONGLYPH.DELETEGLYPH,
     disabled:true
  },{	
	 
		 xtype: 'button',
		 text:getExaminationTranslation('GRADE_SUBMISSION'),
		 itemId:'btnCalculateMarksheet',
		 scale: CONSTANTS.BUTTONSIZE,
		 tooltip: getExaminationTranslation('GRADE_SUBMISSION'),
	
 	}],
    columns: [{
        header: getExaminationTranslation('ADMISSION_ID'),
        dataIndex: 'admissionCode',
        flex:.4,
        sortable:true
    },{
        header: getExaminationTranslation('STUDENT_ID'),
        dataIndex: 'studentCode',
        flex:.4,
        sortable:true
    },{
        header: getExaminationTranslation('STUDENT_NAME'),
        dataIndex: 'studentName',
        flex:.3,
        sortable: true
    }, {
        header: getExaminationTranslation('PROGRAM'),
        dataIndex: 'programName',
        flex:.3,
        sortable: true
    }, {
        header: getExaminationTranslation('BATCH'),
        dataIndex: 'batchName',
        flex:.3,
        sortable: true
    },
    {
        header: getExaminationTranslation('PERIOD'),
        dataIndex: 'periodName',
        flex:.3,
        sortable: true
    }, {
        header: getExaminationTranslation('COURSE'),
        dataIndex: 'courseName',
        flex:.3,
        sortable: true,
        hidden: true
    },{
        header: getExaminationTranslation('COURSE_VARIANT'),
        dataIndex: 'courseVariantName',
        flex:.3,
        sortable: true,
        hidden: true
    },{
		header : getExaminationTranslation('SPECIAL_GRADE'),
		dataIndex : 'specialGrade',
		flex : .3,
		editor : {
			xtype: 'customcombobox',
			name:'specialGradeId',
			itemId:'specialGradeItemId',
			store:'examinationcenters.evaluation.evaluationPlanHeirarchy.EvaluationFormOneGrades',
			valueField : 'id',
			//forceSelection:true,
            editable:false,
            typeAhead:false,
			displayField : 'gradeName',
			listConfig: { 
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				}
			}
		},
		listeners:{
			click: function(){
				if(Ext.ComponentQuery.query('#specialGradeItemId')[0])
					Ext.ComponentQuery.query('#specialGradeItemId')[0].setValue();
			}
		},
		renderer:function(val,rec,record,rowIndex,colIndex,store,view){
			
			if((val=='' || val== undefined || isNullOrEmpty(val))){
				var specialGrade = record.data.specialGrade;
				if(specialGrade !='' && !isNullOrEmpty(specialGrade)){
					return specialGrade;
				} else {
					rec.tdCls = 'gridInputCustomStyle';
					return getExaminationTranslation('CLICK_TO_ENTER');
				}
			} else if(val!='' && val!= undefined){
					var grid = view.up();
					if(grid.getMlpData){
						var ddlRecord = grid.getMlpData();
						for (var i in ddlRecord) {
							if(val == ddlRecord[i].data.gradeName || val == ddlRecord[i].data.id) {
								var models = view.getStore().getRange();
								models[rowIndex].set("specialGrade",ddlRecord[i].data.gradeName);
								models[rowIndex].set("specialGradeCode",ddlRecord[i].data.studentCode);
								models[rowIndex].set("specialGradePoint",ddlRecord[i].data.gradePoint);	
								models[rowIndex].set("resultStatus",ddlRecord[i].data.resultStatus);	
								return ddlRecord[i].data.gradeName;
							}
						}
						return val;
					}
					else {
						return val;
					}
				} else {
					rec.tdCls = 'gridInputCustomStyle'; 
					return getExaminationTranslation('CLICK_TO_ENTER');
				}	
		}
	}],
	plugins: [{
        ptype : 'cellediting',
        clicksToEdit: 1,
        /*listeners: {
            beforeedit: function(editor , context){
            }
          } */
        }]
 
});
