/**
 * @author Anand Verma
 */
Ext.define('Academia.view.examinationcenters.examstaffallocation.ExamStaffAllocationFilter', {
	extend: 'Ext.form.Panel',
	alias: 'widget.examstaffallocationfilter',
	autoScroll: false,
	frame: false,
	cls:'customSearchPanel',
	bodyStyle:{ margin:CONSTANTS.LEFT_MARGIN_FOR_SEARCH_PANEL} ,
	plugins : "formlabelrequired",
	items: [
	        {
	        	xtype: 'radiogroup',
	        	hidden:true,
	        	itemId:'examstaffallocationTypeItemId',
	        	name:'examstaffallocationName',
	        	items: [{
	        		boxLabel: getExaminationTranslation('PROGRAM_AND_COURSE'),
	        		name: 'examstaffallocationType',
	        		inputValue: true,
	        		checked:true
	        	}, {
	        		boxLabel: getExaminationTranslation('EVALUATION_GROUP'),
	        		name: 'examstaffallocationType',
	        		inputValue: false
	        	}]
	        },{
	        	xtype: 'fieldcontainer',
	        	layout: 'hbox',
	        	defaults: {
	        		width: 226,
	        		labelAlign: 'top'
	        	},
	        	items: [{
        			xtype: 'customcombobox',
        			name: 'role',
        			itemId:'roleItemId',
        			fieldLabel: getExaminationTranslation('ROLE'),
        			store: 'examinationcenters.examstaffallocation.ExaminationRoles',
        			displayField: 'value',
        			valueField: 'id',
        			typeAhead: true,	  
        			allowBlank:false,
        			forceSelection: true
        		},{
        			xtype: 'customcombobox',
        			name: 'evaluationGroupId',
        			itemId:'evaluationGroupItemId',
        			store:'examinationcenters.examstaffallocation.commonFilter.ExamGroupFilter',
        			displayField:'value',
        			valueField:'id',
        			forceSelection:true,
        			typeAhead:true,
        			fieldLabel:getExaminationTranslation('CNTRL_ERL_EVAL_GROUP'),
        			disabled:true
        		},{
	        		xtype: 'customcombobox',
	        		name: 'centerType',
	        		itemId:'centerTypeItemId',
	        		fieldLabel: getExaminationTranslation('CENTER_TYPE'),
	        		store: 'program.programDetails.programBatches.assignExamCenter.ProgramCenterTypeStore',
	        		displayField: 'value',
	        		valueField: 'id',
	        		typeAhead: true,	 
	        		hidden:true,
	        		disabled:true
	        	},{
	        		xtype: 'customcombobox',
	        		name: 'centerName',
	        		itemId: 'centerNameItemId',
	        		fieldLabel: getExaminationTranslation('CENTER_NAME'),
	        		store: 'examinationcenters.examstaffallocation.commonFilter.ExamCenterFilter',
	        		displayField: 'valueCode',
	        		valueField: 'id',
	        		typeAhead: true,
	        		disabled:true,
	        		forceSelection:true
	        	},{
        			xtype: 'customcombobox',
        			name:'programId',
        			itemId:'programIdItemId',
        			store:'examinationcenters.examstaffallocation.commonFilter.ExamProgramFilter',
        			fieldLabel:getCommonTranslation('PROGRAM_CODE_OR_NAME'),
        			valueField: 'id',
        			displayField: 'valueCode',
        			queryParam:'searchText',
        			minChars:3,
        			typeAhead:false,
        			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
        			enableKeyEvents  : 'true',
        			hideTrigger:false,
        			forceSelection:true,
        			disabled:true,
        			hidden:true,
        			width:226,
        			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
        			listConfig: {
        				loadingText: getCommonTranslation('SEARCHING'),
        				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
        				getInnerTpl: function() {
        					return '<div class="search-item">' +
        					'{value}' +
        					'</div>';
        				},
        				listeners: {
        					beforeshow: function(picker) {
        						picker.minWidth = picker.up('combobox').getSize().width;
        					}
        				}
        			}
        		}]
	        },{
	        	xtype: 'fieldcontainer',
	        	layout: 'hbox',
	        	defaults: {
	        		width: 226,
	        		labelAlign: 'top'
	        	},
	        	items: [{
        			xtype: 'customcombobox',
        			name: 'batchId',
        			hidden:true,
        			itemId:'batchIdItemId',
        			store:'examinationcenters.examstaffallocation.commonFilter.ExamProgramBatchFilter',
        			displayField:'value',
        			valueField:'id',
        			fieldLabel:getExaminationTranslation('BATCH'),
        			queryParam:'searchText',
        			minChars:3,
        			typeAhead:false,
        			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
        			enableKeyEvents  : 'true',
        			hideTrigger:false,
        			forceSelection:true,
        			disabled:true,
        			width:226,
        			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
        			listConfig: {
        				loadingText: getCommonTranslation('SEARCHING'),
        				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
        				getInnerTpl: function() {
        					return '<div class="search-item">' +
        					'{value}' +
        					'</div>';
        				},
        				listeners: {
        					beforeshow: function(picker) {
        						picker.minWidth = picker.up('combobox').getSize().width;
        					}
        				}
        			}
        		},{
        			xtype: 'customcombobox',
        			name: 'evalGroupId',
        			store:'examinationcenters.examstaffallocation.EvalGroupByEvalStage',
        			displayField:'code',
        			valueField:'id',
        			width:226,
        			forceSelection:true,
        			typeAhead:true,
        			minChars:3,
        			fieldLabel:getExaminationTranslation('EVALUATION_GROUP'),
        			hidden:true,
        			disabled:true
        		},{
        			xtype: 'customcombobox',
        			name:'courseId',
        			itemId:'courseIdItemId',
        			store: 'examinationcenters.examstaffallocation.commonFilter.ExamCourseFilter',
        			fieldLabel: getCommonTranslation('COURSE_CODE_NAME'),
        			valueField: 'courseVariantId',
        			displayField: 'value',
        			queryParam:'textSearch',
        			minChars:3,
        			typeAhead:false,
        			hidden:true,
        			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
        			enableKeyEvents  : 'true',
        			hideTrigger:false,
        			forceSelection:true,
        			disabled:true,
        			width:226,
        			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
        			listConfig: {
        				loadingText: getCommonTranslation('SEARCHING'),
        				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
        				getInnerTpl: function() {
        					return '<div class="search-item">' +
        					'{value}' +
        					'</div>';
        				},
        				listeners: {
        					beforeshow: function(picker) {
        						picker.minWidth = picker.up('combobox').getSize().width;
        					}
        				}
        			}
        		},{
    			xtype: 'customcombobox',
    			name: 'courseVariantsId',
    			itemId: 'courseVariantsIdItemId',
    			fieldLabel:getExaminationTranslation('COURSE_VARIANT'),
    			store:'examinationcenters.examstaffallocation.commonFilter.ExamCVFilter',
    			valueField: 'id',
    			displayField: 'value',
    			queryParam:'searchText',
    			minChars:3,
    			typeAhead:false,
    			hidden:true,
    			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
    			enableKeyEvents  : 'true',
    			hideTrigger:false,
    			forceSelection:true,
    			disabled:true,
    			width:226,
    			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
    			listConfig: {
    				loadingText: getCommonTranslation('SEARCHING'),
    				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    				getInnerTpl: function() {
    					return '<div class="search-item">' +
    					'{value}' +
    					'</div>';
    				},
    				listeners: {
    					beforeshow: function(picker) {
    						picker.minWidth = picker.up('combobox').getSize().width;
    					}
    				}
    			}
    		}, {
    			xtype: 'hidden',
    			name: 'examDateId'
    		}, {
        			xtype: 'datefield',
        			name: 'examStaffAllocationStartDate',
        			listeners: {
        				render: function(field) {
        					return dateFormatRender(field);
        				}
        			},
        			//--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
        			itemId:'startDateItemId',
        			editable:false,
        			disabled:true,
//        			vtype: 'daterange',
//					endDateField: 'toDateItemId',
        			fieldLabel:getExaminationTranslation('EXAMP_DATE')
        		},{
        			xtype: 'datefield',
        			name: 'examStaffAllocationToDate',
        			listeners: {
        				render: function(field) {
        					return dateFormatRender(field);
        				}
        			},
        			//--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
        			editable:false,
        			hidden:true,
        			disabled:true,
//        			vtype: 'daterange',
//					startDateField: 'startDateItemId',
        			itemId:'toDateItemId',
        			fieldLabel:getExaminationTranslation('To_DATE')
        		},{
        			xtype: 'customcombobox',
        			name:'groupDateBatchCenterId',
        			store:'examinationcenters.examstaffallocation.commonFilter.ExamBatchFilter',
        			valueField : 'id',
        			fieldLabel:getExaminationTranslation('TIME_SLOT'),
        			displayField : 'value',
        			typeAhead:true,
        			disabled:true,
        			forceSelection: true
        		}]
	        },{
	        	xtype: 'fieldcontainer',
	        	layout: 'hbox',
	        	defaults: {
	        		width: 226,
	        		labelAlign: 'top'
	        	},
	        	items: [{
        			xtype: 'customcombobox',
        			name: 'sectionId',
        			itemId: 'sectionIdItemId',
        			width:226,
        			fieldLabel:getExaminationTranslation('SECTION'),
        			store:'examinationcenters.examstaffallocation.commonFilter.ExamSectionFilter',
        			valueField: 'id',
        			hidden:true,
        			displayField: 'value',
        			queryParam:'searchText',
        			minChars:3,
        			typeAhead:false,
        			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
        			enableKeyEvents  : 'true',
        			hideTrigger:false,
        			forceSelection:true,
        			disabled:true,
        			width:226,
        			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
        			listConfig: {
        				loadingText: getCommonTranslation('SEARCHING'),
        				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
        				getInnerTpl: function() {
        					return '<div class="search-item">' +
        					'{value}' +
        					'</div>';
        				},
        				listeners: {
        					beforeshow: function(picker) {
        						picker.minWidth = picker.up('combobox').getSize().width;
        					}
        				}
        			}
        		},{
        			xtype: 'customcombobox',
        			name: 'eventsId',
        			width:226,
        			fieldLabel:getExaminationTranslation('DETAIL_SEQUENCE'),
        			store:'examinationcenters.examstaffallocation.commonFilter.ExamEventFilter',
        			valueField: 'id',
        			displayField: 'value',
        			hidden:true,
        			queryParam:'searchText',
        			minChars:3,
        			typeAhead:false,
        			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
        			enableKeyEvents  : 'true',
        			hideTrigger:false,
        			forceSelection:true,
        			disabled:true,
        			width:226,
        			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
        			listConfig: {
        				loadingText: getCommonTranslation('SEARCHING'),
        				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
        				getInnerTpl: function() {
        					return '<div class="search-item">' +
        					'{value}' +
        					'</div>';
        				},
        				listeners: {
        					beforeshow: function(picker) {
        						picker.minWidth = picker.up('combobox').getSize().width;
        					}
        				},
        			}
        		},{
        			xtype: 'customcombobox',
        			name: 'userId',
        			width:226,
        			fieldLabel:getExaminationTranslation('USER'),
        			store:'examinationcenters.examstaffallocation.ExaminationStaffByRole',
        			valueField: 'id',
        			displayField: 'value',
        			queryParam:'name',
        			hidden:true,
        			minChars:3,
        			typeAhead:false,
        			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
        			enableKeyEvents  : 'true',
        			hideTrigger:false,
        			forceSelection:true,
        			disabled:true,
        			width:226,
        			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
        			listConfig: {
        				loadingText: getCommonTranslation('SEARCHING'),
        				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
        				getInnerTpl: function() {
        					return '<div class="search-item">' +
        					'{value}' +
        					'</div>';
        				},
        				listeners: {
        					beforeshow: function(picker) {
        						picker.minWidth = picker.up('combobox').getSize().width;
        					}
        				},
        			}
        		}]
	        },{
	        	xtype:'fieldset',
	        	title: getTransportTranslation('MORE_FILTERS'),
	        	layout:'vbox',
	        	frame:true,	
	        	itemId:'moreFilterItemId',
	        	collapsible:true,
	        	collapsed:true,
	        	style:{marginTop: '33px!important',paddingTop:'25px!important'},
	        	width:'100%',
	        	items: [{
	        		xtype: 'fieldcontainer',
	        		width: 'auto',
	        		layout: 'hbox',
	        		defaults: {
	        			width: 226,
	        			labelAlign: 'top'
	        		},
	        		items: [{
	        			xtype: 'customcombobox',
	        			name: 'evaluationPlan',
	        			itemId:'evaluationPlanItemId',
	        			store:'examCenter.AssignSequence.EvaluationType',
	        			displayField:'value',
	        			valueField:'id',
	        			forceSelection:true,
	        			typeAhead:true,
	        			minChars:3,
	        			hidden:true,
	        			disabled:true,
	        			fieldLabel:getExaminationTranslation('EVALUATION_PLAN_TYPE')
	        		},{
	        			xtype: 'customcombobox',
	        			name: 'evaluationStage',
	        			itemId:'evaluationStageItemId',
	        			store:'examinationcenters.CenterUseFor',
	        			displayField:'value',
	        			valueField:'id',
	        			forceSelection:true,
	        			typeAhead:true,
	        			minChars:3,
	        			hidden:true,
	        			disabled : true,
	        			fieldLabel:getExaminationTranslation('EVALUATION_STAGE')
	        		},{
	        			xtype : 'customcombobox',
	        			name : 'placementEvaluationStage',
	        			itemId:'placementEvaluationStageItemId',
	        			fieldLabel : getExaminationTranslation('EVALUATION_STAGE'),
	        			store : 'examinationcenters.evaluation.PlacementAcademyOthers',
	        			valueField : 'id',
	        			displayField : 'value',
	        			disabled : true,
	        			hidden:true
	        		}]
	        	},{
	        		xtype: 'fieldcontainer',
	        		layout: 'hbox',
	        		defaults: {
	        			width: 226,
	        			labelAlign: 'top'
	        		},
	        		items: [{

	        			xtype: 'customcombobox',
	        			name:'program',
	        			itemId:'programItemId',
	        			store:'examinationcenters.examstaffallocation.commonFilter.ExamProgramFilter',
	        			fieldLabel:getExaminationTranslation('PROGRAM'),
	        			valueField: 'id',
	        			displayField: 'valueCode',
	        			queryParam:'searchText',
	        			minChars:3,
	        			width:226,
	        			typeAhead:false,
	        			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
	        			enableKeyEvents  : 'true',
	        			hideTrigger:false,
	        			forceSelection:true,
	        			disabled:true,
	        			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
	        			listConfig: {
	        				listeners: {
	        					beforeshow: function(picker) {
	        						picker.minWidth = picker.up('combobox').getSize().width;
	        					}
	        				},
	        				loadingText: getCommonTranslation('SEARCHING'),
	        				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	        				getInnerTpl: function() {
	        					return '<div class="search-item">' +
	        					'{valueCode}' +
	        					'</div>';
	        				}
	        			}
	        		},{
	        			xtype: 'customcombobox',
	        			name: 'batch',
	        			itemId:'batchItemId',
	        			store:'examinationcenters.examstaffallocation.commonFilter.ExamProgramBatchFilter',
	        			displayField:'value',
	        			valueField:'id',
	        			typeAhead:true,
	        			fieldLabel:getExaminationTranslation('BATCH'),
	        			disabled:true
	        		},{
	        			xtype: 'customcombobox',
	        			name: 'evalGroupId',
	        			store:'examinationcenters.examstaffallocation.EvalGroupByEvalStage',
	        			displayField:'value',
	        			valueField:'id',
	        			width:460,
	        			forceSelection:true,
	        			typeAhead:true,
	        			minChars:3,
	        			disabled:true,
	        			fieldLabel:getExaminationTranslation('EVALUATION_GROUP'),
	        			hidden:true
	        		}]
	        	},{
	        		xtype: 'fieldcontainer',
	        		layout: 'hbox',
	        		defaults: {
	        			width: 226,
	        			labelAlign: 'top'
	        		},
	        		items: []
	        	},{

	        		xtype: 'fieldcontainer',
	        		layout: 'hbox',
	        		defaults: {
	        			width: 226,
	        			labelAlign: 'top'
	        		},
	        		items: [{
	        			/*xtype: 'customcombobox',
                    		name: 'course',
                    		store:'coursetransaction.studymaterialdistribution.CoursesAllStore',
                    		displayField:'value',
                    		valueField:'id',
                    		itemId:'courseItemId',
                    		width:460,
                    		forceSelection:true,
                    		typeAhead:true,
                    		minChars:3,
                    		fieldLabel:getExaminationTranslation('COURSE')*/

	        			xtype: 'customcombobox',
	        			name:'course',
	        			itemId:'courseItemId',
	        			store: 'examinationcenters.examstaffallocation.commonFilter.ExamCourseFilter',
	        			fieldLabel: getCommonTranslation('COURSE_CODE_NAME'),
	        			valueField: 'id',
	        			displayField: 'value',
	        			queryParam:'textSearch',
	        			minChars:3,
	        			typeAhead:false,
	        			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
	        			enableKeyEvents  : 'true',
	        			hideTrigger:false,
	        			forceSelection:true,
	        			disabled:true,
	        			width:226,
	        			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
	        			listConfig: {
	        				loadingText: getCommonTranslation('SEARCHING'),
	        				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	        				getInnerTpl: function() {
	        					return '<div class="search-item">' +
	        					'{value}' +
	        					'</div>';
	        				},
	        				listeners: {
	        					beforeshow: function(picker) {
	        						picker.minWidth = picker.up('combobox').getSize().width;
	        					}
	        				},
	        			}
	        		}, {
	        			xtype: 'customcombobox',
	        			name: 'courseVariant',
	        			itemId:'courseVariantItemId',
	        			fieldLabel:getExaminationTranslation('COURSE_VARIANT'),
	        			store:'examinationcenters.examstaffallocation.commonFilter.ExamCVFilter',
	        			valueField: 'id',
	        			displayField: 'value',
	        			queryParam:'searchText',
	        			minChars:3,
	        			typeAhead:false,
	        			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
	        			enableKeyEvents  : 'true',
	        			hideTrigger:false,
	        			forceSelection:true,
	        			disabled:true,
	        			width:460,
	        			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
	        			listConfig: {
	        				loadingText: getCommonTranslation('SEARCHING'),
	        				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	        				getInnerTpl: function() {
	        					return '<div class="search-item">' +
	        					'{value}' +
	        					'</div>';
	        				},
	        				listeners: {
	        					beforeshow: function(picker) {
	        						picker.minWidth = picker.up('combobox').getSize().width;
	        					}
	        				},
	        			}
	        		}]

	        	},{
	        		xtype: 'fieldcontainer',
	        		layout: 'hbox',
	        		defaults: {
	        			width: 226,
	        			labelAlign: 'top'
	        		},
	        		items: [{
	        			xtype: 'customcombobox',
	        			name: 'section',
	        			itemId:'sectionItemId',
	        			width:226,
	        			fieldLabel:getExaminationTranslation('SECTION'),
	        			store:'examinationcenters.examstaffallocation.commonFilter.ExamSectionFilter',
	        			valueField: 'id',
	        			displayField: 'value',
	        			queryParam:'searchText',
	        			minChars:3,
	        			typeAhead:false,
	        			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
	        			enableKeyEvents  : 'true',
	        			hideTrigger:false,
	        			forceSelection:true,
	        			disabled:true,
	        			width:226,
	        			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
	        			listConfig: {
	        				loadingText: getCommonTranslation('SEARCHING'),
	        				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	        				getInnerTpl: function() {
	        					return '<div class="search-item">' +
	        					'{value}' +
	        					'</div>';
	        				},
	        				listeners: {
	        					beforeshow: function(picker) {
	        						picker.minWidth = picker.up('combobox').getSize().width;
	        					}
	        				},
	        			}
	        		},{
	        			xtype: 'customcombobox',
	        			name: 'eventId',
	        			itemId:'eventItemId',
	        			width:226,
	        			fieldLabel:getExaminationTranslation('DETAIL_SEQUENCE'),
	        			store:'examinationcenters.examstaffallocation.commonFilter.ExamEventFilter',
	        			valueField: 'id',
	        			displayField: 'value',
	        			queryParam:'searchText',
	        			minChars:3,
	        			typeAhead:false,
	        			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
	        			enableKeyEvents  : 'true',
	        			hideTrigger:false,
	        			forceSelection:true,
	        			disabled:true,
	        			width:226,
	        			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
	        			listConfig: {
	        				loadingText: getCommonTranslation('SEARCHING'),
	        				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	        				getInnerTpl: function() {
	        					return '<div class="search-item">' +
	        					'{value}' +
	        					'</div>';
	        				},
	        				listeners: {
	        					beforeshow: function(picker) {
	        						picker.minWidth = picker.up('combobox').getSize().width;
	        					}
	        				},
	        			}
	        		},{
	        			xtype: 'customcombobox',
	        			name: 'user',
	        			width:226,
	        			fieldLabel:getExaminationTranslation('USER'),
	        			store:'examinationcenters.examstaffallocation.ExaminationStaffByRole',
	        			valueField: 'id',
	        			displayField: 'value',
	        			queryParam:'name',
	        			minChars:3,
	        			typeAhead:false,
	        			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
	        			enableKeyEvents  : 'true',
	        			hideTrigger:false,
	        			forceSelection:true,
	        			disabled:true,
	        			width:226,
	        			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
	        			listConfig: {
	        				loadingText: getCommonTranslation('SEARCHING'),
	        				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	        				getInnerTpl: function() {
	        					return '<div class="search-item">' +
	        					'{value}' +
	        					'</div>';
	        				},
	        				listeners: {
	        					beforeshow: function(picker) {
	        						picker.minWidth = picker.up('combobox').getSize().width;
	        					}
	        				},
	        			}
	        		}]
	        	}],
	        	listeners:{
	        		render: function(myfieldset){
	        			myfieldset.setMargin('-10px');
	        		}
	        	}
	        },
	        {
	        	xtype: 'fieldcontainer',
	        	width: 'auto',

	        	items: [{
	        		xtype: 'button',
	        		text: getCommonTranslation('SEARCH'),
	        		itemId: 'searchBtn',
	        		buttonAlign: 'left',
	        		ui: 'CustomBtnSubmit',
	        		scale: CONSTANTS.BUTTONSIZE,
	        		formBind:true
	        	},{
	        		xtype: 'button',
	        		text: getCommonTranslation('RESET'),
	        		itemId: 'resetBtn',
	        		ui: 'CustomBtnCancel',
	        		scale: CONSTANTS.BUTTONSIZE   
	        	}]	
	        }]
});