/**
 * @author Bhanu Pratap Singh
 */
Ext.define('Academia.view.examinationcenters.manageEvaluation.DownloadMarksFilter', {
	extend: 'Ext.form.Panel',
	alias: 'widget.downloadmarksfilter',
	autoScroll: false,
	frame: false,
	standardSubmit: false,
	plugins:"formlabelrequired",
	items: [{
			xtype: 'radiogroup',
			itemId:'eventQuestionGroupId',
			name: 'eventQuestion',
			labelAlign:'top',			
			columns: 4,
			vertical: true,
			items : [{
	   	   		 boxLabel : getExaminationTranslation('EVENT_MARK_ENTRY'),
	   	   		 name : 'eventMarkEntry',
	   	   		 itemId:'eventMarkEntryItemId',
	   	   		 inputValue : 'forEventMarkEntry',
	   	   		 checked : true
	   	   		 
	   	   	 },{
	   	   		 boxLabel : getExaminationTranslation('QUESTION_MARK_ENTRY'),
	   	   		 name : 'eventMarkEntry',
	   	   		 itemId:'questionMarkEntryItemId',
	   	   		 inputValue : 'forQuestionMarkEntry'
	   	   	 }]
		    },
		
		{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 226,
			labelAlign: 'top'
		},
		items: [{
			xtype: 'customcombobox',
			name: 'evaluationType',
			itemId:'evaluationTypeItemId',
			store:'examCenter.AssignSequence.EvaluationType',
			displayField:'value',
			valueField:'id',
			forceSelection:true,
			editable:false,
			typeAhead:true,
			allowBlank:false,
			fieldLabel:getExaminationTranslation('EVALUATION_TYPE'),
		},{
			xtype: 'customcombobox',
			name:'evaluationStage',
			store:'examinationcenters.CenterUseFor',
			itemId:'evaluationStageItemId',
			fieldLabel: getExaminationTranslation('EVALUATION_STAGE'),
			displayField: 'value',
			valueField: 'id',
			typeAhead: true,
			forceSelection: true,
		},{
			xtype : 'customcombobox',
			fieldLabel : getCommonTranslation('ACADEMIC_TERM'),		
			name : 'importMarkEntryAcademicTerm',
			itemId : 'importMarkEntryAcademicTermId',
			displayField : 'value',
			valueField : 'id',
			store:Ext.create('Academia.store.common.AcademicTermStoreForIntakeYearId'),
			typeAhead : true,
			allowBlank:false,
			forceSelection : true,
		},{
			xtype: 'customcombobox',
			name:'evalautionPlanNo',
			itemId:'evalautionPlanNoItemId',
			store: Ext.create('Academia.store.examinationcenters.evaluationgroup.detailsequencecovered.EvaluationPlanOtherForTemplate'),
			fieldLabel:getExaminationTranslation('EVALUATION_PLAN'),
			valueField: 'id',
			displayField: 'value',
			queryParam:'evaluationPlanNumber',
			minChars:3,
			width: 226,
			typeAhead:true,
			allowBlank:false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		},{
			xtype: 'customcombobox',
			name:'evalautionPlan',
			itemId:'evalautionPlanItemId',
			store:'examinationcenters.evaluationgroup.detailsequencecovered.EvalPlanTemplateMarksentry',
			fieldLabel:getExaminationTranslation('EVALUATION_PLAN'),
			valueField: 'id',
			hidden:true,
			displayField: 'value',
			queryParam:'evaluationPlanNumber',
			minChars:3,
			disabled:true,
			width: 226,
			typeAhead:false,
			allowBlank:false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		}]
	},{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 226,
			labelAlign: 'top'
		},
		items: [{
        	xtype: 'hidden',
            name: 'evalPlanLevelType'
        },{
			xtype: 'customcombobox',
			name:'course_name',
			itemId:'courseItemId',
			store: 'attendance.CoursesFromEvaluationPlan',
			fieldLabel: getCommonTranslation('COURSE_CODE_NAME'),
			valueField: 'id',
			displayField: 'value',
			queryParam:'courseName',
			minChars:3,
			disabled:true,
			typeAhead:false,
			//triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			triggerAction: '',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			width:226,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		},{
			xtype: 'multiselectcombofield',
			addAllSelector: false,
			name: 'courseVariant',
			itemId:'courseVariantItemId',
			width:460,
			labelAlign: 'top',
			fieldLabel:getExaminationTranslation('COURSE_VARIANT'),
			store:'attendance.CourseVariantMappedToPlanTemplate',
			displayField:'value',
			valueField:'id',
			autoloadStore: false,
			disabled:true,
			typeAhead:false,
			forceSelection:true,
			allowBlank: false,
			editable:false,
			matchFieldWidth: false,
			cls:'commonAutoHeightMultiselectField resetPasswordMultiselect',
			fieldLabel:getExaminationTranslation('COURSE_VARIANT'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					},
					refresh: function( boundList, eOpts ){
						try{
							var combo = boundList.up('combo');
							try{
								var isDynamic = combo.up('form').down('#detailSequenceItemId').getStore().getProxy().extraParams.isDynamicScheme;
							}
							catch(e){
								var isDynamic = false;
							}
							if(isDynamic==true || isDynamic=="true"){
								var newValue = combo.getValue();
								if(!isNullOrEmpty(newValue[0])){
									var allItems = combo.listKeyNav.boundList.all.elements;
									var selectedVariantId = 0;
									var selectedCourseId = 0;
									var comboStore = combo.getStore();
									if(typeof combo.getValue() == "string"){
										selectedVariantId = combo.getValue();
									}
									else{
										selectedVariantId = combo.getValue()[0].get('id');
									}
									if(selectedVariantId){
										var selectedRecord = comboStore.findRecord('id',selectedVariantId);
										var selectedCourseId = selectedRecord.get('courseId');
									}
									Ext.each(allItems, function(currentItem){
										var currentCourseVariantId = currentItem.viewRecordId;
										var currentCourseVariantRecord = comboStore.findRecord('id',currentCourseVariantId);
										if(currentCourseVariantRecord.get('courseId') == selectedCourseId){
											currentItem.classList.remove("disabledComboItem")
										}
										else{
											currentItem.classList.add("disabledComboItem");
										}
									});
								}
							}
						}
						catch(e){
							console.log(e);
						}
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}' +
					'</div>';
				}
			},
			listeners:{
				beforeselect:function(selModel,record,index){
					var combo = selModel.view.field;
					try{
						var isDynamic = combo.up('form').down('#detailSequenceItemId').getStore().getProxy().extraParams.isDynamicScheme;
					}
					catch(e){
						var isDynamic = false;
					}
					if(isDynamic==true || isDynamic=="true"){
						if(!isNullOrEmpty(combo.getValue()) && combo.getValue() != "") {
							var value = combo.getValue();
							if(value[0].data.courseId != record.data.courseId){
								return false;
							}
						}
					}
					else{
						return true;
					}
				},
				change: function(combo, newValue, oldValue, eOpt){
					var allItems = combo.listKeyNav.boundList.all.elements;
					var selectedVariantId = 0;
					var selectedCourseId = 0;
					var comboStore = combo.getStore();
					try{
						var isDynamic = combo.up('form').down('#detailSequenceItemId').getStore().getProxy().extraParams.isDynamicScheme;
					}
					catch(e){
						var isDynamic = false;
					}
					if(isDynamic==true || isDynamic=="true"){
						if(typeof combo.getValue() == "string"){
							selectedVariantId = combo.getValue();
						}
						else{
							selectedVariantId = combo.getValue()[0];
						}
						if(!isNullOrEmpty(selectedVariantId)){
							if(selectedVariantId){
								var selectedRecord = comboStore.findRecord('id',selectedVariantId);
								var selectedCourseId = selectedRecord.get('courseId');
							}
							Ext.each(allItems, function(currentItem){
								var currentCourseVariantId = currentItem.viewRecordId;
								var currentCourseVariantRecord = comboStore.findRecord('id',currentCourseVariantId);
								if(currentCourseVariantRecord.get('courseId') == selectedCourseId){
									currentItem.classList.remove("disabledComboItem")
								}
								else{
									currentItem.classList.add("disabledComboItem");
								}
							});
						}
					}
				}
			}
		}]
	},{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 226,
			labelAlign: 'top'
		},
		items: [{
			xtype: 'customcombobox',
			name:'programId',
			itemId:'programIdQuickFiltr',
			store:'examinationcenters.evaluation.evaluationPlanHeirarchy.EvaluationProgramTemplateStore',//'common.ProgramStore',
			fieldLabel:getExaminationTranslation('PROGRAM'),
			valueField: 'id',
			displayField: 'value',
			queryParam:'programName',
			minChars:3,
			typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			autoloadStore: false,
			forceSelection:true,
			allowBlank:false,
			hidden:true,
			disabled:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}  
		},{
			xtype: 'customcombobox',
			name: 'batchId',
			itemId:'batchIdQuickFiltr',
			store:'examinationcenters.evaluation.evaluationPlanHeirarchy.EvaluationBatchTemplateStore',//'common.BatchesByProgramId',
			displayField:'value',
			queryParam:'batchName',
			minChars:3,
			valueField:'id',
			//forceSelection:true,
			typeAhead:true,
			hidden:true,
			allowBlank:false,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}  ,
			disabled:true,
			forceSelection:true,
			fieldLabel:getExaminationTranslation('BATCH'),
		},{
			xtype: 'customcombobox',
			name: 'periodId',
			itemId:'periodIdQuickFiltr',
			store:'examinationcenters.evaluation.evaluationPlanHeirarchy.EvaluationPeriodTemplateStore',//'program.programDetails.programBatches.courseParameter.ProgramCoursePeriod',
			displayField:'value',
			valueField:'id',
			//forceSelection:true,
			allowBlank:false,
			typeAhead:true,
			disabled:true,
			hidden:true,
			fieldLabel:getExaminationTranslation('PERIOD'),
		}]
	},{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 226,
			labelAlign: 'top'
		},
		items: [{
			xtype: 'multiselectcombofield',
			name: 'sectionId',
			itemId:'sectionIdQuickFiltr',
			store:'examinationcenters.evaluation.evaluationPlanHeirarchy.EvaluationSectionTemplateStore',//'coursetransaction.sectionmanagement.SectionsStore',
			displayField:'value',
			valueField:'id',
			disabled:true,
			allowBlank:false,
			width: 226,
			typeAhead:true,
			hidden:true,
			fieldLabel:getExaminationTranslation('SECTION'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		},/*{
			xtype : 'customcombobox',
			name : 'category',
			itemId:'categoryId',
			fieldLabel : getExaminationTranslation('CATEGORY'),
			store : 'examinationcenters.evaluation.OtherCategory',
			valueField : 'id',
			displayField : 'value',
			editable:false,
			width:460,
			hidden:true,
			allowBlank:false,
			disabled:true,
		}*/,{
            xtype: 'groupingcombobox',
            name: 'evalPlanLevelId',
            itemId:'evalPlanLevelItemId',
            labelAlign:'top',
            queryMode: 'local',
            groupField: 'code',
            groupDisplayField: 'code',
            store: 'examinationcenters.remark.EvaluationPlanLevelByEvaluationPlanId',
            fieldLabel: getExaminationTranslation('EVALUATION_PLAN_LEVEL'),
            displayField: 'value',
           // valueField: 'levelId', 
         	forceSelection :true,
            minChar : 3,
            disabled:true,
			editable:false,
            allowBlank: true,
           /* listeners:{
            	select:function(obj,rec){
            		var data=rec[0].data.code;
            		//obj.nextSibling().setValue(data);
            	}
            }*/
        },{
			xtype : 'radiogroup',
			fieldLabel:getExaminationTranslation('ANONYMOUS_EVENT'),
			itemId:'anonymousEvent',
			labelAlign : 'top',
			hidden:true,
			items : [{
				boxLabel : getExaminationTranslation('YES'),
				name:'anonymousEvent',
				inputValue: true,
			},{
				boxLabel : getExaminationTranslation('NO'),
				name:'anonymousEvent',
				inputValue: false,
				checked : true
			}]
		},{
			xtype:'hidden',
			name:'evaluationEventStatus'
		}]
	},{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 460,
			labelAlign: 'top'
		},
		items: [/*{
			xtype: 'multiselectcombofield',
			name: 'courseVariant',
			itemId:'courseVariantItemId',
			disabled:true,
			store:'examinationcenters.evaluation.coverageDetails.CoverageDetailsGrid',
			displayField:'displayValue',
			valueField:'id',
			width:460,
			maxLength:9999,
  			maxSelections :9999,
			forceSelection:true,
			typeAhead:true,
			allowBlank: false,
			editable:false,
			fieldLabel:getExaminationTranslation('COURSE_VARIANT'),
			listConfig: {
				loadingText: getCommonTranslation('SEARCHING'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}' +
					'</div>';
				}
			}
		}*/]
	}, {
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 226,
			labelAlign: 'top'
		},
		style:{
			marginButtom:"10px !important"
		},
		items: []

	},{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			labelAlign: 'top'
		},
		items: [{
			xtype: 'multiselectcombofield',
			name: 'detailSequence',
			itemId:'detailSequenceItemId',
			store:Ext.create('Academia.store.examinationcenters.examstaffallocation.DetailSequencePostComboStore'),
			displayField:'value',
			cls:'commonAutoHeightMultiselectField resetPasswordMultiselect', 
			disabled:true,
			valueField:'id',
			width: 460,
			forceSelection:true,
			maxLength:9999,
			maxSelections :9999,
			editable:false,
			typeAhead:true,
			fieldLabel:getExaminationTranslation('DETAILED_SEQUENCE'),
			listConfig: {
				loadingText: getCommonTranslation('SEARCHING'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				},
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					},
					refresh: function( boundList, eOpts ){
						try{
							var combo = boundList.up('combo');
							var isDynamic = false;
							var vals = combo.getValue();
							var comboStore = combo.getStore();
							if(!vals) {
								vals = [];
							}
							for(var i = 0; i < vals.length; i++) {
								isDynamic = vals[i].get('appliedExamMarkEntry');
								break;
							}
							/*try{
								var isDynamic = comboStore.findRecord('id', newValue).get('appliedExamMarkEntry');
							}
							catch(e){
								var isDynamic = false;
							}*/
							var isSelectAll = false;
							var allItems = combo.listKeyNav.boundList.all.elements;
							if(vals.length == comboStore.getCount()) {
								isSelectAll = true;
							}
							if(isSelectAll) {
								var toDeselect = [];
								var itemsToDisable = [];
								if(allItems.length > 1) {
									Ext.each(allItems, function(currentItem){
										var currentId = currentItem.viewRecordId;
										var currentRecord = comboStore.findRecord('id',currentId);
										if(currentRecord.get('appliedExamMarkEntry') == true){
											toDeselect.push(currentRecord);
											itemsToDisable.push(currentItem);
										}
										else{
											currentItem.classList.remove("disabledComboItem");
										}
									});
									Ext.defer(function() {
										combo.suspendEvents();
										for(var i = 0; i < toDeselect.length; i++) {
											itemsToDisable[i].classList.add("disabledComboItem");
											combo.picker.getSelectionModel().deselect(toDeselect[i]);
										}
										combo.resumeEvents();
									}, 1);
								}
							}
							else {
								if(isDynamic==true || isDynamic=="true"){
									if(typeof combo.getValue() == "string"){
										selectedId = combo.getValue();
									}
									else{
										selectedId = combo.getValue()[0];
									}
									if(selectedId){
										var newValue = selectedId.get('id');
										Ext.each(allItems, function(currentItem){
											var currentId = currentItem.viewRecordId;
											var currentRecord = comboStore.findRecord('id',currentId);
											if(currentRecord.get('id') == newValue){
												currentItem.classList.remove("disabledComboItem")
											}
											else{
												currentItem.classList.add("disabledComboItem");
											}
										});
									}
								}
								else {
									if(typeof combo.getValue() == "string"){
										selectedId = combo.getValue();
									}
									else{
										selectedId = combo.getValue()[0];
									}
									if(selectedId){
										Ext.each(allItems, function(currentItem){
											var currentId = currentItem.viewRecordId;
											var currentRecord = comboStore.findRecord('id',currentId);
											if(currentRecord.get('appliedExamMarkEntry') == false){
												currentItem.classList.remove("disabledComboItem")
											}
											else{
												currentItem.classList.add("disabledComboItem");
											}
										});
									}
								}
							}
						}
						catch(e){
							console.log(e);
						}
					}
				}
			},
			listeners:{
				beforeselect:function(selModel,record,index){
					var combo = selModel.view.field;
					/*try{
						var isDynamic = comboStore.findRecord('id', newValue).get('appliedExamMarkEntry');
					}
					catch(e){
						var isDynamic = false;
					}
					if(isDynamic==true || isDynamic=="true"){
						if(!isNullOrEmpty(combo.getValue()) && combo.getValue() != "") {
							var value = combo.getValue();
							if(value[0].data.id != record.data.id){
								return false;
							}
						}
					}
					else{
						return true;
					}*/
					if(combo.listKeyNav.boundList.mouseOverItem.classList.contains('disabledComboItem')) {
						return false;
					}
					else {
						return true;
					}
				},
				change: function(combo, newValue, oldValue, eOpt){
					var allItems = combo.listKeyNav.boundList.all.elements;
					var selectedId = 0;
					var comboStore = combo.getStore();
					var isSelectAll = false;
					if(newValue.length == comboStore.getCount()) {
						isSelectAll = true;
					}
					try{
						var isDynamic = comboStore.findRecord('id', newValue).get('appliedExamMarkEntry');
					}
					catch(e){
						var isDynamic = false;
					}
					if(isSelectAll) {
						var toDeselect = [];
						var itemsToDisable = [];
						if(allItems.length > 1) {
							Ext.each(allItems, function(currentItem){
								var currentId = currentItem.viewRecordId;
								var currentRecord = comboStore.findRecord('id',currentId);
								if(currentRecord.get('appliedExamMarkEntry') == true){
									toDeselect.push(currentRecord);
									itemsToDisable.push(currentItem);
								}
								else{
									currentItem.classList.remove("disabledComboItem");
								}
							});
							Ext.defer(function() {
								combo.suspendEvents();
								for(var i = 0; i < toDeselect.length; i++) {
									itemsToDisable[i].classList.add("disabledComboItem");
									combo.picker.getSelectionModel().deselect(toDeselect[i]);
								}
								combo.resumeEvents();
							}, 1);
						}
					}
					else {
						if(isDynamic==true || isDynamic=="true"){
							if(typeof combo.getValue() == "string"){
								selectedId = combo.getValue();
							}
							else{
								selectedId = combo.getValue()[0];
							}
							if(selectedId){
								Ext.each(allItems, function(currentItem){
									var currentId = currentItem.viewRecordId;
									var currentRecord = comboStore.findRecord('id',currentId);
									if(currentRecord.get('id') == newValue){
										currentItem.classList.remove("disabledComboItem")
									}
									else{
										currentItem.classList.add("disabledComboItem");
									}
								});
							}
						}
						else {
							if(typeof combo.getValue() == "string"){
								selectedId = combo.getValue();
							}
							else{
								selectedId = combo.getValue()[0];
							}
							if(selectedId){
								Ext.each(allItems, function(currentItem){
									var currentId = currentItem.viewRecordId;
									var currentRecord = comboStore.findRecord('id',currentId);
									if(currentRecord.get('appliedExamMarkEntry') == false){
										currentItem.classList.remove("disabledComboItem")
									}
									else{
										currentItem.classList.add("disabledComboItem");
									}
								});
							}
						}
					}
				}
			}
		},{
			xtype: 'customcombobox',
			name: 'detailSequenceQuestion',
			itemId:'questionDetailSequenceItemId',
			store:Ext.create('Academia.store.examinationcenters.examstaffallocation.DetailSequencePostComboStore'),
			displayField:'value',
			valueField:'id',
			width: 460,
			//forceSelection:true,
			allowBlank:false,
			typeAhead:true,
			disabled:true,
			hidden:true,
			fieldLabel:getExaminationTranslation('DETAILED_SEQUENCE'),
		}]
	},{
		xtype:'fieldset',
		itemId:'moreFilter',
		title: getTransportTranslation('MORE_FILTERS'),
		layout:'vbox',
		frame:true,	
		collapsible:true,
		collapsed:true,
		style:{marginTop: '33px!important'},
		width:'100%',
		items: [{
			xtype: 'fieldcontainer',
			width: 'auto',
			layout: 'hbox', 
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			items: [{
				html: '<b><u>Sorting Sequence</u></b>',
				margin: '0 0 0 -10',
			}]
		},{
			xtype: 'fieldcontainer',
			width: 'auto',
			layout: 'hbox',
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			items: [{
				xtype: 'customcombobox',
				name: 'firstSortingFilter',
				itemId:'firstSortingFilterItemId',
				store:'examinationcenters.evaluation.SortingFilterStore',
				displayField: 'value',
				valueField : 'value',
				forceSelection:true,
				editable:false,
				typeAhead:true,
				fieldLabel:getExaminationTranslation('St1_SORTING_FILTER'),
			},{
				xtype: 'customcombobox',
				name: 'secondSortingFilter',
				itemId:'secondSortingFilterItemId',
				store:'examinationcenters.evaluation.SortingFilter2Store',
				displayField: 'value',
				valueField : 'value',
				forceSelection:true,
				editable:false,
				typeAhead:true,
				disabled:true,
				fieldLabel:getExaminationTranslation('St2_SORTING_FILTER'),
			},{
				xtype: 'customcombobox',
				name: 'thirdSortingFilter',
				itemId:'thirdSortingFilterItemId',
				store:'examinationcenters.evaluation.SortingFilter3Store',
				displayField: 'value',
				valueField : 'value',
				forceSelection:true,
				editable:false,
				typeAhead:true,
				disabled:true,
				fieldLabel:getExaminationTranslation('St3_SORTING_FILTER'),
			}]
		}]
	},{
		xtype: 'fieldcontainer',
		width:'100%',
		cls:'windowBtnPos',
		items: [{
			xtype:'button',
			itemId:'markEntryDownload',
			disabled:true,
			text:getExaminationTranslation('MARK_ENTRY_DOWNLOAD'),
			ui: 'CustomBtnSubmit',
			formBind:true
		}, 
		{
			xtype: 'button',
			text: getCommonTranslation('RESET'),
			itemId:'resetBtn',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE
		}]
	}]
});
