/**
 * @author Deepika Parmar
 */
Ext.define('Academia.view.examinationcenters.manageEvaluation.ImportExternalMarkResultFilter', {
	extend: 'Ext.form.Panel',
	alias: 'widget.importexternalmarkresultfilter',
	autoScroll: false,
	frame: false,
	standardSubmit: false,
	cls:'customSearchPanel',
	defaults: {
		width: 226,
		labelAlign: 'top'
	},
	plugins : "formlabelrequired",
	items: [{
		xtype:'fieldcontainer',
		width:'auto',
		items:[{
		   	 xtype : 'radiogroup',
			 itemId:'uploadgroupItemId',
			 padding: 0,
		   	 items : [{
		   		 boxLabel : getCommonTranslation('MY_UPLOADS'),
		   		 name : 'isUploadAll',
		   		 inputValue : false,
		   		 checked : true
		   	 },{
		   		 boxLabel : getCommonTranslation('ALL_UPLOADS'),
		   		 name : 'isUploadAll',
		   		 inputValue : true
		   	 }]
		   }]
	},{
		xtype: 'customcombobox',
		name: 'templateType',
		itemId:'templateTypeId',
		store:'importutility.ImportExternalExamTypeStore',
		fieldLabel: getCommonTranslation('TEMPLATE_NAME'),
		valueField: 'name',
		displayField: 'value',
		typeAhead:true,
		forceSelection:true,
		allowBlank:false,
	},{

		xtype:'fieldcontainer',
		width:'auto',
		items:[{
			xtype: 'customcombobox',
			name: 'importUtilityMasterId',
			itemId:'importUtilityMasterId',
			store:'importutility.ModuleName',
			fieldLabel: getCommonTranslation('TEMPLATE_NAME'),
			valueField: 'id',
			displayField: 'value',
			typeAhead:true,
			forceSelection:true,
			allowBlank:false,
			hidden:true
		}]
	
	},{
		xtype:'fieldcontainer',
		width:'auto',
		items:[{
			xtype : 'filefield',
			ui : 'CustomBtnThird',
			width: 460,
			fieldLabel : getCommonTranslation('UPLOAD_FILE'),
			buttonText : getCommonTranslation('BROWSE_FILE'),
			itemId : 'uploadResultFileField',
			name : 'file',
			labelAlign:'top',
			allowBlank:false,
			validateOnChange : true,
			listeners:{
	            change: function(fileField, value) {
	                value = value.replace('C:\\fakepath\\', '');
	                var newValue = value.replace(/ +/g, " ").split(' ').join('_');
	                fileField.setRawValue(newValue);
	                if (!isNullOrEmpty(newValue)) {
	                    var extension = newValue.substring(newValue.lastIndexOf('.') + 1).toLowerCase();
	                    if (extension != "txt" && extension != "dat" && extension != "asc" ) {
	                        fileField.reset();
	                        showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('INVALID_FILE_FORMAT'));
	                    }
	                }
	            }
	        }
		}]
	},{ 	
		xtype:'fieldcontainer',
		width:'auto',
		items: [{
			xtype: 'button',
			action: 'Submit',
			text: getCommonTranslation('UPLOAD_FILE'),
			formBind: true,
			itemId: 'externalResultUpload',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE
		},{
			xtype: 'button',
			text: getCommonTranslation('RESET'),
			ui: 'CustomBtnCancel',
			itemId: 'resetBtn',
			scale: CONSTANTS.BUTTONSIZE,
			listeners:{
	            click: function(btn, value) {
	            	var form = btn.up('form');
	            	form.down('#uploadResultFileField').reset();
	            	form.getForm().checkValidity();
	            }
		}
		}]
	}]
});
