/**
 * @author Abhishek Chouhan
 */
Ext.define('Academia.view.examinationcenters.manageEvaluation.MarkEntryStudentQPDetailWin',{
	extend: 'Ext.window.Window',
	alias: 'widget.markentrystudentqpdetailwin',
	title:getExaminationTranslation('MARKS_OBTAINED'),
	modal : true,
	resizable:true,
	autoScroll: true,
	//height: 'auto',
	height: 490,
	width: '75%',
	frame: true,
	items: [{
		xtype:'form',
		itemId:'studentMarkObtainedformId',
		items:[{
			xtype: 'fieldcontainer',
			layout: {
				type: 'hbox'
			},
			defaults :{
				width: 280,
				labelWidth:120,
				labelAlign: 'top'
			},
			items:[{
				xtype:'displayfield',
				name:'studentName',
				fieldLabel:'<b>'+getExaminationTranslation('STUDENT_NAME')+'</b>'
			},{
				xtype:'displayfield',
				name:'examinationUniqueCode',
				hidden:true,
				fieldLabel:'<b>'+getExaminationTranslation('UNIQUE_CODE')+'</b>'
			},{
				xtype:'displayfield',
				name:'course',
				fieldLabel:'<b>'+getExaminationTranslation('COURSE')+'</b>'
			},{
				xtype:'displayfield',
				name:'courseVariant',
				fieldLabel:'<b>'+getExaminationTranslation('COURSE_VARIANT')+'</b>'
			},{
				xtype:'hidden',
				name:'courseId',
			}]
		},
		{
			xtype: 'fieldcontainer',
			layout: {
				type: 'hbox'
			},
			defaults :{
				width: 280,
				labelWidth:120,
				labelAlign: 'top'
			},
			items:[{
				xtype:'displayfield',
				name:'evalPlanNo',
				fieldLabel:'<b>'+getExaminationTranslation('EVALUATION_PLAN')+'</b>'
			},{
				xtype:'displayfield',
				name:'detailSequence',
				fieldLabel:'<b>'+getExaminationTranslation('DETAIL_SEQUENCE')+'</b>'
			},{
				xtype:'displayfield',
				name:'weightage',
				fieldLabel:'<b>'+getExaminationTranslation('WEIGHTAGE')+'</b>'
			}]
		},
		{
			xtype: 'fieldcontainer',
			layout: {
				type: 'hbox'
			},
			defaults :{
				width: 280,
				labelWidth:120,
				labelAlign: 'top'
			},
			items:[{
				xtype:'displayfield',
				name:'minPassMarks',
				fieldLabel:'<b>'+getExaminationTranslation('MIN_PASSING_MARKS')+'</b>'
			},{
				xtype:'displayfield',
				name:'maxMarks',
				itemId: 'maxMarksDisplayFieldItemId',
				fieldLabel:'<b>'+getExaminationTranslation('MAXIMUM_PASSING_MARKS')+'</b>'
			},{
				xtype:'displayfield',
				name:'effectiveWeightage',
				fieldLabel:'<b>'+getExaminationTranslation('EFFECTIVE_WEIGHTAGE')+'</b>'
			},{
				xtype:'hidden',
				name:'marksOrGrade',
				itemId: 'marksOrGrade',
			}]
		}]
	},{
		 xtype: 'grid',
	     autoScroll:true,
	     name:'marksObtainedDetailGrid',
	     itemId:'marksObtainedDetailGridId',
	     frame:false,
	     border:true,
	     store: 'examinationcenters.evaluation.coverageDetails.StudentMarkObtainedDataStore',
		features: [{
			ftype: 'summary',
			showSummaryRow:CONSTANTS.SHOW_SUMMARY_ROW 
		}],
		viewConfig : {
			stripeRows : CONSTANTS.STRIPEROWS
		},
        columns: [{
	        header: getCBTranslation('structure_level_two_questionNumber'),
	        dataIndex: 'levelName',
	        flex:.2,
	        sortable: true,
			summaryRenderer: function(value, summaryData, dataIndex) {
				return getFeeAndPaymentCommonTranslation('TOTAL');
			}
	    },{
	        header: getExaminationTranslation('MAXIMUM_MARKS'),
	        dataIndex: 'marks',
	        flex:.1,
	        sortable: true,
	        renderer:function(value,meta,record){
				if(!isNullOrEmpty(value)) {
					return value;
				} else {
					return "-"
				}                    
			}, 
	     },{
	         header: getExaminationTranslation('OBTAINED_MARKS'),
	         dataIndex: 'obtainedMarks',
	         flex:.1,
	         summaryType: 'sum',
	          sortable: true,
	          renderer:function(value,meta,record){
	        	  if(!isNullOrEmpty(value)) {
						return value;
					} else {
						return "-"
					}                   
				}, 
				summaryRenderer: function (value, summaryData, dataIndex, rowIndex, colIndex, store, view) {
					return value.toFixed(2);
				}
	      }]
   },{
	    xtype: 'fieldcontainer',
        width:'100%',
        style:{marginLeft:'-8px'},
        style:{marginTop:'-18px'},
        cls:'windowBtnPos',
        items: [{
            xtype: 'button',
            text: getCommonTranslation('CANCEL'),
            itemId:'cancelBtn',
            ui: 'CustomBtnCancel',
            scale: CONSTANTS.BUTTONSIZE
        }]
   }]	
});