/**
 * @author sumit.meena
 */
Ext.define('Academia.view.examinationcenters.marksheet.FacultyMarksheetReportGrid', {
    //extend: 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.facultymarksheetreportgrid',
    store : 'examinationcenters.marksheet.FacultyMarksheetReportGridStore',
    border: true,
    frame:false,
    selType:'checkboxmodel',
    title:getExaminationTranslation('STUDENTS_MARKSHEETS_LIST'),
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
    selModel: {
		 showHeaderCheckbox: true,
	     checkOnly : true, //I have option checkOnly: true that mean rows can only be selected by clicking on the checkbox column.
	     allowDeselect: true,
	     //injectCheckbox:1
    },
    headerFix:{
    	headerFix: true,
    	portalIdsWithStructure: {
    		'facultymarksheetreportsearchtab': 2
    	}
    },
    dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
	        xtype: 'custompagingtoolbar',
            plugins:['pagesize'],
		    store : 'examinationcenters.marksheet.FacultyMarksheetReportGridStore',
		    emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
		    displayInfo : true
		}]
	}],
	/*dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
		        xtype: 'custompagingtoolbar',
	            plugins:['pagesize'],
	            store : 'examinationcenters.marksheet.StudentMarksheetStore',
			    emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			    displayInfo : true
		}]
	}],*/
	initComponent: function() {
        var grid=this;                   
        grid.addExportToolBarItems(grid,false);
        this.callParent(arguments);     
 },
    tbar: [{	
		xtype:'fieldcontainer',
		layout : 'hbox',
		cls:'windowBtnPos',
		defaults: {
			labelAlign:'top',
		},
		items:[{
			xtype: 'button',
			itemId: 'btnSetupMarksheetJob',
			tooltip: getExaminationTranslation('SETUP_MARKSHEET_JOB'),
			ui: 'CustomBtnSubmit',
	        scale: CONSTANTS.BUTTONSIZE,
	        text:getExaminationTranslation('SETUP_MARKSHEET_JOB'),
//			style:{
////					marginLeft:'5px',
//					marginRight:'10px'
//			}
		}]
	},{
    	xtype: 'button',
		itemId: 'btnUncheckedAll',
		disabled:true,
		text:getExaminationTranslation('UNCHECK_ALL')
	},{
    	/*xtype: 'button',
		itemId: 'btnStudent',
		text:getExaminationTranslation('MAP_STUDENTS')
	},{*/
    	xtype: 'button',
		itemId: 'btnGenerateMarksheet',
		disabled:true,
		text:getExaminationTranslation('GENERATE_MARKSHEET')
	},{
		xtype: 'button',
		itemId: 'btnPublishMarksheet',
		disabled:true,
		text:getExaminationTranslation('PUBLISH_MARKSHEET')
	},'->',{
		xtype: 'button',
		itemId: 'btnDownloadAllMarksheet',
		disabled:true,
		text:getExaminationTranslation('DOWNLOAD_ALL')
	}],
    columns: [{
            header : getExaminationTranslation('STUDENT_ID'),
  	       dataIndex : 'studentCode',
  	       flex:1
  	  },{
		  	header : getExaminationTranslation('ADMISSION_NO'),
		  	dataIndex : 'admissionCode',
		  	flex:1
       },{
            header : getExaminationTranslation('STUDENT_NAME'),
	        dataIndex : 'studentName',
	        flex:1
       },{
    	   header : getCommonTranslation('FIRST_NAME'),
    	   dataIndex : 'firstName',
    	   flex : 1,
			hidden :true
       },{
			header : getCommonTranslation('MIDDLE_NAME'),
			dataIndex : 'middleName',
			flex : 1,
			hidden :true
       },{
    	   header : getCommonTranslation('LAST_NAME'),
    	   dataIndex : 'lastName',
    	   flex : .6
	},{
           header : getExaminationTranslation('PROGRAM'),
	       dataIndex : 'programName',
	       flex: .8
       },{
           header : getExaminationTranslation('BATCH'),
	       dataIndex : 'batchName',
	       flex: .6
       },{
           header : getExaminationTranslation('PERIOD'),
	       dataIndex : 'periodName',
	       flex:1,
	       hidden:true
       },{
           header : getExaminationTranslation('SECTION'),
	       dataIndex : 'sectionName',
	       flex: .5
       },{
           header : getExaminationTranslation('REPORT_CARD_JOB'),
	       dataIndex : 'marksheetJobName',
	       flex:1
       },{
           header : getExaminationTranslation('REPORT_CARD_LEVEL'),
	       dataIndex : 'marksheetLevelName',
	       flex:1
       },{
	       header : getExaminationTranslation('REPORT_CARD'),
		   dataIndex : 'marksheetPath',
		   flex:1.5,
		   renderer:function(value){
			   if(!isNullOrEmpty(value)){
				   return "<a href='#'>"+value+"</a>";
			   }
		   }
	 }],
	   // listeners : {
	        /*select: function (obj, record,rowIndex, e) {
	        	*//**
	        	 * this condition is for student's can't selected with students whose marksheet already created.   
	        	 *//*
	        	if(obj.selected.items.length>1){
	        		var newLength=obj.selected.items.length-2;
	        		if((!obj.selected.items[newLength].data.isStudentMapped && record.data.isStudentMapped) ||
	        		    (!record.data.isStudentMapped && obj.selected.items[newLength].data.isStudentMapped)){
                            obj.deselect(record);
		  	    	  showWarningMessage(getCommonTranslation('ALERT'),getExaminationTranslation('STUDENT_MARKSHEET_WITHOUT_MARKSHEET_CANNOT_BE_SELECTED_TOGETHER'));
	        	   }
	        	}
	        }*/
	  //  }
});
