/**
 * @author bhanu pratap singh
 */
Ext.define('Academia.view.examinationcenters.questionPaperBank.MeetingDocumentGrid', {
	extend : 'Ext.grid.Panel',
	alias : 'widget.meetingdocumentgrid',
	border: true,
	autoScroll: false,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	tbar: [
	{
		xtype : 'button',				
		itemId : 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip :getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH		
	}],
	columns :[{
		header : getCommonTranslation('DOCMENT_NAME'),
		dataIndex : 'documentName',
		flex:1,
		sortable:false,
		renderer:function(value,rec){
			var id=rec.record.data.id;
			if(id!=""&&id!=undefined){
				return '<a href="#">'+value+'</a>';
			}else{
				return value;
			}
		}
	}],
	initComponent: function() {
    	var this$ = this;
    	Ext.apply(this$, {
            store: Ext.create('Academia.store.course.QuestionPaperBankDocument')            
        });
    	this$.callParent(arguments);
    }
});

