/**
 * @author Rohit Sharma
 */
Ext.define('Academia.view.examinationcenters.reports.GradeAverageReportForm',{
	extend: 'Academia.view.common.IdGeneratorCustomForm',
	alias: 'widget.gradeaveragereportform',
	method: 'POST',
	margin: 0,
	layout: {
		type: 'vbox'
	},
	defaults: {
		labelAlign: 'top',
		autoScroll:true,
	},
	plugins:"formlabelrequired",
	standardSubmit: false,
	items: [{
		xtype: 'fieldcontainer',
		layout: {
			type: 'hbox'
		},
		defaults: {
			labelAlign: 'top',
			width: 226
		},
		items: [{
			xtype: 'customcombobox',
			itemId:'gradeAverageReportFilterId',
			name: 'gradeAverageReportFilter',
			store:'setup.templatemapping.TemplateNameListFacultyByCode',//'examinationcenters.marksheet.MarksheetGenerationTemplate',
			displayField:'code',
			valueField:'id',
			forceSelection:true,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			typeAhead:true,
			minChars:3,
			listConfig: {
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				},
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				}
			},
			allowBlank:false,
			fieldLabel:getCommonTranslation('REPORT_TYPE')
		}]
	}, {
		xtype: 'fieldcontainer',
		layout: {
			type: 'hbox'
		},
		defaults: {
			labelAlign: 'top',
			width: 226
		},
		items: [{
			xtype: 'customcombobox',
			itemId:'sortById',
			name: 'sortById',
			//store:'examinationcenters.calculateAverage.GradeAverageReportEvalLevelTypeListStore',
			store: Ext.create('Ext.data.Store', {
				model: 'Academia.model.common.IdValueCodeDataModel',
			    data: []
			}),
			queryMode: 'local',
			displayField:'value',
			valueField:'value',
			forceSelection:true,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			typeAhead:true,
			minChars:3,
			listConfig: {
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}' +
					'</div>';
				},
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				}
			},
			allowBlank:false,
			disabled: true,
			hidden: true,
			fieldLabel: getExaminationTranslation('REPORT_SORTING_BY')
		}]
	}, {
		xtype: 'fieldcontainer',    
		layout : {
			type : 'hbox'
		},
		width:'auto',
		items : [{
			xtype : 'button',
			text : getExaminationTranslation("SUBMIT") ,
			itemId : 'submitBtn',
			ui : 'CustomBtnSubmit',
			buttonAlign: 'left',
			//margin: '5px 0px 0px 105px',
			scale : CONSTANTS.BUTTONSIZE,
			formBind : true
		}]
	}]
});