/**
 * @author Bhanu
 */
Ext.define('Academia.view.examinationcenters.reports.MarksheetReportGrid',{ 
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.marksheetreportgrid',
	store :  'examinationcenters.reports.MarksheetReportStore',
	title : getExaminationTranslation('MARKSHEET_REPORT'),
	border: true,
	refreshStoreData:true,
	isGridConfigurable: true,
	enableColumnHide: false,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store :  'examinationcenters.reports.MarksheetReportStore',
			emptyMsg :getFeeAndPaymentCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
        var grid=this;                   
        grid.addExportToolBarItems(grid,false);
        this.callParent(arguments);     
   },
   tbar : ['->',{
		xtype : 'button',
		itemId : 'exportReportsId',
		tooltip : getCommonTranslation('EXPORTREPORTS'),
		text : getCommonTranslation('EXPORTREPORTS'),
		formBind:true,
	}],
	columns: [
	{
		header : getCommonTranslation('ADMISSION_CODE'),
		dataIndex : 'admissionCode',
		flex : 1
	},
	{
		header : getCommonTranslation('STUDENT_CODE'),
		dataIndex : 'studentCode',
		flex : 1
	},
	{
		header : getCommonTranslation('STUDENT_NAME'),
		dataIndex : 'studentName',
		flex : 1
	},{
		header : getCommonTranslation('FIRST_NAME'),
		dataIndex : 'firstName',
		flex : 1,
		hidden :true
	},{
		header : getCommonTranslation('MIDDLE_NAME'),
		dataIndex : 'middleName',
		flex : 1,
		hidden :true
	},{
		header : getCommonTranslation('LAST_NAME'),
		dataIndex : 'lastName',
		flex : 1
	},
	{
		header :getCommonTranslation('COURSE_NAME'),
		dataIndex : 'courseName',
		flex : 1
	},
	{
		header : getCommonTranslation('EVALUATION_PLAN_NUMBER'),
		dataIndex : 'evaluationPlanName',
		flex : 1
	},
	{
		header : getCommonTranslation('EVALUATION_TYPE'), 
		dataIndex : 'evaluationTypeName',
		flex : 1
	},
	{
		header : getCommonTranslation('EVALUATION_SUB_TYPE'),
		dataIndex : 'evaluationSubTypeName',
		flex : 1
	},
	{
		header : getCommonTranslation('EVALUATION_METHOD'),
		dataIndex : 'evaluationMethodName',
		flex : 1
	},
	{
		header : getCommonTranslation('EVENT_NAME'),
		dataIndex : 'evaluationEventName',
		flex : 1,
		hidden :true
	},
	{
		header : getCommonTranslation('OUT_OF_MARKS'),
		dataIndex : 'outOfMarks',
		flex : 1
	},
	{
		header : getCommonTranslation('PENALTY_MARKS'),
		dataIndex : 'penultyMarksGiven',
		flex : 1,
		hidden:true
	},
	{
		header : getCommonTranslation('GRACE_MARKS'),
		dataIndex : 'graceMarksGiven',
		flex : 1,
		hidden:true
	},
	{
		header : getCommonTranslation('MARK_OBTAINED'),
		dataIndex : 'obtainedMarks',
		flex : 1
	},
	{
		header : getCommonTranslation('RESULT_STATUS'),
		dataIndex : 'examResultStatus',
		flex : 1,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value))
				return getExaminationTranslation(value);
			else
				return '';
		}
	}]
});
