/**
 * @author AkasH 
 */
Ext.define('Academia.view.examinationcenters.reports.PeriodWiseExamReportSearchForm',{
	extend:'Ext.form.FormPanel',
	alias:'widget.periodwiseexamreportsearchform',
	autoScroll:false,
	frame:false,
	cls:'customSearchPanel',
	method:'POST',
	standardSubmit:false,
	defaults:{
		labelAlign:'top',
		width:226
	},
	plugins:"formlabelrequired",
	items:[{
		xtype:'fieldcontainer',
		width:'100%',
		layout:'hbox',
		defaults:{
			labelAlign:'top',
			width:226
		},
		items:[{
			xtype: 'customcombobox',
			name: 'studentId',
			itemId: 'periodWiseStudentItemId',
			store:'examinationcenters.reports.PeriodWiseExamLevelReportStudentStore',
			fieldLabel:getExaminationTranslation('ADMISSION_CODE_STD_NAME_STD_CODE'),
			valueField: 'id',
			displayField: 'valueCode',
			queryParam:'name',
			minChars:3,
			width:460,
			typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code} / {value}' +
					'</div>';
				}
			}
		},{
    		xtype: 'customcombobox',
			name:'studentStatus',
			itemId:'studentStatus',
			fieldLabel: getCommonTranslation('STATUS'),
			minChars:3,
			typeAhead:false,
			value:true,
			 valueField: 'value',
             displayField: 'name',
			forceSelection:true,
			store:'common.picklist.StudentActiveInactiveStatusStore',
			disabled:false,
    	}]
	},{
    	xtype: 'fieldcontainer',
    	width: 'auto',
    	layout: 'hbox',
    	defaults: {
    		width: 226,
    		labelAlign: 'top'
    	},
    	items : [{
			xtype : 'customcombobox',
			fieldLabel : getCommonTranslation('INTAKE_YEAR'),
			name : 'intakeYear',
			itemId : 'intakeYear',
			displayField:'value',
			valueField:'id',
//			width:226,
			typeAhead:true,
			forceSelection:true,
			minChars:3,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}'  +
					'</div>';
				}
			},
			listeners  :{
				render : function(combo){
					var store=Ext.create('Academia.store.common.IntakeYearStore');
					combo.bindStore(store)
				}
			}
		},{
			xtype : 'customcombobox',
			fieldLabel : getCommonTranslation('ACADEMIC_TERM'),		
			name : 'academicTerm',
			itemId : 'academicTerm',
			displayField : 'value',
			valueField : 'id',
			typeAhead : true,
			forceSelection : true,
			hidden : false,
			listeners  :{
				render : function(combo){
					var store=Ext.create('Academia.store.common.AcademicTermStore');
					combo.bindStore(store)
				}
			}
		}]
    },{	
		xtype:'fieldcontainer',
		width: '100%',
		layout : 'hbox',
		defaults: {
			labelAlign:'top',
			width:226
		},
		items:[{
			xtype: 'customcombobox',
			name:'programId',
			itemId:'periodWiseProgramItemId',
			store:Ext.create('Academia.store.examinationcenters.reports.ExamRankReportProgramStore'),
			fieldLabel:getCommonTranslation('PROGRAM_CODE_OR_NAME'),
			valueField: 'id',
			displayField: 'valueCode',
			queryParam:'name',
			minChars:3,
			allowBlank:false,
			typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				},
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
			}
		},{
			xtype: 'customcombobox',
			name:'batchId',
			itemId:'PeriodWiseBatchItemId',
			store:Ext.create('Academia.store.examinationcenters.reports.ExamRankReportBatchStore'),
			fieldLabel:getExaminationTranslation('BATCH'),
			valueField: 'id',
			displayField: 'value',
			queryParam:'name',
			minChars:3,
			disabled:true,
			allowBlank:false,
			typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				},
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
			}
		},{
			xtype: 'customcombobox',
			name: 'periodId',
			itemId: 'periodItemId',
			disabled:true,
			store:Ext.create('Academia.store.examinationcenters.reports.ExamRankReportPeriodStore'),
			fieldLabel:getExaminationTranslation('PERIOD'),
			valueField: 'id',
			displayField: 'value',
			queryParam:'name',
			minChars:3,
			typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listeners: {
				blur: function(combo) {
					var store = combo.getStore();
					var rawValue = combo.getRawValue();
					
					if (store.isLoading()) {
						store.on('load', function() {
							validateCombo(combo, rawValue);
						}, this, { single: true });
					} else {
						validateCombo(combo, rawValue);
					}

					function validateCombo(combo, rawValue) {
						var record = store.findRecord(combo.displayField, rawValue);

						if (!record) {
							combo.reset();
							combo.clearValue();
						}
					}
				}
			},
			listConfig: {
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				},
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				
			}
		}]	
	},{
		xtype : 'fieldcontainer',
		width : 'auto',
		cls : 'windowBtnPos',
		items: [{
			xtype: 'button',
			text: getCommonTranslation('SEARCH'),
			itemId: 'searchBtn',
			buttonAlign: 'left',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE,
			formBind : true
		},{
			xtype: 'button',
			text: getCommonTranslation('RESET'),
			itemId: 'resetBtn',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE   
		}]	
	}
	]
});