/**
 * @author Raghavendra.Soni
 */
Ext.define('Academia.view.examinationdegreeremark.DegreeClassificationRemarksGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.degreeclassificationremarksgrid',
    title: getCommonTranslation('LIST_OF_REMARKS'),
    store:'examinationdegreeremark.DegreeClassificationRemarksGridStore',
    border: true,
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
   tbar: [{
       xtype: 'button',
       itemId: 'btnAdd_cr',
       tooltip: getCommonTranslation('ADD'),
       glyph: ICONGLYPH.ADDGLYPH,
       disabled: true
   }, {
       xtype: 'button',
       itemId: 'btnEdit_cr',
       tooltip: getCommonTranslation('EDIT'),
       glyph: ICONGLYPH.EDITGLYPH,
       disabled: true
   }, {
       xtype: 'button',
       itemId: 'btnDelete_cr',
       tooltip: getCommonTranslation('DELETE'),
       glyph: ICONGLYPH.DELETEGLYPH,
       disabled: true
   }],
    columns: [{
        header: getCommonTranslation('REMARKS'),
        dataIndex: 'remarks',
        flex:1
    },{
        header: getCommonTranslation('RECOMMENDATION_DECISION'),
        dataIndex: 'recommendation',
        flex:1,
        hidden:true
    },{
        header: getCommonTranslation('RANGE_FROM'),
        dataIndex: 'CGPAOrPercentageRangeFrom',
        flex:1
    }, {
        header: getCommonTranslation('RANGE_TO'),
        dataIndex: 'CGPAOrPercentageRangeTo',
        flex:1
   }
 //   ,{
//        header: getCommonTranslation('GRAPH_COLOR'),
//        dataIndex: 'graphColor',
//        flex:1,
//        hidden:true
//    }
    ],
    initComponent: function() {
        var this$ = this;
        Ext.apply(this$, {
            store: 'examinationdegreeremark.DegreeClassificationRemarksGridStore',
            dockedItems: [{
                xtype: 'toolbar',
                dock: 'bottom',
                items: [{
                    xtype: 'custompagingtoolbar',
                    plugins: ['pagesize'],
                    store: 'examinationdegreeremark.DegreeClassificationRemarksGridStore',
                    emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
                    displayInfo: true
                }]
            }]
        });
        this$.addExportToolBarItems(this$);
        this$.callParent(arguments);
    }
});