/*
 *@author Niklesh Tiwane
 * 
 * This Component is used for to Add Alumni Resource Booking. 
 */
//var eventPurposeStore = Ext.create('Ext.data.Store', {
//    fields: ['value', 'id'],
//    data: [{ 
//		value:getAlumni('NON_ACADEMIC'), 
//		id:'2'
//	}]
//});
var eventPurposeStore = Ext.create('Ext.data.Store', {
    fields: ['value', 'id'],
    data: [{ 
		value:getAlumni('NON_ACADEMIC'), 
		id:'2'
	}]
});
Ext.define('Academia.view.facilitiesresources.resourcebooking.AlumniResourceBookingFormLayout', {
    extend: 'Academia.view.common.IdGeneratorForm',
    alias: 'widget.alumniresourcebookingformlayout',
    //cls: 'panelNoSpace',
    //formCode:'ResourceBookingFormLayout',
    //autoScroll: true,
    frame: true,
    style:{
    	marginLeft:CONSTANTS.MARGIN_LEFT_FOR_FORM
    },
    marginBottom: 0,
    itemId: 'alumniresourcebookingform',
    title: getAlumni('ADD_NEW_EVENT_DETAILS'), //Add New Event Details
    plugins: "formlabelrequired",
    method: 'POST',    
    standardSubmit: false,
    minWidth:800,
        items: [{
            layout: {
                type: 'hbox'
            },
            width: 850,
            items: [{
                flex: .2,
                defaults: {
                	width: 226,
                    labelAlign: 'top'
                },
                items: [{
                    xtype: 'hidden',
                    itemId: 'versionId_hidden_field',
                    name: 'version'
                },{
                    xtype: 'hidden',
                    itemId: 'eventCalendarId',
                    name: 'eventCalendarId'
                },{       
                	xtype: 'hidden',
                    itemId: 'ID',
                    name: 'id'
                }, {
                    xtype: 'textfield',
                    name: 'resourceCategoryCode',
                    itemId: 'resourceCategoryCode',
                    fieldLabel: getAlumni('EVENT_ID'),
                    emptyText: getCommonTranslation('ID_AUTOGENERATE'),
                    maxLength: 10,
                    readOnly: true,
                    //allowBlank: false		
                },{
                    xtype: 'textfield',
                    name: 'eventName',
                    fieldLabel: getAlumni('EVENT_NAME'),
                    allowBlank: false,
                    maxLength: 255
                },{
                    xtype: 'textfield',
                    name: 'conductedBy',
                    itemId: 'cmbconductedBy',
                    fieldLabel: getAlumni('CONDUCTED_BY'),
                    visible:false,
                    hidden:true,
                },
                {
                    xtype: 'datefield',
                    name: 'eventDate',
                    itemId: 'eventDate',
                    vtype: 'daterange',
                    fieldLabel: getAlumni('EVENT_DATE'),
                    editable: false,
                    allowBlank: false,
                    minValue: new Date(), // Set the minimum value to the current date
                    listeners: {
                        render: function(field) {
                            // Ensure date format rendering
                            dateFormatRender(field);

                            // Dynamically update the minValue to today's date (optional redundancy)
                            field.setMinValue(new Date());
                        },
                        change: function(field, newValue) {
                            // Get the last registration date field
                            var lastRegistrationDateField = field.up('form').down('#lastRegistrationDateId');
                            var toDate = field.up('form').down('#toDate');
                            // Update the maxValue of the last registration date field based on event date
                            if (newValue) {
                                lastRegistrationDateField.setMaxValue(newValue); // Set max to event date
                            } else {
                                lastRegistrationDateField.setMaxValue(null); // Clear maxValue if event date is cleared
                            }
                            
                            if (newValue && toDate) {
                            	toDate.setMinValue(newValue);  // Set the end date's minimum value based on start date
                            }
                        }
                    }
                },
                {
                    xtype: 'numberfield',
                    name: 'noOfParticipants',
                    itemId:'numOfParticipants',
                    fieldLabel: getAlumni('PARTICIPANTS'),
                    maxLength: 5,
                    minValue:0,
                    value:0,
                    allowBlank: false,
                    validator: function(value){
                    	var validText = getAlumni('ENTER_ONLY_INTEGER_NUMBER');
                    	var patt = new RegExp('^[0-9]+$');
                    	var res = patt.test(value);
                        if(res) {
                            return true;
                        } else {
                            return validText;
                        }
                    }
                },{
                    xtype: 'textareafield',
                    name: 'eventDesc',
                    fieldLabel: getAlumni('EVENT_DESC'),
                    maxLength: 255,
                    //flex: .2,
                    allowBlank: false
            	 }]
            }, {
                flex: .2,
                defaults: {
                    width: 226,
                    labelAlign: 'top'
                },
                items: [{
                	xtype: 'customcombobox',
                    name: 'bookingPurpose',
                    itemId: 'cmbBookingPurpose',
                    fieldLabel: getAlumni('EVENT_PURPOSE'),
                    store: eventPurposeStore,
                    valueField: 'id',
                    displayField: 'value',
                    editable: false,
                    //queryMode: 'local',
                    triggerAction: 'all',
                    forceSelection: true,
                    readOnly: true,
                    style: {
                        marginTop: '2px',
                    }
                }, 
                {
					xtype : 'fieldcontainer',
					layout : 'hbox',
					defaults : {
						labelAlign : 'top'
					},
					style:{
					    marginBottom: '5px',
				    	marginTop: '-5px',
					},
					items : [{
	                    xtype: 'checkboxfield',
	                    boxLabel: getAlumni('COMPLETE_DAY'),
	                    name: 'isCompleteDay',
	                    checked: true,
	                    inputValue: 'true',
	                    uncheckedValue: 'false',
	                    itemId: 'chkCompleteDay',
	                    style:{
	                    	marginTop:'26px'
	                    }
	                }, {
	                    xtype: 'checkboxfield',
	                    boxLabel: getAlumni('RECURRING'),
	                    name: 'isRecurring',
	                    inputValue: 'true',
	                    uncheckedValue: 'false',
	                    itemId: 'chkRecurring',
	                    style:{
	                    	marginTop:'25px',
	                    	marginBottom:'6px',
	                    }
	                }]
                },
                {
                	xtype: 'datefield',
                    name: 'toDate',
                    itemId: 'toDate',
                    vtype: 'daterange',
                    startDateField: 'eventDate',
                    fieldLabel: getAlumni('TO_DATE'),
                    editable: false,
                    disabled:true,
                    allowBlank: false,
                    minValue: new Date(),
                    listeners: {
                    	render: function(field) {
                    		return dateFormatRender(field);
                    	},
                    	 change: function (field, newValue) {
         		            // Get the end date field
         		            var endDateField = field.up('form').down('#lastRegistrationDateId');
         		            // Set the minValue of the end date field to disable dates before start date
         		            if (newValue) {
         		                endDateField.setMaxValue(newValue);
         		            } else {
         		                endDateField.setMaxValue(null);
         		            }
         		        }
                    },
                    
                }, {
                    xtype: 'textfield',
                    name: 'venue',
                    fieldLabel: getAlumni('VENUE'),
                    //maxLength: 250,
                    allowBlank: true,
                    maxLength: 45
                },{
            	xtype: 'textareafield',
            	name: 'purposeDesc',
            	fieldLabel: getAlumni('PURPOSE_DETAIL'),
            	maxLength: 255,
            	width: 226,
            }
			]
            }, {
                flex: .2,
                defaults: {
                    width: 226,
                    labelAlign: 'top'
                },
                items: [{
        			xtype: 'customcombobox',
        			name: 'committee',
        			itemId:'committeeItemId',
        			//store:'committee.committee.CommitteeStore',
        			displayField:'valueCode',
        			valueField:'id',
        			queryParam:'name',
        			hidden:true,
        			//allowBlank:false,
        			typeAhead:false,
        			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
        			enableKeyEvents  : 'true',
        			hideTrigger:false,
        			minChars:3,
        			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
        			triggerAction: '',
        			forceSelection:true,
        			listConfig: {
        				listeners: {
        					beforeshow: function(picker) {
        						picker.minWidth = picker.up('combobox').getSize().width;
        					}
        				},
        				loadingText: getCommonTranslation('SEARCHING'),
        				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
        				getInnerTpl: function() {
        					return '<div class="search-item">' +
        					'{value}' +
        					'</div>';
        				}
        			},
        			fieldLabel:getAlumni("COMMITTEE_CODE_NAME")
        		},{
                    xtype: 'customcombobox',
                    name: 'bookedBy',
                    itemId: 'cmbBookedBy',
                    fieldLabel: getAlumni('BOOKED_BY'),
                    store: 'common.ActiveUserStore',
                    valueField: 'id',
                    displayField: 'valueCode',
                    allowBlank: false,
                    queryParam:'name',
    				minChars:3,
    				typeAhead:false,
    				forceSelection:true,
//    				triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
    				//triggerAction: '',
    				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
//    	            maxLength: 100,
    				listConfig: {
    					listeners: {
		                    beforeshow: function (picker) {
		                        picker.minWidth = picker.up('combobox').getSize().width;
		                        picker.maxWidth = picker.up('combobox').getSize().width;
		                    }
		                },
    					loadingText: getCommonTranslation('SEARCHING'),
    					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    					getInnerTpl: function() {
    						return '<div class="search-item">' +
    						'{value}' +
    						'</div>';
    					}
    				}
        	        
                },{
                    xtype: 'multiselectcombofield',
                    name: 'repeatOn',
                    itemId: 'repeatOnItemId',
                    fieldLabel: getAlumni('EVENT_REPEAT_ON'),
                    //autoloadStore: false,
                    store: 'transport.serviceRoute.WeekDays',
                    cls:'multiBrandCampusCls',
                    displayField: 'value',
                    valueField: 'id',
                    allowBlank: true,
                    hidden:true,
                    minChars: 3,
                    typeAhead: true,
                    triggerCls: Ext.baseCSSPrefix + 'x-form-trigger',
                    enableKeyEvents: 'true',
                    hideTrigger: false,
                    forceSelection: true,
                    listConfig: {
                        listeners: {
                            beforeshow: function(picker) {
                                picker.minWidth = picker.up('combobox').getSize().width;
                            }
                        },
                        loadingText: getCommonTranslation('SEARCHING'),
                        emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                        getInnerTpl: function() {
                            return '<div class="search-item">' +
                                '{code}' +
                                '</div>';
                        }
                    }
                },{
					xtype : 'fieldcontainer',
//					width: 'auto',
					layout : 'hbox',
					defaults : {
						labelAlign : 'top'
					},
					items : [{
                    xtype: 'timefield',
                    name: 'timeFrom',
                    itemId: 'timeFrom',
                    fieldLabel: getAlumni('TIME_FROM'),
                    submitFormat: CONSTANTS.DISPLAY_TIME_FORMAT,
                    increment: 30,
                    width:105,
                    disabled: true,
                    vtype: 'timerange',
                    endTimeField: 'timeTo',
                    allowBlank: false,
    				listeners: {
    					render: function(field) {
    						return timeFormatRender(field);
    					}
    				}
                }, {
                    xtype: 'timefield',
                    name: 'timeTo',
                    itemId: 'timeTo',
                    fieldLabel: getAlumni('TIME_TO'), 
                    submitFormat: CONSTANTS.DISPLAY_TIME_FORMAT, //Select to time
                    increment: 30,
                    width:105,
                    disabled: true,
                    vtype: 'timerange',
                    startTimeField: 'timeFrom',
                    allowBlank: false,
    				listeners: {
    					render: function(field) {
    						return timeFormatRender(field);
    					}
    				}		
                }]
				},{
					xtype: 'numberfield',
                    name: 'eventBudget',
                    itemId:'eventBudget',
                    fieldLabel: getServiceRequestTranslation('EVENT_BUDGET'),
                    maxLength: 6,
                    minValue:0,
                    value:0,
                    allowBlank: true,
                    validator: function(value){
                    	var validText = getCommonTranslation('ENTER_ONLY_INTEGER_NUMBER');
                    	var patt = new RegExp('^[0-9]+$');
                    	var res = patt.test(value);
                        if(res) {
                            return true;
                        } else {
                            return validText;
                        }
                    }
                },{
                	xtype: 'datefield',
                	name: 'lastRegistrationDate',
                	itemId: 'lastRegistrationDateId',
                	fieldLabel: getAlumni('LAST_REGISTRATION_DATE'), // To Date
                	editable: false,
                	allowBlank: false,
                	minValue: new Date(), // Set minimum to today's date
                	listeners: {
                	    render: function (field) {
                	        return dateFormatRender(field);
                	    },
                	    change: function (field, newValue) {
                	        var form = field.up('form'); // Get the parent form
                	        var eventDateField = form.down('#eventDate');
                	        var toDateField = form.down('#toDate');
                	        
                	        if (toDateField && toDateField.getValue() && newValue > toDateField.getValue()) {
                	            // If the date exceeds the "To Date"
                	            field.markInvalid('Last Registration Date cannot be after the Event Last Date.');
                	            return;
                	        }
                	        else if (eventDateField && eventDateField.getValue() && newValue > eventDateField.getValue()) {
                	            // If the date exceeds the "Event Date"
                	            field.markInvalid('Last Registration Date cannot be after the Event Date.');
                	            return;
                	        }
                	        
                	        // Clear any previous invalid status if valid
                	        field.clearInvalid();
                	    }
                	}

                },{
                    xtype: 'checkboxfield',
                    boxLabel: getAlumni('MANDATORY_EVENT'), //This event is mandatory
                    name: 'isMendatory',
                    inputValue: 'true',
                    uncheckedValue: 'false',
                    itemId: 'isMandatoryEvent',
                    style:{
                    	marginTop:'25px'
                    }
                }]
            }]
        },{
          	 xtype: 'fieldcontainer',
        	 layout : 'hbox',
        	 style:{
             	marginTop: '-70px',
             	marginLeft: '20px'
             },
        	 defaults: {
                 width: 226,
                 labelAlign: 'top'
             },
        	 items: [/*{
                xtype: 'textareafield',
                name: 'eventDesc',
                fieldLabel: getCommonTranslation('EVENT_DESC'), //Event Description
                maxLength: 255,
                //flex: .2,
                allowBlank: false
        	 },{ 
        		 xtype: 'tbspacer', 
        		 width: 50 
        	 },{
            	xtype: 'textareafield',
            	name: 'purposeDesc',
            	fieldLabel: getCommonTranslation('PURPOSE_DETAIL'), //Purpose Detail
            	maxLength: 255
            }*/]
        },{
        	xtype: 'fieldcontainer',
        	style:{
        		marginTop: '0px',
        		marginLeft: '20px'
        	},
        	defaults: {
        		width: 226,
        		labelAlign: 'top'
        	},
        }, {
            xtype: 'fieldcontainer',
            cls: "alumniEventBannerPre",
            style:{
            	marginTop: '0px',
            	marginLeft: '20px',
            	marginBottom: '10px'
            },
            defaults: {
                width: 460,
                labelAlign: 'top'
            },
            items: [{
                xtype: 'label',
                width: 150,
                html: "<span style='font-weight: bold;'>" + getAlumni('EVENT_BANNER') + ":</span>",
                style: {
                	marginBottom: '10px',
                	display:'inline-block'
                }
            },{
            	html: '<i>'+getAlumni('PLEASE_PREFER_IMAGE_SIZE')+'</i>',
            	margin: 0,
            },{
            	xtype: 'photouploadform',
            	itemId: 'eventBannerItemId'
            }, {
            	xtype:'image',
                itemId: 'eventBannerBgImage',
                border: 1,
                style: {
                    borderColor: 'black',
                    borderStyle: 'solid'
                },
                width: 222,
                height: 150,
                src:'resources/images/Event_Banner.png'
            },{
            	xtype:'hidden',
            	itemId: 'eventBannerURLItemId',
            	name: 'eventBannerURL'
            }]
        }, {
            items: [
//            	{                	
//  	                 title: getAlumni('ALUMNI_AVAILABLE'), //Alumni
//  	                 itemId:'alumniResourceTabPanel',
//  	                 border:1,
//  	                 name:'alumniResourceTabPanelName',
//  	                 items: [{
//                 		 xtype: 'resourcebookingalumnigrid',
//  	                     itemId: 'alumniListEventGrid',  	                    
//  	                 }]
//            	}
            	{
            		xtype: 'tabpanel',            		
            		plain: true,
            		style:{
            			overflow:'hidden !important',
//            			margin:'0!important',
            			marginTop: '35px!important',
            		},
            		name:'alumniResourceTabPanelName',
            		itemId:'alumniResourceTabPanel',
            		frame: false,
            		border:false,
            		items:[{
            			title: getAlumni('ALUMNI_AVAILABLE'),
            			layout: 'vbox',
            			defaults: {
            				width: '100%'
            			},
            			items:[{
            				xtype: 'resourcebookingalumniavailablestructure',
            			}]
            		}, {
            			title: getAlumni('MAPPED_ALUMNI'),
            			layout: 'vbox',
            			defaults: {
            				width: '100%'
            			},
            			items:[{
            				xtype: 'resourcebookingalumnimappedstructure',
            			}]
            		}]
            	}
            ]
           },{
        	xtype:'panel',
        	hidden:true,
        	frame:true,
        	header :false,            	
        	layout:{
        		type:'hbox'
        	},
        	items : [{
				xtype : 'checkboxfield',
				boxLabel : 'BOOKED',
				disabled:true
			},{
				xtype : 'checkboxfield',
				boxLabel : 'AVAILABLE',
				disabled:true,
				style: {			            
		            marginLeft: '20px'
		        } 					
			},{
				xtype : 'checkboxfield',
				boxLabel : 'PARTLY AVAILABLE',
				disabled:true,
				style: {			            
		            marginLeft: '20px'
		        } 					
			}]
        }, {
            xtype: 'fieldcontainer',
            width: '100%',
            style: {
            	marginLeft: '32px'
            },
            items: [{
                xtype: 'button',
                itemId: 'btnSaveResourceBookingForm',
                text: getAlumni('SAVE'),
                ui: 'CustomBtnSubmit',
                formBind: true,
                scale: CONSTANTS.BUTTONSIZE
            },{
                xtype: 'button',
                text: getAlumni('RESET'),
                itemId: 'gradeMasterResetButtonId',
                ui: 'CustomBtnCancel',
                scale: CONSTANTS.BUTTONSIZE,
            }]
        }]
});
